/* 
 *  Internal declarations for loadable libraries
 *
 *  Copyright (C) 1998 by Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
 
#ifndef _GGILIB3D_H_
#define _GGILIB3D_H_

#define _BUILDING_LIBGGI3D_

#include <ggi/internal/internal.h>

typedef struct ggi3d_image_t	*ggi3d_image;

#include <ggi/ggi3d.h>
#include <ggi/ggi_ext.h>

#include "debug.h"

extern int ggi3d_offset;

typedef	void	(*updatefunc)(ggi_visual_t vis, ggi_uint change);

/* mode changes: functions should be updated */
#define GGI3D_UPD_DEFAULTMODE	1

/* value changes: accelerator should be updated */
#define	GGI3D_UPD_TRIANGLE	2
#define	GGI3D_UPD_CLIP		4	
#define	GGI3D_UPD_TEXTURE	8
#define	GGI3D_UPD_ALPHA		16

#define	GGI3D_UPD_ALL		(2*GGI3D_UPD_ALPHA-1)

#define ISVALUE(change)	(change > GGI_UPD_OPERATOR)

typedef struct {
//	ggi3d_shader	shader;
//	ggi2d_image	texture;
//	ggi_alpha	alpha;
	int 		accel_changes;
} ggi3d_gc;

typedef struct {
	updatefunc update;
	ggi_uint change_mask;
} ggi3d_module; 

typedef struct {
/*------- Drawing functions (33) -------------*/
void (*triangle)(ggi_visual_t vis, 
		     ggi_float x1, ggi_float y1, ggi_float z1,
		     ggi_float x2, ggi_float y2, ggi_float z2,
		     ggi_float x3, ggi_float y3, ggi_float z3);
} ggi3d_funcs;

#define	MAX_MODULES	4

typedef struct {
	ggi_uint	version;		
	ggi_uint	modules;	/* number of loaded modules */
	ggi_uint	change_mask;	/* general mask */
	ggi3d_module	module[MAX_MODULES];
	ggi3d_gc	gc;
	ggi3d_funcs	func;
} ggi3d_data;

extern ggi_extid ggi3dID;

#define GGI3D_DATA(vis)		((ggi3d_data *)LIBGGI_EXT(vis,ggi3dID))
#define GGI3D_FUNC(vis)		(&(GGI3D_DATA(vis)->func))

#define GGI3D_GC(vis)		(GGI3D_DATA(vis)->gc)

#define GGI3D_ACCELCHANGES	(GGI3D_GC(vis).accel_changes)

#define GGI_FB_LINEAR(vis)	(vis->info.fb.linear)
#define GGI_FB_WIDTH(vis)	(vis->info.fb.width)
#define GGI_FB_BPL(vis)		(vis->info.fb.width)
#define GGI_FB_HEIGHT(vis)	(vis->info.fb.height)
#define GGI_FB_DEPTH(vis)	(vis->info.fb.depth)

void	GGI3DRegisterUpdateFunc(ggi_visual_t vis, updatefunc f, ggi_uint mask);

#define	GGIEXP(name)		GGI3D__##name
#define	GGILIB_INIT		GGIdlinit
#define	GGILIB_CLEANUP		GGIdlcleanup

#endif /* _GGILIB3D_H_ */
