/* $Id: mode.c,v 1.25 1998/10/25 12:02:16 marcus Exp $
***************************************************************************

   Graphics library for GGI.  Events for AA target.

   Copyright (C) 1997 Andreas Beck    [becka@ggi-project.org]
   Copyright (C) 1998 Steve Cheng     [steve@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>

#include "aavisual.h"
#include "../mansync/mansync.h"

int GGI_aa_getapi(ggi_visual *vis,int num, char *apiname ,char *arguments)
{
	switch(num) {
		case 0: strcpy(apiname, "display-aa");
			strcpy(arguments, "");
			return 0;
		case 1: strcpy(apiname, "generic-stubs");
			strcpy(arguments, "");
			return 0;
		case 2: strcpy(apiname, "generic-color");
			strcpy(arguments, "");
			return 0;
		case 3:
			if(LIBGGI_MODE(vis)->graphtype!=GT_8BIT)
				return -1;

			sprintf(apiname, "generic-linear-8");
			strcpy(arguments, "");
			return 0;
	}
	return -1;
}


static int _GGIdomode(ggi_visual *vis)
{
	int err,id;
	char sugname[256],args[256];

	_ggiZapMode(vis,~GGI_DL_OPDISPLAY);

	/* Palette -- it's all zero, you better call ggiSetPalette() */
	if(!vis->palette)
		vis->palette = _ggi_malloc(256*sizeof(ggi_color));

	for(id=1;0==GGI_aa_getapi(vis,id,sugname,args);id++) {
		err = (_ggiOpenDL(vis, sugname, args, NULL) == NULL);
		if (err) {
			fprintf(stderr,"display-aa: Can't open the %s (%s) library.\n",
				sugname,args);
			/* In our special case, fail is always fatal. */
			return err;
		} else {
			DPRINT("Success in loading %s (%s)\n",sugname,args);
		}
	}

	vis->opcolor->setpalvec=GGI_aa_setpalvec;

	ggiIndicateChange(vis, GGI_CHG_APILIST);

	return 0;
}

int GGI_aa_flush(ggi_visual *vis, int tryflag)
{
	struct AAhooks *aahook = AA_PRIV(vis);
	
	if (tryflag == 0) {
		if (_ggiTryLock(aahook->aalock))
			return 0;
	} else {
		_ggiLock(aahook->aalock);
	}
	
	aa_renderpalette(aahook->context,aahook->pal, &aa_defrenderparams, 0, 0, 
			aa_scrwidth(aahook->context), aa_scrheight(aahook->context));
	aa_flush(aahook->context);

	_ggiUnlock(aahook->aalock);

	return 0;
}

int GGI_aa_setmode(ggi_visual *vis,ggi_mode *tm)
{ 
	struct AAhooks *aahook; 
	
	if(GGI_aa_checkmode(vis, tm))
		return -1;

	aahook=LIBGGI_PRIVATE(vis);

	MANSYNC_ignore(vis);

	_GGI_aa_freedbs(vis);

	aa_defparams.width  = tm->virt.x/2;
	aa_defparams.height = tm->virt.y/2;
	
    	if(aahook->context)
    		aa_close(aahook->context);
    	
	aahook->context = aa_autoinit(&aa_defparams);
	if(!aahook->context)
		return -1;

	tm->visible.x = tm->virt.x=aa_imgwidth (aahook->context);
	tm->visible.y = tm->virt.y=aa_imgheight(aahook->context);

	/* Fill in ggi_pixelformat */
	LIBGGI_PIXFMT(vis)->depth = GT_DEPTH(tm->graphtype);
	LIBGGI_PIXFMT(vis)->size = GT_SIZE(tm->graphtype);
	LIBGGI_PIXFMT(vis)->clut_mask = 0xFF;

	_ggi_db_add_buffer(LIBGGI_APPLIST(vis), _ggi_db_get_new());
	LIBGGI_APPBUFS(vis)[0]->frame = 0;
	LIBGGI_APPBUFS(vis)[0]->type = GGI_DB_NORMAL | GGI_DB_SIMPLE_PLB;
	LIBGGI_APPBUFS(vis)[0]->read = 
	LIBGGI_APPBUFS(vis)[0]->write = aa_image(aahook->context);
	LIBGGI_APPBUFS(vis)[0]->layout = blPixelLinearBuffer;
	LIBGGI_APPBUFS(vis)[0]->buffer.plb.stride = tm->virt.x;
	LIBGGI_APPBUFS(vis)[0]->buffer.plb.pixelformat = LIBGGI_PIXFMT(vis);

	aa_autoinitkbd(aahook->context,AA_SENDRELEASE);
	aa_autoinitmouse(aahook->context,AA_MOUSEALLMASK);
	
	MANSYNC_cont(vis);
	
	memcpy(LIBGGI_MODE(vis),tm,sizeof(ggi_mode));

	return _GGIdomode(vis);
}

/**********************************/
/* check any mode (text/graphics) */
/**********************************/
int GGI_aa_checkmode(ggi_visual *vis,ggi_mode *tm)
{
	int err = 0;

	if (vis==NULL)
		return -1;
	
	if(tm->graphtype==GT_AUTO) tm->graphtype=GT_8BIT;
	if(tm->graphtype!=GT_8BIT) err = -1;

	if (tm->frames == GGI_AUTO) tm->frames = 1;
	if (tm->frames > 1) {
		tm->frames = 1;
		err = -1;
	}

	/* This is the *image* size, not the device dimensions!
	   Default is 80x25, like aalib itself, and every four pixels to one char */

	if(tm->visible.x==GGI_AUTO)
		tm->visible.x = tm->virt.x==GGI_AUTO? 80*2 : tm->virt.x;
	if(tm->visible.y==GGI_AUTO)
		tm->visible.y = tm->virt.y==GGI_AUTO? 25*2 : tm->virt.y;


	if(	(tm->virt.x!=tm->visible.x && tm->virt.x!=GGI_AUTO) ||
		(tm->virt.y!=tm->visible.y && tm->virt.y!=GGI_AUTO)) {
		err = -1;
	}

	tm->virt.x = tm->visible.x;
	tm->virt.y = tm->visible.y;

	if(     (tm->dpp.x!=1 && tm->dpp.x!=GGI_AUTO) ||
		(tm->dpp.y!=1 && tm->dpp.y!=GGI_AUTO)) {
		err = -1;
	}
	tm->dpp.x = tm->dpp.y = 1;

	return err;
}

/************************/
/* get the current mode */
/************************/
int GGI_aa_getmode(ggi_visual *vis,ggi_mode *tm)
{
	DPRINT("In GGI_aa_getmode(%p,%p)\n",vis,tm);
	if (vis==NULL)
		return -1;
	
	/* We assume the mode in the visual to be o.k. */
	memcpy(tm,LIBGGI_MODE(vis),sizeof(ggi_mode));

	return 0;
}

/*************************/
/* set the current flags */
/*************************/
int GGI_aa_setflags(ggi_visual *vis,ggi_flags flags)
{
	LIBGGI_FLAGS(vis)=flags;

	MANSYNC_SETFLAGS(vis,flags);

	return 0;
}
