/* 
   Linear 1 vertical lines.

   Copyright (C) 1995 Andreas Beck   [becka@ggi-project.org]
   Copyright (C) 1998 Andrew Apted  [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <string.h>

#include <ggi/internal/ggi-dl.h>


int GGIdrawvline_nc(ggi_visual *vis,int x,int y,int height)
{
	uint8 *adr;
	int i,sw,bm;

	bm=(0x80>>(x&7));
	sw=LIBGGI_FB_W_STRIDE(vis);
	adr=((uint8 *)(LIBGGI_CURWRITE(vis)));
	adr+=(x>>3)+y*sw;

	if(LIBGGI_GC_FGCOLOR(vis)&1) 
		for (i=height;i--;adr+=sw) *adr |= bm;
	else
		for (i=height;i--;adr+=sw) *adr &= ~bm;
  
	return 0;
}

int GGIputvline(ggi_visual *vis,int x,int y,int height,void *buffer)
{ 
	uint8 *adr,*buff=(uint8 *)buffer;
	int mask=0x80,sw,i,bm;

	/* Clipping */
	if (x< (LIBGGI_GC(vis)->cliptl.x) ||
	    x>=(LIBGGI_GC(vis)->clipbr.x)) return 0;
	if (y< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-y;
		y     +=diff;
		height-=diff;
		buff +=diff>>3;
		mask>>=diff&7;
	}
	if (y+height>(LIBGGI_GC(vis)->clipbr.y)) {
		height=(LIBGGI_GC(vis)->clipbr.y)-y;
	}

	bm=(0x80>>(x&7));
	sw=LIBGGI_FB_W_STRIDE(vis);
	adr=((uint8 *)(LIBGGI_CURWRITE(vis)));
	adr+=(x>>3)+y*sw;

	for (i=0;i<height;i++,adr+=sw) {
		if (*buff & mask) 
			*adr |= bm;
		else
			*adr &= ~bm;
		mask >>= 1;
		if (mask==0) {
			mask=0x80;
			buff++;
		}
	}

  	return 0;
}

int GGIgetvline(ggi_visual *vis,int x,int y,int height,void *buffer)
{ 
	uint8 *adr,*buff=(uint8 *)buffer;
	int mask,sw,i,bm;

	sw=LIBGGI_FB_R_STRIDE(vis);
	adr=((uint8 *)(LIBGGI_CURREAD(vis)));
	adr+=(x>>3)+y*sw;

	bm=(0x80>>(x&7));
	mask=0x80;
	for (i=0;i<height;i++,adr+=sw) {
		*buff |= (*adr & bm) ? mask : 0;
		mask>>=1;
		if (mask==0) {
			mask=0x80;
			buff++;
		}
	}

  	return 0;
}
