/* $Id: line.c,v 1.7 1998/09/20 21:22:17 marcus Exp $
***************************************************************************

  Graphics library for GGI.

  Copyright (C) 1995 Andreas Beck   [becka@ggi-project.org]
  Copyright (C) 1997 Jason McMullan [jmcc@ggi-project.org]

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#ifdef _AIX
#include <sys/ioctl.h>
#include <sys/types.h>
#include <unistd.h>
#endif

#include <ggi/internal/ggi-dl.h>
#include <kgi/ioctl.h>
#include <kgi/errno.h>

#define SPEED_TRESHOLD 15

/**********************
 * Drawline via IOCTL *
 **********************/

int GGIdrawline(ggi_visual *vis,int x1,int y1,int x2,int y2)
{
	int RC;
	int result;

	if ( ((abs(x2-x1) & ~SPEED_TRESHOLD) == 0) &&
	     ((abs(y2-y1) & ~SPEED_TRESHOLD) == 0) ) 
		return fallback_opdraw.drawline(vis,x1,y1,x2,y2);

	if ((RC=ioctl(vis->fd,(int)GRAPHICS_DRAWLINE,&x1))<0) 
	{ 
		result = (RC == -1) ? errno : -RC;
		if ((result&NOSUP_MASK)==NOSUP)
		{	switch(result&AVE_MASK)
			{ case AVE_NOW:
				return fallback_opdraw.drawline(vis,x1,y1,x2,y2);
			  default:
				return (vis->opdraw->drawline=fallback_opdraw.drawline)(vis,x1,y1,x2,y2);
			}
		}
	}

	return RC;
}
