""" Demonstration of the Pmw Balloon megawidget.
"""

# Import Pmw from the sibling directory.
import sys
sys.path[:0] = ['../../..']

import Tkinter
import Pmw

class Demo:
    def __init__(self, parent):
	# Create the Balloon.
	self.balloon = Pmw.Balloon(parent)

	# Create some widgets and megawidgets with balloon help.
	field = Pmw.EntryField(parent,
		labelpos = 'w',
		label_text = 'Command:')
	field.setentry('mycommand -name foo')
	field.pack(padx = 10, pady = 10)
	self.balloon.bind(field, 'Command to\nstart/stop',
		'Enter the shell command to control')

	frame = Tkinter.Frame(parent)
	frame.pack(padx = 10, pady = 10)
	start = Tkinter.Button(frame, text='Start')
	start.pack(side='left', padx = 10)
	self.balloon.bind(start, 'Start the command')

	stop = Tkinter.Button(frame, text='Stop')
	stop.pack(side='left', padx = 10)
	self.balloon.bind(stop, 'Stop the command')

	self.toggleBalloonVar = Tkinter.IntVar()
	self.toggleBalloonVar.set(1)
	toggle = Tkinter.Checkbutton(parent,
		variable = self.toggleBalloonVar,
		text = 'Balloon help', command = self.toggle)
	toggle.pack()
	self.balloon.bind(toggle, 'Toggle balloon help\non and off')

	self.toggleStatusVar = Tkinter.IntVar()
	self.toggleStatusVar.set(1)
	toggle = Tkinter.Checkbutton(parent,
		variable = self.toggleStatusVar,
		text = 'Status help', command = self.toggle)
	toggle.pack()
	self.balloon.bind(toggle, 'Toggle status help\non and off')

	canvas = Tkinter.Canvas(parent,
		width = 200,
		height = 115,
		relief = 'sunken',
		borderwidth = 2,
		)
	canvas.pack()

	item = canvas.create_arc(5, 5, 35, 35, fill = 'red', extent = 315)
	self.balloon.canvasbind(canvas, item, 'This is help for\nan arc item')
	item = canvas.create_bitmap(20, 60, bitmap = 'question')
	self.balloon.canvasbind(canvas, item, 'This is help for\na bitmap')
	item = canvas.create_line(50, 60, 70, 80, 85, 20, width = 5)
	self.balloon.canvasbind(canvas, item, 'This is help for\na line item')
	item = canvas.create_rectangle(100, 20, 170, 60, fill = 'aliceblue')
	self.balloon.canvasbind(canvas, item, 'This is help for\na rectangle')
	item = canvas.create_oval(110, 50, 160, 90, fill = 'blue')
	self.balloon.canvasbind(canvas, item, 'This is help for\nan oval item')
	item = canvas.create_text(100, 100, text = 'Canvas items with balloons')
	self.balloon.canvasbind(canvas, item, 'This is help for\na text item')

	# Create and pack the MessageBar.
	self.messageBar = Pmw.MessageBar(parent,
		entry_width = 40,
		entry_relief='groove',
		labelpos = 'w',
	        label_text = 'Status:')
	self.messageBar.pack(fill = 'x', expand = 1, padx = 10, pady = 10)

	# Configure the balloon to display its status messages in the
	# message bar.
	self.balloon.configure(statuscommand = self.messageBar.helpmessage)

    def toggle(self):
	if self.toggleBalloonVar.get():
	    if self.toggleStatusVar.get():
		self.balloon.configure(state = 'both')
	    else:
		self.balloon.configure(state = 'balloon')
	else:
	    if self.toggleStatusVar.get():
		self.balloon.configure(state = 'status')
	    else:
		self.balloon.configure(state = 'none')

    ######################################################################

# Create demo in root window for testing.
if __name__ == '__main__':
    root = Tkinter.Tk()
    Pmw.initialise(root, fontScheme = 'pmw1')
    root.title('Pmw Balloon demonstration')

    exitButton = Tkinter.Button(root, text = 'Exit', command = root.destroy)
    exitButton.pack(side = 'bottom')
    widget = Demo(root)
    root.mainloop()
