.TH MKPASSWD 1 "22 August 1994"
.SH NAME
mkpasswd \- generate new password, optionally apply it to a user
.SH SYNOPSIS
.B mkpasswd
.I
[
.I args
]
[
.I user
]
.SH INTRODUCTION
.B mkpasswd
generates passwords and can apply them automatically to users.
mkpasswd is based on the code from Chapter 23 of the O'Reilly book
"Exploring Expect".
.SH USAGE
With no arguments,
.B mkpasswd
returns a new password.

	mkpasswd

With a user name,
.B mkpasswd
assigns a new password to the user.

	mkpasswd don

The passwords are randomly generated according to the flags below.

.SH FLAGS
The
.B \-l
flag defines the length of the password.  The default is 9.  
The following example creates a 20 character password.

	mkpasswd -l 20

The
.B \-d
flag defines the minimum number of digits that must be in the password.
The default is 2.  The following example creates a password with at least
3 digits.

	mkpasswd -d 3

The
.B \-c
flag defines the minimum number of lowercase alphabetic characters that must be in the password.
The default is 2.

The
.B \-C
flag defines the minimum number of uppercase alphabetic characters that must be in the password.
The default is 2.

The
.B \-p
flag names a program to set the password.
By default, /etc/yppasswd is used if present, otherwise /bin/passwd is used.

The
.B \-2
flag causes characters to be chosen so that they alternate between
right and left hands (qwerty-style), making it harder for anyone
watching passwords being entered.  This can also make it easier for
a password-guessing program.

The
.B \-v
flag causes the password-setting interaction to be visible.
By default, it is suppressed.

.SH EXAMPLE
The following example creates a 15-character password
that contains at least 3 digits and 5 uppercase characters.

	mkpasswd -l 15 -d 3 -C 5

.SH SEE ALSO
.I
"Exploring Expect: A Tcl-Based Toolkit for Automating Interactive Programs"
\fRby Don Libes,
O'Reilly and Associates, January 1995.
.SH AUTHOR
Don Libes, National Institute of Standards and Technology

.B mkpasswd
is in the public domain.
NIST and I would
appreciate credit if this program or parts of it are used.


