//  UXKinput.cpp version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

//------------------------------------------------------------------------------
// This code is a complete rewrite of 
//      convlib.c by  Makoto Ishisone at 
//                Software Research Associates, Inc., Japan <ishisone@sra.co.jp>
// convlib.c comes with kinput2. Please download it form ftp://ftp.x.org/
//------------------------------------------------------------------------------

#include "UXKinput.h"
#include "UCommon.h"
#include <memory.h>
#include <stdlib.h>
#include <ctype.h>

#if defined(__alpha) || (defined(_MIPS_SZLONG) && _MIPS_SZLONG == 64)
typedef int int32;
typedef unsigned int uint32; 
#else
typedef long int32;
typedef unsigned long uint32;
#endif


ConversionAtoms*	UXKinput::convatomArray=0;
short			UXKinput::convatomSize=0;
short			UXKinput::convatomArraySize=0;

int			UXKinput::instances=-1;

UXKinput::UXKinput (UWidgetX* uwidgetIn) : UXInput (uwidgetIn)
{
	if (instances == -1)
	{
		instances =0;
	}
	convatom = None;
	convowner = None;
	instances++;
}

UXKinput::~UXKinput ()
{
	instances--;
}

unsigned long
UXKinput::getInputStyle()
{
	switch (inputStyle)
	{
	case UOVER:
		return CONVARG_OVERTHESPOT;
	case UOFF:
		return CONVARG_OFFTHESPOT;
	case UROOT:
		return CONVARG_ROOTWINDOW;
	}
	return CONVARG_ROOTWINDOW;
}

long
UXKinput::getCaptureMethod()
{
	// CONVARG_NONE - not supported
	// CONVARG_SELECT_FOCUS_WINDOW - key events that happen
	//     during coversion and dont have SendEvent flags need to be
	//     ignored.
	// CONVARG_CREATE_INPUTONLY - create an invisible window in front of
	//     the real one - does not work with all window managers-
	//     click to type.
	return CONVARG_SELECT_FOCUS_WINDOW;
}

ConversionAtoms *
UXKinput::getAtoms()
{
	ConversionAtoms*		newArray;
	int				i;
	short				newSize;

	for (i=0; i<convatomSize; i++)
	{
		if (convatomArray[i].display == uwidget->uGetDisplay())
		{
			return &convatomArray[i];
		}
	}
	if (convatomSize>=convatomArraySize)
	{
		newSize = (convatomArraySize == 0) ?  1 : convatomArraySize << 1;
		newArray = new ConversionAtoms [newSize];
		CHECKNULL (newArray);
		if (convatomArraySize>0)
		{
			memcpy (newArray, convatomArray, 
			 sizeof (ConversionAtoms) * convatomArraySize); 
		}
		convatomArraySize = newSize;
		convatomArray = newArray;
	}
	convatomArray[convatomSize].display = uwidget->uGetDisplay();

	convatomArray[convatomSize].profileAtom = 
		XInternAtom(uwidget->uGetDisplay(), CONVERSION_PROFILE, False);

	convatomArray[convatomSize].typeAtom = 
		XInternAtom(uwidget->uGetDisplay(), CONVERSION_ATTRIBUTE_TYPE, False);

	convatomArray[convatomSize].versionAtom = 
		XInternAtom(uwidget->uGetDisplay(), PROTOCOL_VERSION, False);

	convatomArray[convatomSize].reqAtom = 
		XInternAtom(uwidget->uGetDisplay(), "CONVERSION_REQUEST", False);

	convatomArray[convatomSize].notifyAtom = 
		XInternAtom(uwidget->uGetDisplay(), "CONVERSION_NOTIFY", False);

	convatomArray[convatomSize].endAtom = 
		XInternAtom(uwidget->uGetDisplay(), "CONVERSION_END", False);

	convatomArray[convatomSize].endReqAtom = 
		XInternAtom(uwidget->uGetDisplay(), "CONVERSION_END_REQUEST", False);

	convatomArray[convatomSize].attrAtom = 
		XInternAtom(uwidget->uGetDisplay(), "CONVERSION_ATTRIBUTE", False);

	convatomArray[convatomSize].attrNotifyAtom = 
		XInternAtom(uwidget->uGetDisplay(), "CONVERSION_ATTRIBUTE_NOTIFY", False);

	convatomSize++;
 	return &convatomArray[convatomSize-1];
}

//
// This is called when the conversion starts
// get the property to communicate with the server.
//
void
UXKinput::noEventHandler(const XEvent* ev)
{
	ConversionAtoms *cap;

	const XClientMessageEvent *cev = &(ev->xclient);

	if (ev->type != ClientMessage) return;

	cap = getAtoms ();

	// check if this is the right event
	if (cev->window != uwidget->uGetWindow() ||
		cev->message_type != cap->notifyAtom ||
		(Atom) cev->data.l[0] != convatom) 
	{
		return;
	}

	//
	// This event handler is not needed eny more here.
	//
	removeEventHandler (UNO_EVENT);

	if (cev->data.l[2] == None) 
	{
		cerr << "error: selection request failed.\n";
		if (uwidget) uwidget->uXIMFail ();
		return;
    	}

	// At this point conversion starts.
	if (uwidget!= 0) uwidget->uXIMStart();

	// Add an event handler till CONVERSION_END
	addEventHandler (UPROPERTY_CHANGE);

	// store the property name
	property = cev->data.l[2];
}

//
// Get the conversion data thru property change.
//
void
UXKinput::propertyChangeHandler (const XEvent* ev)
{
	ConversionAtoms*	cap;
	unsigned char*		buffer;

	// PropertyNotify
	const XPropertyEvent *	pev;
	Atom 			proptype;
	int 			propformat;
	unsigned long		propsize;
	unsigned long		rest;
	unsigned char*		propvalue;
	void*			cludge;


	// check event type
	if (ev->type != PropertyNotify && ev->type != ClientMessage) return;

	cap = getAtoms ();

	if (ev->type == ClientMessage) 
	{
		const XClientMessageEvent *cev = &(ev->xclient);

		// Check if it really means the end of input
		if (cev->message_type == cap->endAtom && cev->format == 32 &&
			(Atom) cev->data.l[0] == convatom) 
		{
			removeEventHandler (UPROPERTY_CHANGE);
			if (uwidget) uwidget->uXIMEnd ();
		}
		return;
	}

	pev = &(ev->xproperty);
	if (property == None) return;

	// Check the event
	if (pev->window != uwidget->uGetWindow() || pev->atom != property ||
	    pev->state != PropertyNewValue)
	{
	    return;
	}

	//
	// Get the string from the property that was given at the 
	// beginning of the conversion.
	//
	propvalue=0;
	XGetWindowProperty(uwidget->uGetDisplay(), uwidget->uGetWindow(), 
		property, 0L, 100000L, True, AnyPropertyType,
		&proptype, &propformat, &propsize, &rest, &propvalue);


	cludge = propvalue;
	if (proptype == None)
	{
		// this happens if accumulated property change
		// happened, and we already have read the data.
		if (cludge) XFree (cludge);
		return;
	}
	if (proptype!=textTypeAtom)
	{
		cerr << "warn: uknown XInput type is Atom "
				<< proptype << " expected: "
				<< textTypeAtom << "(" << textType << ").\n";
		if (cludge) XFree (cludge);
		return;
	}
	if (propformat != 8)
	{
		cerr << "warn: uknown XInput format " 
		<< propformat << " ignored.\n";
		if (cludge) XFree (cludge);
		return;
	}

	if (propvalue==0) return;

	// we are sure that size is 8
	buffer = new unsigned char[propsize+4];
	memcpy (buffer, propvalue, propsize);
	buffer[propsize] = 0;
	buffer[propsize+1] = 0;
	buffer[propsize+2] = 0;
	buffer[propsize+3] = 0xff;

	uString->putString (buffer);
	uwidget->uDeleteSelection ();
	uwidget->uInsertUCS2 ((const UCS2*) *uString);
	uwidget->uSetCursorViewable();

	delete buffer;
	XFree (cludge);
	return;
}

typedef struct 
{
	uint32		dataP[1024];
} GoodPropArray;
typedef struct 
{
	unsigned long 	dataP[512];
} BadPropArray;

typedef struct _PropArray
{
	union {
		GoodPropArray	good;
		BadPropArray	bad;
	} u;
} PropArray;

#define DASSIGN(_data) { \
	if (version > 2.02) propArray.u.good.dataP[len++]=_data;\
	   else propArray.u.bad.dataP[len++]=_data; }

UXKinput::UStatus
UXKinput::setConvAttrProp (const UAttribute attribute, const Atom prop)
{
	PropArray		propArray;
	int			fontSizePos;
	const XFontStruct* 	convFont;
	int			fontCount;
	unsigned int		len;
	unsigned long		fontValue;
	int			i;
	int			width;
	int			height;
	int			x;
	int			y;
	int			realHeight;
	int			saveLen;

	len = 0;
	if (sizeof (uint32) != 4)
	{
		cerr << "error: setConvAttrProp uint32 is not right.\n";
		return ERROR;
	}

	memset (&propArray, 0, sizeof (propArray));

	if (uwidget ==0)
	{
		cerr << "error: uwidget is not set.\n";
		return ERROR;
	}
	if (attribute & UISTYLE)
	{
		DASSIGN (CONV_ATTR(CONVATTR_INPUT_STYLE, 1));
		DASSIGN (getInputStyle());
	}

	if (attribute & UBACKGROUND || attribute & UFOREGROUND)
	{
		DASSIGN (CONV_ATTR(CONVATTR_COLOR, 2));
		DASSIGN (uwidget->uGetForeground());
		DASSIGN (uwidget->uGetBackground());
	}
	if (attribute & UFONT)
	{
		font->setPixel ((uwidget->uGetFont())->getPixel());
		if (font->isNew())
		{
			uwidget->uSetCursor (UCursor::WAIT, 1);
			font->getFont();
		}
		if (font->getSize()==0)
		{
			cerr << "error: Font can not be specified in UXInput.\n";
			return ERROR;
		}
		uwidget->uSetCursor (UCursor::INSERT, 1);
		
		fontSizePos = len;
		len++;
		for (i=0, fontCount=0; i<font->getSize(); i++)
		{
			convFont = font->getFontAt(i);
			if (convFont==0) continue;

			if (XGetFontProperty ((XFontStruct*) 
				convFont, XA_FONT, &fontValue))
			{
				DASSIGN (fontValue);
				fontCount++;
			}
		}
		if (fontCount > 0)
		{
			saveLen = len;
			len = fontSizePos;
			DASSIGN (CONV_ATTR (CONVATTR_FONT_ATOMS, 
				fontCount));
			len = saveLen;
			if (font->fontHeight+2 != uwidget->uXInputHeight &&
				inputStyle == UOFF)
			{
				// Nobody will say a bad word if it is called
				// twice...
				uwidget->uXIMStart();
				realHeight = uwidget->uGetHeight()+
					uwidget->uXInputHeight;
				uwidget->uXInputHeight = font->fontHeight+2;
				uwidget->uResize (uwidget->uGetWidth(),
					realHeight, uwidget->uGetCornerX(),
					uwidget->uGetCornerY());
			}

		}
		else
		{
			cerr << "error: no fonts for input method\n";
			len=fontSizePos;
		}
	}
	// This is for over the spot
	if ((attribute & UCURSORXY || attribute &UFONT) && inputStyle==UOVER)
	{
		if ((uwidget->uGetFont())->isNew())
		{
			uwidget->uSetCursor (UCursor::WAIT, 1);
			(uwidget->uGetFont())->getFont();
			uwidget->uSetCursor (UCursor::INSERT, 1);
		}
		x = uwidget->uGetRealCoordX(uwidget->uGetCursorBox().at.coordX);
		y = uwidget->uGetRealCoordY(uwidget->uGetCursorBox().at.coordY)+font->fontAscent;
		DASSIGN (CONV_ATTR(CONVATTR_SPOT_LOCATION, 1));
		DASSIGN ((x << 16) | (y & 0xffff));
	}
	if (attribute & UTEXT_TYPE)
	{
		// Specified directly.
	}
	if (attribute & ULINE_SPACING)
	{
		DASSIGN (CONV_ATTR(CONVATTR_LINE_SPACING, 1));
		DASSIGN (1);
		// it is the third argument in client data.
	}
	if (attribute & UWINDOW)
	{
		DASSIGN (CONV_ATTR (CONVATTR_FOCUS_WINDOW, 1));
		DASSIGN (uwidget->uGetWindow());
	}
	if (attribute & UEVENT_CAPTURE)
	{
		DASSIGN (CONV_ATTR(CONVATTR_EVENT_CAPTURE_METHOD, 1));
		DASSIGN (getCaptureMethod());
	}
	if (attribute & UCURSOR_SHAPE)
	{
		// not now please...
	}
	if (attribute & USTATUS_AREA || attribute &UFONT)
	{
		DASSIGN (CONV_ATTR(CONVATTR_STATUS_AREA, 2));
		x = uwidget->uGetCornerX();
		y = uwidget->uGetHeight();

		DASSIGN ((x << 16) | (y & 0xffff));
		width = font->fontWidth*4;
		height = uwidget->uXInputHeight;
		DASSIGN ((width << 16) | (height & 0xffff));
	}
	if (attribute & UCLIENT_AREA || attribute &UFONT)
	{
		DASSIGN (CONV_ATTR(CONVATTR_CLIENT_AREA, 2));
		x = font->fontWidth*4+uwidget->uGetCornerX();
		y = uwidget->uGetHeight();

		DASSIGN ((x << 16) | (y & 0xffff));
		width = uwidget->uGetWidth() - x;
		if (width<1) width = 1;
		height = uwidget->uXInputHeight;
		DASSIGN ((width << 16) | (height & 0xffff));
	}
	
	// Have to take care of buggy kinput
	XChangeProperty(uwidget->uGetDisplay(), 
		uwidget->uGetWindow(), prop, 
		prop, 32, PropModeReplace, 
		(unsigned char *)&propArray, 
		len * sizeof(long)/sizeof(uint32));

	return OK;
}

//
// Check protocols on the selection owner - the IM
UXKinput::UStatus
UXKinput::checkProtocols (const ConversionAtoms* cap)
{
	Atom 		type;
	int 		format;
	unsigned long 	nitems;
	unsigned long 	bytesafter;
	unsigned long 	*data;
	unsigned long	*saveddata;
	UStatus 	ret;
	int		code;
	unsigned int	len;

	data = 0;
	XGetWindowProperty(uwidget->uGetDisplay(), convowner,
		 cap->profileAtom, 0L, 100L, False, cap->typeAtom,
		&type, &format, &nitems, &bytesafter, 
		(unsigned char **)&data);
	
	if (format != 32 || type != cap->typeAtom) 
	{
		if (data != NULL) XFree((char *)data);
		return ERROR;
	}

	if (data==0) return ERROR;

	// This is very pessimistic
	ret = ERROR;
	saveddata = data;
	while (nitems > 0) 
	{
		code = CODE_OF_ATTR(*data);
		len = LENGTH_OF_ATTR(*data);

		data++; nitems--;
		if (nitems < len) break;

		switch (code) 
		{
		case CONVPROF_PROTOCOL_VERSION:
			if (*data == cap->versionAtom) ret = OK;
			break;
		case CONVPROF_SUPPORTED_STYLES:
			break;	/* XXX for now */
		default:
			break;
		}
		data += len;
		nitems -= len;
	}
	XFree((char *)saveddata);
	return ret;
}


//
//	public functions
//
UXInput::UStatus
UXKinput::uStartIM()
{
	Atom			catom;
	Window 			owner;
	XEvent			event;
	ConversionAtoms* 	cap;
	UXKinput::UStatus	attrStatus;

	// inputMethod should be "_JAPANESE_CONVERSION"
	catom = XInternAtom (uwidget->uGetDisplay(), inputMethod, False);

	cap = getAtoms ();

	//
	// Search for conversion server
	//
	if ((owner = XGetSelectionOwner(uwidget->uGetDisplay(), catom)) == None) 
	{
		// No server. If we are in middle of conversion we should abort
		cerr << "error: no kinput type '" << inputMethod 
			<< "' is known to X server.\n";
		removeEventHandler (UNO_EVENT);
		removeEventHandler (UPROPERTY_CHANGE);
		if (uwidget) uwidget->uXIMFail ();
		return ERROR;
	}

	// Deleted piece when conversion is going on and this function is 
	// called again.
	addEventHandler (UNO_EVENT);

	convatom = catom;
	convowner = owner;
	property = None;	

	attrStatus = ERROR;
	if (checkProtocols (cap)== OK) 
	{
		attrStatus = setConvAttrProp( UALL, cap->attrAtom);
    	}

	// Request Japanes Input with client message
	
	event.xclient.type = ClientMessage;
	event.xclient.window = owner;
	event.xclient.message_type = cap->reqAtom;
	event.xclient.format = 32;
	event.xclient.data.l[0] = catom;
	event.xclient.data.l[1] = uwidget->uGetWindow();
	event.xclient.data.l[2] = textTypeAtom;

	// To support many languages we set the property that reuests
	// the result to Atom
	event.xclient.data.l[3] = catom;
	event.xclient.data.l[4] = (attrStatus== OK) ? cap->attrAtom : None;
	XSendEvent(uwidget->uGetDisplay(), owner, False, NoEventMask, &event);

	return OK;
}


//
void
UXKinput::uEndIM ()
{
	XEvent		event;
	ConversionAtoms* cap;

	if (uwidget) uwidget->uXIMEnd ();

	if (convatom==None || convowner==None)
	{
		return;
	}
	cap = getAtoms();
	if (checkProtocols (cap)== ERROR) return;

	if (XGetSelectionOwner (uwidget->uGetDisplay(), convatom) != convowner) 
	{
		removeEventHandler (UNO_EVENT);
		removeEventHandler (UPROPERTY_CHANGE);
		return;
	}

	event.xclient.type = ClientMessage;
	event.xclient.window = convowner;
	event.xclient.message_type = cap->endReqAtom;
	event.xclient.format = 32;
	event.xclient.data.l[0] = convatom;
	event.xclient.data.l[1] = uwidget->uGetWindow();
	XSendEvent(uwidget->uGetDisplay(), convowner, False, NoEventMask, &event);
}

void
UXKinput::uChangeIM (UAttribute attr)
{
	Window 			owner;
	XEvent			event;
	ConversionAtoms* 	cap;
	UXKinput::UStatus	attrStatus;
	char*			versionName;
	char*			versionP;

	cap = getAtoms ();

	//
	// Search for conversion server
	//
	if ((owner = XGetSelectionOwner(uwidget->uGetDisplay(), convatom))
		 == None || owner!=convowner) 
	{
		// No server. If we are in middle of conversion we should abort
		cerr << "error: no kinput type '" << inputMethod 
			<< "' is known to X server.\n";
		removeEventHandler (UNO_EVENT);
		removeEventHandler (UPROPERTY_CHANGE);
		if (uwidget) uwidget->uXIMFail ();
		return;
	}

	// Deleted piece when conversion is going on and this function is 
	// called again.
	addEventHandler (UNO_EVENT);

	convowner = owner;

	attrStatus = ERROR;
	if (checkProtocols (cap)== OK) 
	{
		attrStatus = setConvAttrProp( attr, cap->attrAtom);
		if (version == 0.0)
		{
			versionName = XGetAtomName (
				uwidget->uGetDisplay(), 
				cap->versionAtom);
			if (versionName)
			{
				for (versionP=versionName;
					versionP[0] != 0 &&
					!isdigit (versionP[0]); 
					versionP++); 

				version = atof (versionP);
				cerr << "Kinput2 version: " 
					<< versionP << ".\n";
				XFree (versionName);
			}
		}
    	}
	if (attrStatus != OK) 
	{
		cerr << "warn: can not change XIM attributes.\n";
		return;
	}

	// Request Japanes Input with client message
	
	event.xclient.type = ClientMessage;
	event.xclient.window = convowner;
	event.xclient.message_type = cap->attrNotifyAtom;
	event.xclient.format = 32;
	event.xclient.data.l[0] = convatom;
	event.xclient.data.l[1] = uwidget->uGetWindow();
	event.xclient.data.l[2] = CONV_ATTR(CONVATTR_INDIRECT, 1);
	event.xclient.data.l[3] = cap->attrAtom;
	XSendEvent(uwidget->uGetDisplay(), convowner, False, NoEventMask, &event);

	return;
}

void
UXKinput::addEventHandler (const UInputEvent eventType)
{
}

void
UXKinput::removeEventHandler (const UInputEvent eventType)
{
}

