//  UCursor.cpp version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "UCursor.h"
#include "UCommon.h"
#include <memory.h>
#include <X11/cursorfont.h>

UCursorStruct**	UCursor::cursors= 0;
int   		UCursor::count=0;


UCursor::UCursor (Display* displayIn, Window windowIn)
{
	UCursorStruct**		newArray;
	Pixmap			waitBitMap;
	Pixmap			waitMaskBitMap;
	XColor 			background;
	XColor 			foreground;

	static char waitBits[] = 
	{
		0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x03, 0xe4, 0xff, 0x9f, 0x00,
		0x64, 0x00, 0x98, 0x00, 0x64, 0x00, 0x98, 0x00, 0x64, 0x00, 0x98, 0x00,
		0xe4, 0xaa, 0x9e, 0x00, 0xc4, 0x55, 0x8f, 0x00, 0x84, 0x8b, 0x87, 0x00,
		0x04, 0xd7, 0x83, 0x00, 0x04, 0xee, 0x81, 0x00, 0x04, 0xcc, 0x80, 0x00,
		0x04, 0x68, 0x80, 0x00, 0x04, 0x58, 0x80, 0x00, 0x04, 0xec, 0x80, 0x00,
		0x04, 0xde, 0x81, 0x00, 0x04, 0xa7, 0x83, 0x00, 0x84, 0x03, 0x87, 0x00,
		0xc4, 0x29, 0x8e, 0x00, 0xe4, 0x54, 0x9c, 0x00, 0x64, 0xaa, 0x98, 0x00,
		0x64, 0x44, 0x99, 0x00, 0x64, 0xaa, 0x9a, 0x00, 0xe4, 0xff, 0x9f, 0x00,
		0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00
	};
	static char waitMaskBits[] = 
	{
		0xff, 0xff, 0xff, 0x03, 0xff, 0xff, 0xff, 0x03, 0xf6, 0xff, 0xbf, 0x01,
		0x76, 0x00, 0xb8, 0x01, 0x76, 0x00, 0xb8, 0x01, 0xf6, 0xff, 0xbf, 0x01,
		0xf6, 0xff, 0xbf, 0x01, 0xe6, 0xff, 0x9f, 0x01, 0xc6, 0xff, 0x8f, 0x01,
		0x86, 0xff, 0x87, 0x01, 0x06, 0xff, 0x83, 0x01, 0x06, 0xfe, 0x81, 0x01,
		0x06, 0xfc, 0x80, 0x01, 0x06, 0xfc, 0x80, 0x01, 0x06, 0xfe, 0x81, 0x01,
		0x06, 0xff, 0x83, 0x01, 0x86, 0xb7, 0x87, 0x01, 0xc6, 0x03, 0x8f, 0x01,
		0xe6, 0x39, 0x9e, 0x01, 0xf6, 0xfe, 0xbc, 0x01, 0x76, 0xfe, 0xb8, 0x01,
		0x76, 0xff, 0xbb, 0x01, 0x76, 0xff, 0xbb, 0x01, 0xf6, 0xff, 0xbf, 0x01,
		0xff, 0xff, 0xff, 0x03, 0xff, 0xff, 0xff, 0x03
	};


	cursor = new UCursorStruct[1];
	cursor->display = displayIn;
	cursor->window = windowIn;

	background.red = background.green = background.blue = 0xff<<8;
	foreground.red = foreground.green = foreground.blue = 0;

	waitBitMap = XCreateBitmapFromData (displayIn, windowIn, waitBits, 26, 26);
	waitMaskBitMap = XCreateBitmapFromData (displayIn, windowIn, waitMaskBits, 26, 26);
	cursor->waitCursor = XCreatePixmapCursor (displayIn, waitBitMap, waitMaskBitMap,
			 &foreground, &background, 13, 13 );

	XFreePixmap (displayIn, waitBitMap);
	XFreePixmap (displayIn, waitMaskBitMap);

	cursor->insertCursor = XCreateFontCursor (displayIn, XC_xterm);

	newArray = new UCursorStruct*[count+1];
	CHECKNULL (newArray);
	if (count > 0)
	{
		memcpy (newArray, cursors, count * sizeof(UCursorStruct*));
		delete cursors;
	}
	cursors = newArray;
	cursors[count++] = cursor;
}

UCursor::~UCursor ()
{
	int	i;
	for (i=0; i<count; i++)
	{
		if (cursors[i] == cursor)
		{
			while (i<count-1)
			{
				cursors[i] = cursors[i+1];
				i++;
			}
			count--;
			break;
		}
	}
	if (count == 0)
	{
		delete cursors;
		cursors=0;
	}
	XFreeCursor (cursor->display, cursor->waitCursor);
	XFreeCursor (cursor->display, cursor->insertCursor);
	delete cursor;
}

void 
UCursor::setCursor (const UType type, const int all)
{
	int	i;
	if (all==0)
	{
		switch (type)
		{
		case WAIT:
			XDefineCursor (cursor->display, cursor->window, 
					cursor->waitCursor);
			XFlush (cursor->display);
			break;
		case INSERT:
			XDefineCursor (cursor->display, cursor->window, 
					cursor->insertCursor);
			XFlush (cursor->display);
			break;
		}
		return;
	}
	for (i=0; i<count;i++)
	{
		switch (type)
		{
		case WAIT:
			XDefineCursor (cursors[i]->display, cursors[i]->window, 
					cursors[i]->waitCursor);
			XFlush (cursor->display);
			break;
		case INSERT:
			XDefineCursor (cursors[i]->display, cursors[i]->window, 
					cursors[i]->insertCursor);
			XFlush (cursor->display);
			break;
		}
	}
	return;
}
