//  UComponent.cpp version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
#include "UComponent.h"
#include "memory.h"

UPlacement::UPlacement (void)
{
	memset (flags, (int) PLACE, (int) USIDE_MAX);
	margin = GAP;
}

UPlacement::~UPlacement ()
{
}

void
UPlacement::place (USide side, int p)
{
	flags[side] = PLACE;
	edges[side] = p;
}
void
UPlacement::place (int w, int n, int e, int s)
{
	flags[WEST] = PLACE;
	flags[NORTH] = PLACE;
	flags[EAST] = PLACE;
	flags[SOUTH] = PLACE;
	edges[WEST] = w;
	edges[NORTH] = n;
	edges[EAST] = e;
	edges[SOUTH] = s;
}

void
UPlacement::position (USide side, int p)
{
	flags[side] = POSITION;
	edges[side] = p;
}

void
UPlacement::position (int w, int n, int e, int s)
{
	flags[WEST] = POSITION;
	flags[NORTH] = POSITION;
	flags[EAST] = POSITION;
	flags[SOUTH] = POSITION;
	edges[WEST] = w;
	edges[NORTH] = n;
	edges[EAST] = e;
	edges[SOUTH] = s;
}

UComponent::UComponent(UTopContext* topLevel, Display* display) : 
	background (display),
	foreground (display)
{
	top = topLevel;
	masks = 0;
	window = None;
	font = 0;
}

UComponent::~UComponent()
{
}

void
UComponent::eventUp (UEvent* event)
{
}

void
UComponent::eventDown (UEvent* event)
{
}

UComponent*
UComponent::getParent ()
{
	return 0;
}

int
UComponent::isShown(UComponent* parent)
{
	UComponent*	comp;
	comp=parent;
	while(comp->getParent()) comp = comp->getParent();
	return ((comp == this) ? 1 : comp->isShown(this));
}

const UColor&
UComponent::getBackground ()
{
	return background;
}

void
UComponent::setBackground (const UColor &color)
{
}

const UColor&
UComponent::getForeground ()
{
	return foreground;
}

void
UComponent::setForeground (const UColor &color)
{
}

void
UComponent::resize (int width, int height)
{
}

void
UComponent::move (int x, int y)
{
}

void
UComponent::redraw (int x, int y, int width, int height)
{
}

void
UComponent::setFont (UFont* font_)
{
	font = font_;
}

UFont*
UComponent::getFont ()
{
	return font;
}

UBestSize::UBestSize (void)
{
	width = 0;
	height = 0;
}

UBestSize::~UBestSize ()
{
}


int
UComponent::isA (UComponent::UType type_)
{
	if (type_ == UComponent::COMPONENT) return 1;
	return 0;
}

void
UComponent::select (long masks_)
{
	masks |= masks_;
	if (top->display !=0) XSelectInput (top->display, window, masks);
}
const UBestSize& 
UComponent::getBestSize()
{
	return bestSize;
}

const UPlacement& 
UComponent::getPlacement()
{
	return placement;
}

void
UComponent::place (UPlacement::USide side, int p)
{
	placement.place (side, p);
}

void
UComponent::place (int w, int n, int e, int s)
{
	placement.place (w, n, e, s);
}

void
UComponent::position (UPlacement::USide side, int p)
{
	placement.position (side, p);
}

void
UComponent::position (int w, int n, int e, int s)
{
	placement.position (w, n, e, s);
}

void
UComponent::clearSelection ()
{
}
