//  UBinArray.cpp version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
#include "UBinArray.h"
#include <iostream.h>
#include <memory.h>

UBinArray::UBinArray(void)
{
	size = 0;
	arraySize = 0;
	key = 0;
	dataSize = 0;
	data = 0;
	allowMultiple = 1;
}

UBinArray::UBinArray(int allowMultiple_)
{
	size = 0;
	arraySize = 0;
	key = 0;
	dataSize = 0;
	data = 0;
	allowMultiple = allowMultiple_;
}

UBinArray::~UBinArray()
{
	unsigned int 	i;

	for (i=0; i<size; i++)
	{
		delete (data[i]);
	}
	if (key) delete key;
	if (data) delete data;
	if (dataSize) delete dataSize;
}

UBinArray::UStatus
UBinArray::addItem (unsigned long key_, void* data_)
{
	unsigned int	pos;
	void**		newData;
	void***		newDataArray;
	unsigned long*	newKeyArray;
	unsigned int* 	newDataSize;
	unsigned int	newSize;
	unsigned int	i; 

	pos = binarySearch (key_);

	// Multiple key
	if (pos < size && key[pos] == key_)
	{
		if (allowMultiple==0) return ERROR;

		// extend multiple entry. new entry is first
		newData = new void* [dataSize[pos] + 1];
		if (checkMemory ((void*)newData)) return ERROR;

		memcpy (&newData[1], data[pos], sizeof (void*) * dataSize[pos]);

		newData[0] = data_;
		delete data[pos];
		data[pos] = newData;
		dataSize[pos]++;
		return OK;
	}


	// We may need to extend the array
	if (size >= arraySize)
	{
		newSize = (arraySize==0) ? 1 : arraySize << 1;

		newDataArray = new void**[newSize];
		if (checkMemory ((void*)newDataArray)) return ERROR;

		newKeyArray = new unsigned long [newSize];
		if (checkMemory ((void*)newKeyArray)) return ERROR;

		newDataSize = new unsigned int[newSize];
		if (checkMemory ((void*)newDataSize)) return ERROR;

		if (size > 0)
		{
			memcpy (newKeyArray, key, size *sizeof (unsigned long));
			memcpy (newDataArray, data, size *sizeof (void **));
			memcpy (newDataSize, dataSize, size *sizeof (unsigned int*));
			delete key;
			delete data;
			delete dataSize;
		}
		key = newKeyArray;
		data = newDataArray;
		dataSize = newDataSize;

		arraySize = newSize;
	}

	// Key to end
	if (pos >= size)
	{
		key[size] = key_;
		data[size] = new void *[1];
		if (checkMemory ((void*)data[size])) return ERROR;
		data[size][0] = data_;
		dataSize[size] = 1;
		size++;
		return OK;
	}

	// move data up
	for (i=size; i>pos; i--) 
	{
		key[i] = key[i-1];
		data[i] = data[i-1];
		dataSize[i] = dataSize[i-1];
	}

	key[pos] = key_;
	data[pos] = new void *[1];
	if (checkMemory ((void*)data[pos])) return ERROR;
	data[pos][0] = data_;
	dataSize[pos] = 1;
	size++;
	return OK;
}

UBinArray::UStatus
UBinArray::deleteItem (unsigned long key_)
{
	unsigned long	pos;
	unsigned int	i;

	pos = binarySearch (key_);

	if (pos == size || key[pos] != key_) return ERROR;

	// move data down
	delete data[pos];
	for (i=pos; i<size-1; i++) 
	{
		key[i] = key[i+1];
		data[i] = data[i+1];
		dataSize[i] = dataSize[i+1];
	}
	size--;
	return OK;
}

UBinArray::UStatus
UBinArray::deleteItem (unsigned long key_, void* client)
{
	unsigned long	pos;
	unsigned int	i;
	int		clientPos;

	pos = binarySearch (key_);
	if (pos == size || key[pos] != key_) return ERROR;

	for (i=0, clientPos=-1; i<dataSize[pos]; i++)
	{
		if (data[pos][i]==client)
		{
			clientPos=i; break;
		}
	}
	if (clientPos==-1) return ERROR;
	// move things down
	for (i=clientPos; i<dataSize[pos]-1; i++)
	{
		data[pos][i] = data[pos][i+1];
	}
	dataSize[pos]--;
	if (dataSize[pos] > 0) return OK;

	// move data down
	delete data[pos];
	for (i=pos; i<size-1; i++) 
	{
		key[i] = key[i+1];
		data[i] = data[i+1];
		dataSize[i] = dataSize[i+1];
	}
	size--;
	return OK;
}

UBinArray::UStatus
UBinArray::reIndex (long diff)
{
	unsigned int	i;

	if ((unsigned long) (-diff) > key[0])
	{
		return ERROR;
	}

	for (i=0; i<size; i++) 
	{
		key[i] = (diff<0) ?  key[i] - (unsigned long)(-diff) : 
			key[i] + (unsigned long) (diff);
		
	}
	return OK;
}

void*
UBinArray::findItem (unsigned long key_, int pos_)
{
	unsigned long	pos;

	pos = binarySearch (key_);

	if (pos >= size || key[pos] != key_) return 0;

	// return the first element
	if (dataSize[pos]<(unsigned int) pos_+1) return 0;
	return  data[pos][pos_];
}

void*
UBinArray::at (unsigned int pos)
{
	if (pos >= size) return 0;
	return data[pos][0];
}

unsigned long
UBinArray::keyAt (unsigned int pos)
{
	if (pos >= size) return 0;
	return key[pos];
}

int
UBinArray::checkMemory (void * mem)
{
	if (mem==0)
	{
		cerr << "error: out of memory in UBinArray.\n";
		return 1;
	}
	return 0;
}

unsigned int
UBinArray::binarySearch (unsigned long key_)
{
	unsigned int	top;
	unsigned int	bottom;
	unsigned int	mid;

	top = size;
	bottom = 0;
	while (top > bottom)
	{
		mid = (top+bottom)/2;
		if (key_ == key[mid]) return mid;
		if (key_ < key[mid])
		{
			top = mid;
			continue;
		}
		bottom = mid + 1;
	}
	return top;
}
