//  Config.h version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//

#ifndef __config_h__
#define __config_h__

#include <FileConfig.h>
#include <UCommon.h>
#include <UFreeType.h>
#include <AString.h>

class  FontMap
{
public:	
			FontMap (const char* name);
			~FontMap();
	enum MapIndex {UMAP, FOUNDRY, FAMILY, REGISTRY, ENCODING, MAX};
	int		size;
	AString		name;
	AStringList	list[MAX];
};

//
// This describes a TrueType font
//
class TrueTypeFont
{
public:	
			TrueTypeFont (const char* name);
			~TrueTypeFont ();
	AString		name;
	AString		fontFile[UFreeType::WEIGHT_COUNT][UFreeType::SLANT_COUNT];
};

class Language
{
public:
	enum LanguageIndex {SHORT_NAME, TEXT_FONT, TEXT_SIZE, 
			TEXT_WEIGHT, TEXT_SLANT, TEXT_SPACING,
			BUTTON_FONT, BUTTON_SIZE, BUTTON_WEIGHT,
			BUTTON_SLANT, BUTTON_SPACING, MAX};
			Language (const char* name);
			~Language ();
	AString		name;

	AString		list[MAX];
};

class  XInputMap
{
public:	
			XInputMap (const char* name);
			~XInputMap();
	enum XInutIndex {VERSION, TYPE, STYLE, ENCODING, 
			FONTMAP, TEXT_TYPE, MAX};
	AString		name;
	AString		list[MAX];
};

//
// If you have a fontName it can be a fontMap or a TrueType font
//
class Config
{
public:

	enum CheckList {ENCODING, INPUT, XINPUT, FONTNAME,
			FONTSIZE, FONTWEIGHT, FONTSLANT, 
			FONTSPACING, TABSIZE, WINDOW_BACKGROUND,
			WINDOW_FOREGROUND, CURSOR_COLOR, 
			LANGUAGE, CHECKLIST_MAX};
	// extra is language

	enum Mode	{REAL, TEST, MODE_SIZE};

	// String representation of above 
	inline const char*	getName(const int index) const 
				{ return names[index]; }


				Config (const Config& configIn);
				Config (const char* nameIn);
				~Config ();

	inline const char*	getErrors() const 
				{ return ((const char*) errors[REAL]); }

	const AStringList&	getCheckList (const CheckList index) const;
	const AString&		getChecked (const CheckList index) const;

	int			setChecked (const CheckList index,
					const char* value);

	const FontMap*		getFontMap (const char* name) const;
	const TrueTypeFont*	getTrueTypeFont (const char* name) const;
	const XInputMap*	getXInputMap (const char* name) const;
	const Language*		getLanguage (const char* name) const;
	inline const AString&	getConfigPath ()  const
				{return configPath; }
	inline const AString&	getConfigName ()  const
				{return configName; }
	inline const AString&	getPath ()  const
				{return path; }

	//
	// Not thread safe, not reentrant
	// This is useful if you want to test a new config in the editor
	//
	inline const char*	testConfig (const char *name) 
				{ readConfig (name, TEST); 
				  return ((const char*) errors[TEST]); }

	int 			copySysConfig(const char* name);
	void			readConfig (const char* name, Mode mode=REAL);
	const AStringList&	getPrinterList () const;
	const char*		getPrinterCommand (const char* printerIn) const;
	const char* 		getPrinter() const;
	void			setPrinter(const char* printerIn);
private:

	void			clear ();
	const int   		getFontMapIndex (const char* name) const;
	const int   		getTrueTypeFontIndex (const char* name) const;
	const int   		getXInputMapIndex (const char* name) const;
	const int   		getLanguageMapIndex (const char* name) const;
	AString			checked[CHECKLIST_MAX];
	AString			defaultPrinter;
	static AStringList	checkList[CHECKLIST_MAX];
	static AStringList	printerCommands;
	static AStringList	printerList;

	static AString		configPath;
	static AString		configName;
	static AString		errors[MODE_SIZE];
	static char*		typeIndex;
	static Config*		lConfig;
	static int		instances;
	static FontMap**	fontMap;
	static int		fontMapSize;
	static int		fontMapArraySize;
	static TrueTypeFont**	trueTypeFont;
	static int		trueTypeFontSize;
	static int		trueTypeFontArraySize;
	static XInputMap**	xInputMap;
	static int		xInputMapSize;
	static Language**	languageMap;
	static int		languageMapSize;
	static AString		path;
	static char* 		names[CHECKLIST_MAX+1]; 
};

#endif /* __config_h__ */
