/***********************************************************************/
/* EDIT.C - The body of the program.                                   */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1997 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                 Email:             M.Hessling@qut.edu.au
 * PO Box 203                    Phone:                    +617 3802 0800
 * Bellara                       http://www.gu.edu.au/gext/the/markh.html
 * QLD 4507                      **** Maintainer PDCurses & REXX/SQL ****
 * Australia                     ************* Author of THE ************
 */

/*
$Id: edit.c 2.1 1995/06/24 16:29:45 MH Rel MH $
*/


#include <the.h>
#include <proto.h>

/*#define TRACE*/
 bool prefix_changed=FALSE;
/***********************************************************************/
#ifdef HAVE_PROTO
void editor(void)
#else
void editor()
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern bool error_on_screen;
 extern WINDOW *error_window;
 extern CHARTYPE display_screens;
/*--------------------------- local data ------------------------------*/
 short y=0,x=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("edit.c:    editor");
#endif

 if (display_screens > 1)
    display_screen(other_screen);

 getyx(CURRENT_WINDOW,y,x);
 wmove(CURRENT_WINDOW,y,x);
 wrefresh(CURRENT_WINDOW);
 if (error_on_screen)
   {
    if (error_window != NULL)
      {
       touchwin(error_window);
       wrefresh(error_window);
       wmove(CURRENT_WINDOW,y,x);
       wrefresh(CURRENT_WINDOW);
      }
   }

 while (1)
   {
    if (process_key(-1) != RC_OK)
       break;
   }
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef HAVE_PROTO
int process_key(int key)
#else
int process_key(key)
int key;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern bool error_on_screen;
 extern bool initial;
 extern CHARTYPE number_of_files;
 extern WINDOW *error_window;
 extern CHARTYPE display_screens;
/*--------------------------- local data ------------------------------*/
 unsigned short x=0,y=0;
 short rc=RC_OK;
 CHARTYPE string_key[2];
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("edit.c:    process_key");
#endif
#if defined(USE_EXTCURSES)
 getyx(CURRENT_WINDOW,y,x);
 wmove(CURRENT_WINDOW,y,x);
 wrefresh(CURRENT_WINDOW);
#endif
 string_key[1] = '\0';

#ifdef CAN_RESIZE
 if (is_termresized())
   {
    (void)THE_Resize(0,0);
    (void)THERefresh((CHARTYPE *)"");
   }
#endif

 if (key == (-1))
    key = my_getch(stdscr);
#if defined (MOUSE_SUPPORT_ENABLED)
    if (key == KEY_MOUSE)
      {
       int b,ba,bm;
       if (get_mouse_info(&b,&ba,&bm) != RC_OK)
#if 0
       ||  (BUTTON_STATUS(b) & BUTTON_ACTION_MASK) == BUTTON_RELEASED)
#endif
         {
#ifdef TRACE
          trace_return();
#endif
          return(RC_OK);
         }
      }
#endif
#ifdef CAN_RESIZE
 if (is_termresized())
   {
#ifdef TRACE
    trace_return();
#endif
    return(RC_OK);
   }
#endif

 initial = FALSE;                 /* set first time a key is requested */
 if (error_on_screen)
    clear_msgline();
 rc = function_key(key,OPTION_NORMAL);
 if (number_of_files == 0)
   {
#ifdef TRACE
    trace_return();
#endif
    return(RC_INVALID_ENVIRON);
   }

 if (rc >= RAW_KEY)
   {
    if (rc > RAW_KEY)
       key = rc - (RAW_KEY*2);
    if (key < 256 && key >= 0)
      {
       string_key[0] = (CHARTYPE)key;
       (void)Text(string_key);
      }
   }
 show_statarea();
 if (display_screens > 1
 &&  SCREEN_FILE(0) == SCREEN_FILE(1))
   {
    build_screen(other_screen);
    display_screen(other_screen);
/*    refresh_screen(other_screen);*/
    show_heading(other_screen);
   }
 refresh_screen(current_screen);
 if (error_on_screen)
   {
    getyx(CURRENT_WINDOW,y,x);
    if (error_window != NULL)
      {
       touchwin(error_window);
       wnoutrefresh(error_window);
      }
    wmove(CURRENT_WINDOW,y,x);
    wnoutrefresh(CURRENT_WINDOW);
   }

#ifdef HAVE_BROKEN_SYSVR4_CURSES
 getyx(CURRENT_WINDOW,y,x);
 wmove(CURRENT_WINDOW,y,x);
 wrefresh(CURRENT_WINDOW);
#else
 doupdate();
#endif
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
