#
# Some settings that you may wish to change, these are used only 
# for the 'install' target:
#
#   TOPDIR    The top of the directory hierarchy in which to install
#   BINDIR    Where to install the compiled 'rexx' program
#   LIBDIR    Where to install the 'regina' library
#   MANEXT    The extention of the manual page
#   MANDIR    Where to install the manual page
#   PROGNAME  What to call the compiled program
#
TOPDIR = /usr/local
BINDIR = $(TOPDIR)/bin
LIBDIR = $(TOPDIR)/lib
MANEXT = l
MANDIR = $(TOPDIR)/man/man$(MANEXT)
ABI=1.0
VER=08a
VERDOT=0.08a

MISCDEFS = -DFGC -I$(SRCDIR) #-DR2PERL
#DEBUG    = #-g -DNDEBUG #-Dlint
PROF     = #-p #g
#OPTIMIZE = -O -DNDEBUG

COPT = $(DEBUGFLAG) $(CEXTRA) $(OPTIMIZE) $(PROF) $(MISCDEFS) $(MEMTRACE) $(USEFLISTS)
LINKOPT = $(DEBUGFLAG) $(OPTIMIZE) $(PROF) $(EEXTRA)
OTHERCOPT = $(DEBUGFLAG) $(OPTIMIZE) $(PROF) $(CEXTRA) $(MISCDEFS) $(MEMTRACE) $(USEFLISTS)

YACC = yacc
#YACC = bison -ly #-d #-lyt

LEX = lex
#LEX = flex #-d #-8
#LL = -L/store/lib -lfl

README = $(SRCDIR)/README.* COPYING-LIB

FILES = funcs builtin error variable interprt debug dbgfuncs \
	memory parsing files misc unxfuncs cmsfuncs shell rexxext stack \
	tracing interp cmath convert strings library strmath signals \
	macros envir extlib wrappers options doscmd #r2perl

CSRCFILES = $(SRCDIR)/funcs.c $(SRCDIR)/builtin.c $(SRCDIR)/error.c $(SRCDIR)/variable.c \
	$(SRCDIR)/interprt.c $(SRCDIR)/debug.c $(SRCDIR)/dbgfuncs.c $(SRCDIR)/memory.c $(SRCDIR)/parsing.c $(SRCDIR)/files.c \
	$(SRCDIR)/misc.c $(SRCDIR)/unxfuncs.c $(SRCDIR)/cmsfuncs.c $(SRCDIR)/shell.c $(SRCDIR)/rexxext.c $(SRCDIR)/stack.c \
	$(SRCDIR)/tracing.c $(SRCDIR)/interp.c $(SRCDIR)/cmath.c $(SRCDIR)/convert.c $(SRCDIR)/strings.c $(SRCDIR)/library.c \
	$(SRCDIR)/strmath.c $(SRCDIR)/signals.c $(SRCDIR)/macros.c $(SRCDIR)/envir.c $(SRCDIR)/expr.c \
	$(SRCDIR)/extlib.c $(SRCDIR)/wrappers.c $(SRCDIR)/options.c $(SRCDIR)/doscmd.c #$(SRCDIR)/r2perl.c

OFILES = funcs.$(OBJ) builtin.$(OBJ) error.$(OBJ) variable.$(OBJ) \
	interprt.$(OBJ) debug.$(OBJ) dbgfuncs.$(OBJ) memory.$(OBJ) parsing.$(OBJ) files.$(OBJ) \
	misc.$(OBJ) unxfuncs.$(OBJ) cmsfuncs.$(OBJ) shell.$(OBJ) rexxext.$(OBJ) stack.$(OBJ) \
	tracing.$(OBJ) interp.$(OBJ) cmath.$(OBJ) convert.$(OBJ) strings.$(OBJ) library.$(OBJ) \
	strmath.$(OBJ) signals.$(OBJ) macros.$(OBJ) envir.$(OBJ) expr.$(OBJ) \
	extlib.$(OBJ) yaccsrc.$(OBJ) lexsrc.$(OBJ) options.$(OBJ) doscmd.$(OBJ) wrappers.$(OBJ) #r2perl.$(OBJ)

SHOFILES = funcs.sho builtin.sho error.sho variable.sho \
	interprt.sho debug.sho dbgfuncs.sho memory.sho parsing.sho files.sho \
	misc.sho unxfuncs.sho cmsfuncs.sho shell.sho rexxext.sho stack.sho \
	tracing.sho interp.sho cmath.sho convert.sho strings.sho library.sho \
	strmath.sho signals.sho macros.sho envir.sho expr.sho \
	extlib.sho yaccsrc.sho lexsrc.sho wrappers.sho options.sho doscmd.sho \
	drexx.sho client.sho rexxsaa.sho

DEMODIR = $(SRCDIR)/demo
DEMOFILES = $(DEMODIR)/*
TRIPDIR = $(SRCDIR)/trip
TRIPFILES = $(TRIPDIR)/*

ALLSRC = $(CFILES) $(HFILES)

HFILES = $(SRCDIR)/rexx.h $(SRCDIR)/defs.h $(SRCDIR)/extern.h $(SRCDIR)/types.h \
		$(SRCDIR)/config.h $(SRCDIR)/strings.h $(SRCDIR)/configur.h $(SRCDIR)/symbols.h \
		$(SRCDIR)/rxiface.h $(SRCDIR)/rexxsaa.h $(SRCDIR)/utsname.h
CFILES = $(SRCDIR)/yaccsrc.c $(SRCDIR)/lexsrc.c $(CSRCFILES) $(SRCDIR)/execiser.c \
		$(SRCDIR)/rexxsaa.c $(SRCDIR)/rexx.c $(SRCDIR)/regina.c $(SRCDIR)/client.c \
		$(SRCDIR)/r2perl.c $(SRCDIR)/test1.c $(SRCDIR)/test2.c $(SRCDIR)/getopt.c

#.SUFFIXES: .sho $(SUFFIXES)
#
# Do not use default suffixes rule
#
.SUFFIXES:

all : rexx$(EXE) execiser$(EXE) $(SHL_TARGETS)

$(CSRCFILES) : $(SRCDIR)/rexx.h

$(SRCDIR)/rexx.h : $(SRCDIR)/extern.h $(SRCDIR)/strings.h $(SRCDIR)/defs.h $(SRCDIR)/types.h

rexx$(EXE) : $(OFILES) rexx.$(OBJ) $(OS2LIBA)
	$(PURIFY) $(CC) $(LINKOPT) $(STATIC_LDFLAGS) -o rexx $(OBJECTS) rexx.$(OBJ) $(OS2LIBA) $(LIBS)
	$(LDEXTRA)

regina$(EXE) : $(LIBPRE)$(SHLFILE).$(SHL) regina.$(OBJ) $(GETOPT) $(SHLIMPLIB) $(OS2LIBA)
	$(PURIFY) $(CC) $(LINKOPT) $(DYNAMIC_LDFLAGS) -o regina$(EXE) regina.$(OBJ) $(GETOPT) $(LINKSHL) $(LIBS) $(SHLIBS) $(OS2LIBA)
	$(LDEXTRA)

execiser$(EXE) : execiser.$(OBJ) $(LIBPRE)$(LIBFILE).$(LIBPST) $(OS2LIBA)
	$(PURIFY) $(CC) $(LINKOPT) -o execiser execiser.$(OBJ) $(LIBLINK) $(OS2LIBA)
	$(LDEXTRA)

$(LIBPRE)$(LIBFILE).$(LIBPST): $(OFILES) client.$(OBJ) drexx.$(OBJ) rexxsaa.$(OBJ)
	$(LIBEXE) $(LIBFLAGS) $(OBJECTS) client.$(OBJ) drexx.$(OBJ) rexxsaa.$(OBJ)
	$(RANLIB_LIB)

$(LIBPRE)$(SHLFILE).$(SHL): $(SHOFILES) $(SHLDEF) $(OS2LIB)
	$(SHL_LD)
	$(SHL1)
	$(SHL2)
	$(SHL3)
	$(SHL4)

$(OS2LIB):
	$(PURGEOS2LIB1)
	$(PURGEOS2LIB2)

$(OS2LIBA):
	$(PURGEOS2LIB1)
	$(PURGEOS2LIB2)

#
# Rules for static objects
#
funcs.$(OBJ) :   $(SRCDIR)/funcs.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/funcs.c

builtin.$(OBJ) : $(SRCDIR)/builtin.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/builtin.c

error.$(OBJ) :   $(SRCDIR)/error.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/error.c

variable.$(OBJ) :$(SRCDIR)/variable.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/variable.c

interprt.$(OBJ) :$(SRCDIR)/interprt.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/interprt.c

debug.$(OBJ) :   $(SRCDIR)/debug.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/debug.c

dbgfuncs.$(OBJ) :$(SRCDIR)/dbgfuncs.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/dbgfuncs.c

memory.$(OBJ) :  $(SRCDIR)/memory.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/memory.c

parsing.$(OBJ) : $(SRCDIR)/parsing.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/parsing.c

files.$(OBJ) :   $(SRCDIR)/files.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/files.c

misc.$(OBJ) :    $(SRCDIR)/misc.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/misc.c

unxfuncs.$(OBJ) :$(SRCDIR)/unxfuncs.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/unxfuncs.c

cmsfuncs.$(OBJ) :$(SRCDIR)/cmsfuncs.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/cmsfuncs.c

shell.$(OBJ) :   $(SRCDIR)/shell.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/shell.c

rexxext.$(OBJ) : $(SRCDIR)/rexxext.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/rexxext.c

stack.$(OBJ) :   $(SRCDIR)/stack.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/stack.c

tracing.$(OBJ) : $(SRCDIR)/tracing.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/tracing.c

interp.$(OBJ) :  $(SRCDIR)/interp.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/interp.c

cmath.$(OBJ) :   $(SRCDIR)/cmath.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/cmath.c

convert.$(OBJ) : $(SRCDIR)/convert.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/convert.c

strings.$(OBJ) : $(SRCDIR)/strings.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/strings.c

library.$(OBJ) : $(SRCDIR)/library.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/library.c

strmath.$(OBJ) : $(SRCDIR)/strmath.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/strmath.c

signals.$(OBJ) : $(SRCDIR)/signals.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/signals.c

macros.$(OBJ) :  $(SRCDIR)/macros.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/macros.c

envir.$(OBJ) :   $(SRCDIR)/envir.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/envir.c

expr.$(OBJ) :    $(SRCDIR)/expr.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/expr.c

extlib.$(OBJ) :  $(SRCDIR)/extlib.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/extlib.c

wrappers.$(OBJ) :$(SRCDIR)/wrappers.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/wrappers.c

options.$(OBJ) : $(SRCDIR)/options.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/options.c

doscmd.$(OBJ) :  $(SRCDIR)/doscmd.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/doscmd.c

rexx.$(OBJ) :    $(SRCDIR)/rexx.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/rexx.c

client.$(OBJ) :    $(SRCDIR)/client.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/client.c

rexxsaa.$(OBJ) :    $(SRCDIR)/rexxsaa.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/rexxsaa.c

regina.$(OBJ) :  $(SRCDIR)/regina.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/regina.c

drexx.$(OBJ) : $(SRCDIR)/rexx.c
	$(CC) $(COPT) -c -o drexx.$(OBJ) -DRXLIB $(SRCDIR)/rexx.c

lexsrc.$(OBJ) : $(SRCDIR)/lexsrc.c $(SRCDIR)/rexx.h $(SRCDIR)/symbols.h
	$(CC) $(OTHERCOPT) $(CC2O) -c $(SRCDIR)/lexsrc.c

yaccsrc.$(OBJ) : $(SRCDIR)/yaccsrc.c $(SRCDIR)/defs.h $(SRCDIR)/rexx.h
	$(CC) $(OTHERCOPT) $(CC2O) -c -DYYMAXDEPTH=10000 $(SRCDIR)/yaccsrc.c

execiser.$(OBJ) : $(SRCDIR)/execiser.c $(SRCDIR)/rexx.h
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/execiser.c

getopt.$(OBJ) : $(SRCDIR)/getopt.c
	$(CC) $(COPT) $(CC2O) -c $(SRCDIR)/getopt.c

#
# Rules for shared objects
#
funcs.sho :   $(SRCDIR)/funcs.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/funcs.c
	$(O2SHO)
	$(SAVE2O)

builtin.sho : $(SRCDIR)/builtin.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/builtin.c
	$(O2SHO)
	$(SAVE2O)

error.sho :   $(SRCDIR)/error.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/error.c
	$(O2SHO)
	$(SAVE2O)

variable.sho :$(SRCDIR)/variable.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/variable.c
	$(O2SHO)
	$(SAVE2O)

interprt.sho :$(SRCDIR)/interprt.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/interprt.c
	$(O2SHO)
	$(SAVE2O)

debug.sho :   $(SRCDIR)/debug.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/debug.c
	$(O2SHO)
	$(SAVE2O)

dbgfuncs.sho :$(SRCDIR)/dbgfuncs.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/dbgfuncs.c
	$(O2SHO)
	$(SAVE2O)

memory.sho :  $(SRCDIR)/memory.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/memory.c
	$(O2SHO)
	$(SAVE2O)

parsing.sho : $(SRCDIR)/parsing.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/parsing.c
	$(O2SHO)
	$(SAVE2O)

files.sho :   $(SRCDIR)/files.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/files.c
	$(O2SHO)
	$(SAVE2O)

misc.sho :    $(SRCDIR)/misc.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/misc.c
	$(O2SHO)
	$(SAVE2O)

unxfuncs.sho :$(SRCDIR)/unxfuncs.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/unxfuncs.c
	$(O2SHO)
	$(SAVE2O)

cmsfuncs.sho :$(SRCDIR)/cmsfuncs.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/cmsfuncs.c
	$(O2SHO)
	$(SAVE2O)

shell.sho :   $(SRCDIR)/shell.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/shell.c
	$(O2SHO)
	$(SAVE2O)

rexxext.sho : $(SRCDIR)/rexxext.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/rexxext.c
	$(O2SHO)
	$(SAVE2O)

stack.sho :   $(SRCDIR)/stack.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/stack.c
	$(O2SHO)
	$(SAVE2O)

tracing.sho : $(SRCDIR)/tracing.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/tracing.c
	$(O2SHO)
	$(SAVE2O)

interp.sho :  $(SRCDIR)/interp.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/interp.c
	$(O2SHO)
	$(SAVE2O)

cmath.sho :   $(SRCDIR)/cmath.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/cmath.c
	$(O2SHO)
	$(SAVE2O)

convert.sho : $(SRCDIR)/convert.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/convert.c
	$(O2SHO)
	$(SAVE2O)

strings.sho : $(SRCDIR)/strings.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/strings.c
	$(O2SHO)
	$(SAVE2O)

library.sho : $(SRCDIR)/library.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/library.c
	$(O2SHO)
	$(SAVE2O)

strmath.sho : $(SRCDIR)/strmath.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/strmath.c
	$(O2SHO)
	$(SAVE2O)

signals.sho : $(SRCDIR)/signals.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/signals.c
	$(O2SHO)
	$(SAVE2O)

macros.sho :  $(SRCDIR)/macros.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/macros.c
	$(O2SHO)
	$(SAVE2O)

envir.sho :   $(SRCDIR)/envir.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/envir.c
	$(O2SHO)
	$(SAVE2O)

expr.sho :    $(SRCDIR)/expr.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/expr.c
	$(O2SHO)
	$(SAVE2O)

extlib.sho :  $(SRCDIR)/extlib.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/extlib.c
	$(O2SHO)
	$(SAVE2O)

wrappers.sho :$(SRCDIR)/wrappers.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/wrappers.c
	$(O2SHO)
	$(SAVE2O)

options.sho : $(SRCDIR)/options.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/options.c
	$(O2SHO)
	$(SAVE2O)

doscmd.sho :  $(SRCDIR)/doscmd.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/doscmd.c
	$(O2SHO)
	$(SAVE2O)

rexx.sho :  $(SRCDIR)/rexx.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/rexx.c
	$(O2SHO)
	$(SAVE2O)

client.sho :  $(SRCDIR)/client.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/client.c
	$(O2SHO)
	$(SAVE2O)

rexxsaa.sho :  $(SRCDIR)/rexxsaa.c
	$(O2SAVE)
	$(CC) $(COPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/rexxsaa.c
	$(O2SHO)
	$(SAVE2O)

drexx.sho : $(SRCDIR)/rexx.c
	$(CC) $(COPT) $(DYN_COMP) -c -o drexx.sho -DRXLIB $(SRCDIR)/rexx.c

lexsrc.sho : $(SRCDIR)/lexsrc.c $(SRCDIR)/rexx.h $(SRCDIR)/symbols.h
	$(O2SAVE)
	$(CC) $(OTHERCOPT) $(CC2O) $(DYN_COMP) -c $(SRCDIR)/lexsrc.c
	$(O2SHO)
	$(SAVE2O)

yaccsrc.sho : $(SRCDIR)/yaccsrc.c $(SRCDIR)/defs.h $(SRCDIR)/rexx.h
	$(O2SAVE)
	$(CC) $(OTHERCOPT) $(CC2O) $(DYN_COMP) -c -DYYMAXDEPTH=10000 $(SRCDIR)/yaccsrc.c
	$(O2SHO)
	$(SAVE2O)

#
# Rules for sample programs
#
test1.$(OBJ): $(SRCDIR)/test1.c
	$(CC) -c $(COPT) $(CC2O) $(DYN_COMP) $(SRCDIR)/test1.c

test1.$(RXLIB): test1.$(OBJ) $(LIBPRE)$(SHLFILE).$(SHL)
	$(LD_RXLIB_PRE) test1.$(OBJ) $(LD_RXLIB1)

test2.$(OBJ): $(SRCDIR)/test2.c
	$(CC) -c $(COPT) $(CC2O) $(DYN_COMP) $(SRCDIR)/test2.c

test2.$(RXLIB): test2.$(OBJ) $(LIBPRE)$(SHLFILE).$(SHL)
	$(LD_RXLIB_PRE) test2.$(OBJ) $(LD_RXLIB2)

depend:
	makedepend $(CSRCFILES)

ARCHIVE_FILES = $(ALLSRC) $(README) $(SRCDIR)/makefile* $(SRCDIR)/*.rsp $(DEMOFILES) $(TRIPFILES)

dist: 
	tar -cvf - $(ARCHIVE_FILES) | gzip > Regina_$(VERDOT).tar.gz

tar:
	tar -cvf - $(ARCHIVE_FILES) | compress > Regina_$(VERDOT).tar.Z

zip:
	zip regna$(VER) $(ARCHIVE_FILES)

#
# below here not tested
#

install: rexx $(LIBPRE)$(LIBFILE).a
	cp rexx$(PROGEXT) $(BINDIR)/$(PROGNAME)$(PROGEXT)
	cp ../rexx.1 $(MANDIR)/rexx.$(MANEXT)
	cp $(LIBPRE)$(LIBFILE).a $(LIBDIR)/$(LIBPRE)$(LIBFILE).a
	ranlib $(LIBDIR)/$(LIBPRE)$(LIBFILE).a

clean: 
	rm -f $(JUNK) \#*\#
#
# End of makefile
#
