/*
 * PNTEST.C - test for the PDB file independent stuff
 *
 * Source Version: 9.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pdb.h"

#define NBYTES 100000
#define DATA_SRC "cray"

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* MAIN - test the PDB Library system */

main()
   {HASHTAB *chrt;
    FILE *fp;
    size_t bytepitem, nitems;
    char in[NBYTES];
    float a[1000];
    double b[1000];

                         .
                         .
                         .
                         .

/* target the file as asked */
    chrt = PN_target(&CRAY_STD, &UNICOS_ALIGNMENT);

/* make a few defstructs */
/*
    PN_defstr(chrt, "l_frame", &UNICOS_ALIGNMENT, 0,
              "float x_min",
              "float x_max",
              "float y_min",
              "float y_max",
              LAST);
    PN_defstr(strm, "plot", &UNICOS_ALIGNMENT, 0,
              "float x_axis(10)",
              "float y_axis(10)",
              "integer npts", 
              "char *label",
              "l_frame view",
              LAST);
*/

    fp = fopen(fname, BINARY_MODE_RPLUS);

/* read in and convert 100 floats */
    bytepitem = PN_sizeof("float", chrt);
    nitems    = 100;
    fread(in, bytepitem, nitems, fp);
    PN_conv_in(a, in, "float", nitems, chrt);

/* read in and convert 500 doubles */
    bytepitem = PN_sizeof("double", chrt);
    nitems    = 500;
    fread(in, bytepitem, nitems, fp);
    PN_conv_in(b, in, "double", nitems, chrt);

    fclose(fp);

    exit(0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
