// Usage: server [<DerivedEcho object name> <shutdown object name>]
//        names are COSNaming compound names (e.g. x/y/echo.obj)>]
//

#include <iostream.h>
#include <derivedEcho.hh>
#include <shutdown.hh>
#include <common/common.h>

CORBA::BOA_ptr boa;

class Echo_i : public virtual _sk_Echo {
public:
  Echo_i() {}
  virtual ~Echo_i() { cerr << "Echo_i::~Echo_i" << endl; }
  virtual char * echoString(const char *mesg);
};

char *
Echo_i::echoString(const char *mesg) {
  char *p = CORBA::string_dup(mesg);
  return p;
}

class DerivedEcho_i : public virtual Echo_i, public virtual _sk_DerivedEcho {
public:
  DerivedEcho_i() {}
  virtual CORBA::Long echoLong(CORBA::Long arg1) { return arg1; }
};

class Shutdown_i : public virtual _sk_Shutdown {
public:
  Shutdown_i() {}
  ~Shutdown_i() {}
  void off() { boa->impl_shutdown(); }
};

int
main(int argc, char **argv)
{
  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");
  boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

  CosNaming::Name use_echo_name;
  CosNaming::Name use_shutdown_name;
  if (argc > 1) {
    if (argc != 3) {
      cerr << "Usage: server [<DerivedEcho object name> <shutdown object name>]\n"
	   << "       names are COSNaming compound names (e.g. x/y/echo.obj)>]"
           << endl;
      return 1;
    }
    try {
      use_echo_name = string_to_name(argv[1]);
      use_shutdown_name = string_to_name(argv[2]);
    }
    catch (...) {
      cerr << argv[1] << " or " << argv[2]
	       << " is not a valid COS Naming compound name." << endl;
      return 1;
    }
  }

  DerivedEcho_i *myobj = new DerivedEcho_i;
  myobj->_obj_is_ready(boa);
  {
    DerivedEcho_var myobjRef = myobj->_this();
    if (use_echo_name.length()) {
      if (!bindObjectToName(orb,myobjRef,use_echo_name)) {
	return 1;
      }
    }
    else {
      CORBA::String_var p = orb->object_to_string(myobjRef);
      cerr << "DerivedEcho object: " << (char*)p << endl;
    }
  }

  Shutdown_i *myswitch = new Shutdown_i;
  myswitch->_obj_is_ready(boa);
  {
    CORBA::Object_var myobjRef = myswitch->_this();
    if (use_shutdown_name.length()) {
      if (!bindObjectToName(orb,myobjRef,use_shutdown_name)) {
	return 1;
      }
    }
    else {
      CORBA::String_var p = orb->object_to_string(myobjRef);
      cerr << "Offswitch object: " << (char*)p << endl;
    }
  }
  boa->impl_is_ready();
  myobj->_dispose();
  myswitch->_dispose();
  boa->destroy();
  return 0;
}

