// usage: client -i <stringified IOR>
//        client -i <stringified IOR> <new attribute: stringified IOR>
//        client <attribute object name>
//        client <attribute object name> <new attribute: read from this name>
//               Names are COSNaming compound names (e.g. x/y/test.obj
// 


#include <iostream.h>
#include <common/common.h>
#include <attrObjRef.hh>

int
main (int argc, char **argv) {

  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");
  
  CORBA::Boolean setobj = 0;
  attrObjRef_var e;
  CORBA::Object_var newvalue;

  switch (argc) {
  case 2:
  case 3:
  case 4:
    if (strcmp(argv[1],"-i") == 0) {
      if (argc > 2) {
	try {
	  CORBA::Object_var o = orb->string_to_object(argv[2]);
	  e = attrObjRef::_narrow(o);
	  if (argc > 3) {
	    newvalue = orb->string_to_object(argv[3]);
	    setobj = 1;
	  }
	  break;
	}
	catch (...) {
	  cerr << "Cannot convert stringified IOR to an object reference"
	       << endl;
	}
      }
    }
    else {
      try {
	CosNaming::Name attr_name = string_to_name(argv[1]);
	CORBA::Object_var o = getObjectReference(orb,attr_name);
	e = attrObjRef::_narrow(o);
	if (argc > 2) {
	  cerr << argv[2] << endl;
	  CosNaming::Name value_name = string_to_name(argv[2]);
	  newvalue = getObjectReference(orb,value_name);
	  setobj = 1;
	}
	break;
      }
      catch (...) {
	cerr << "Cannot resolve compound name to an object reference"
	     << endl;
      }
    }
  default:
    cerr << "usage: client -i <stringified IOR>\n"
	 << "       client -i <stringified IOR> <new attribute: stringified IOR>\n"
	 << "       client <attribute object name>\n"
	 << "       client <attribute object name> <new attribute: read from this name>\n"
	 << "       Names are COSNaming compound names (e.g. x/y/test.obj)"
	 << endl;
    return 1;
  }

  if (CORBA::is_nil(e))
    {
      cerr << "Can't create proxy for attribute object.\n" << endl;
      return(1);
    }

  try {
    if (setobj) {
      e->obj(newvalue);
    }
    else {
      CORBA::Object_var retvalue = e->obj();

      CORBA::String_var objstr;
      objstr = orb->object_to_string(retvalue);
      cerr  << (char*)objstr << endl;

      if (!CORBA::is_nil(retvalue)) {
	if (retvalue->_non_existent()) {
	  cerr << "Object does not exist." << endl;
	}
      }
      else { 
	cerr << "Object is nil." << endl;
      }
    }
  }
  catch (const CORBA::COMM_FAILURE&) {
    cerr << "Caught COMM_FAILURE exception. Exit." << endl;
  }
  return 0;
}
