/*
 *	Ohio Trollius
 *	(public domain software)
 *
 *	$Log:	tfgetc.c,v $
 * Revision 6.1  96/11/24  00:35:55  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  14:06:28  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  14:17:33  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:58:47  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:46:53  gdburns
 * Ohio Release
 * 
 * Revision 2.2  93/05/10  16:38:44  raja
 * pre-release to 2.3
 * 
 *	We are just putting our stamp on this for housekeeping reasons.
 */

/*
 * This file is originally from dLibs 1.2 by Dale Schumacher et al.
 * It was modified for Trollius by MB, 88/12.
 * It was modified again for portability by GDB, 91/08.
 * And yet again by JRV for LAM, 93/05.
 */

/*
 * The CRLF --> \n translation left in in case we ever go back to MS-DOS.
 */

#include <tstdio.h>

/*
 * external variables
 */
extern int _ioexit;

/*
 * external functions
 */
extern void tfcloseall();
extern void _getbuf();
extern int iomap_read();

int
tfgetc(fp)
	TFILE *fp;
{
	int c, f, m, look = 0;

	if (! _ioexit) {
		if (atkexit (tfcloseall, (char *) 0) != 0)
			return (EOF);
		_ioexit = 1;
	}

	f = (fp->_flag &= ~_TIORW);
	if(!(f & _TIOREAD) || (f & (_TIOERR | _TIOEOF)))
		return(EOF);
	if(fp->_base == NULL)	/* allocate a buffer if there wasn't one */
		_getbuf(fp);
_fgetc1:
	if(--(fp->_cnt) < 0) {
		m = (int) iomap_read(fp->_flag,
					fp->_file,
					(char *) fp->_base,
					(long) fp->_bsiz);
		if(m <= 0) {
			fp->_flag |= ((m == 0) ? _TIOEOF : _TIOERR);
			c = EOF;
			goto _fgetc2;
		}
		fp->_cnt = (m - 1);
		fp->_ptr = fp->_base;
	}
	c = *(fp->_ptr)++;
_fgetc2:
	if (!(f & _TIOBIN)) {		/* TRANSLATED STREAM PROCESSING */
		if (look) {			/* process lookahead */
			if(c != '\n') {		/* if not CR+LF.. */
				if(c == EOF) {	/* ..undo EOF.. */
					fp->_flag &= ~(_TIOERR | _TIOEOF);
				} else {	/* ..or unget character */
					*--(fp->_ptr) = c;
					++(fp->_cnt);
				}
				c = '\r';	/* return CR */
			}
		} else if(c == '\r') {		/* found CR */
			if(f & _TIODEV)		/* return it for tty */
				c = '\n';
			else {			/* else lookahead for LF */
				look = 1;
				goto _fgetc1;
			}
		} else if(c == 0x00) {		/* Ignore NUL's */
			goto _fgetc1;
		} else if(c == 0x1A) {		/* ^Z becomes EOF */
			fp->_flag |= _TIOEOF;
			c = EOF;
		}
	}
	return(c);
}

int
tfungetc(c, fp)
	int c;
	TFILE *fp;
{
	if((fp->_flag & (_TIOERR | _TIOEOF))	/* error or eof */
	|| (fp->_ptr <= fp->_base))		/* or too many ungets */
		return(EOF);
	++(fp->_cnt);
	return(*--(fp->_ptr) = c);
}
