/*
 *	Ohio Trollius
 *	Copyright 1994 The Ohio State University
 *	GDB
 *
 *	$Log:	rtrsimplex.c,v $
 * Revision 6.1  96/11/24  00:26:19  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  14:05:34  gdburns
 * Ohio Release
 * 
 *	Function:	- simple traced requests
 */

#include <events.h>
#include <net.h>
#include <trreq.h>

/*
 *	lam_rtrsweep
 *
 *	Function:	- sweeps out traced's stored trace data
 *			- no reply from traced
 *	Accepts:	- target node ID
 *			- list number
 *	Returns:	- return value of nsend()
 */
int
lam_rtrsweep(nodeid, lnum)

int4			nodeid;
int4			lnum;

{
	struct nmsg	nhead;		/* network message desc. */
	struct trreq  	*request;	/* traced request */

	request = (struct trreq *) nhead.nh_data;
	request->trq_req = TRQSWEEP;
	request->trq_lnum = lnum;
 	request->trq_pid = TRANYPID;
	
	nhead.nh_node = nodeid;
	nhead.nh_event = EVTRACED;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;

	return(nsend(&nhead));
}

/*	lam_rtrudie
 *
 *	Function:	- removes pid related information
 *			- no reply from traced
 *	Accepts:	- target node ID
 *			- pid
 *	Returns:	- return value of nsend()
 */
int
lam_rtrudie(nodeid, pid)

int4			nodeid;
int4			pid;

{
	struct nmsg	nhead;		/* network message desc. */
	struct trreq  	*request;	/* traced request */

	request = (struct trreq *) nhead.nh_data;
	request->trq_req = TRQUDIE;
	request->trq_pid = pid;

	nhead.nh_node = nodeid;
	nhead.nh_event = EVTRACED;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;

	return(nsend(&nhead));
}

/*	lam_rtrwipe
 *
 *	Function:	- resets traced
 *			- no reply from traced
 *	Accepts:	- target node ID
 *	Returns:	- return value of nsend()
 */
int
lam_rtrwipe(nodeid)

int4			nodeid;

{
	struct nmsg	nhead;		/* network message desc. */
	struct trreq  	*request;	/* traced request */

	request = (struct trreq *) nhead.nh_data;
	request->trq_req = TRQWIPE;

	nhead.nh_node = nodeid;
	nhead.nh_event = EVTRACED;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;

	return(nsend(&nhead));
}
