/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: sendrecvrep.c,v 6.1 96/11/23 22:54:09 nevin Rel $
 *
 *	Function:	- send and receive using same buffer
 *	Accepts:	- buffer
 *			- count
 *			- datatype
 *			- destination
 *			- send tag
 *			- source
 *			- receive tag
 *			- communicator
 *			- status (out)
 *	Returns: 	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

int
MPI_Sendrecv_replace(buf, count, dtype, dest, stag, src, rtag, comm, status)

void			*buf;
int			count;
MPI_Datatype		dtype;
int			dest;
int			stag;
int			src;
int			rtag;
MPI_Comm		comm;
MPI_Status		*status;

{
	int		err;			/* error code */
	int		fl_trace;		/* do tracing? */
	int		pkpos;			/* packing position */
	int		pksize;			/* packing size */
	char		*pkbuf;			/* packing buffer */

	lam_initerr();
	lam_setfunc(BLKMPISENDRECVREP);
/*
 * Check the arguments.
 */
	err = lam_chkarg(buf, count, dtype, dest, stag, comm);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPISENDRECVREP, err));
	}

	err = lam_chkarg(buf, count, dtype, src, rtag, comm);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPISENDRECVREP, err));
	}

	if (status == 0) {
		return(lam_errfunc(comm,
			BLKMPISENDRECVREP, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Generate a start wrapper trace.
 */
	fl_trace = ((_kio.ki_rtf & RTF_TRON) == RTF_TRON);

	if (fl_trace) {
		lam_tr_wrapstart(BLKMPISENDRECVREP);
	}
/*
 * Pack the message to send.
 */
	err = MPI_Pack_size(count, dtype, comm, &pksize);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPISENDRECVREP, err));
	}

	if (pksize > 0) {
		pkbuf = malloc((unsigned) pksize);
		if (pkbuf == 0) {
			return(lam_errfunc(comm, BLKMPISENDRECVREP,
					lam_mkerr(MPI_ERR_OTHER, errno)));
		}
	} else {
		pkbuf = 0;
	}

	pkpos = 0;

	err = MPI_Pack(buf, count, dtype, pkbuf, pksize, &pkpos, comm);
	if (err != MPI_SUCCESS) {
		if (pkbuf) free(pkbuf);
		return(lam_errfunc(comm, BLKMPISENDRECVREP, err));
	}
/*
 * Send & receive.
 */
	err = MPI_Sendrecv(pkbuf, pksize, MPI_PACKED, dest, stag,
				buf, count, dtype, src, rtag, comm, status);
	if (err != MPI_SUCCESS) {
		if (pkbuf) free(pkbuf);
		return(lam_errfunc(comm, BLKMPISENDRECVREP, err));
	}

	if (pkbuf) free(pkbuf);
/*
 * Generate an end wrapper trace.
 */
	if (fl_trace) {
		lam_tr_wrapend(BLKMPISENDRECVREP);
	}
	
	lam_resetfunc(BLKMPISENDRECVREP);
	return(MPI_SUCCESS);
}
