/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: reqfree.c,v 6.1 96/11/23 22:53:51 nevin Rel $
 *
 *	Function:	- free communication request
 *	Accepts:	- ptr to request
 *	Returns: 	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>

/*
 * external functions
 */
extern void		lam_initerr();
extern void		lam_resetfunc();
extern void		lam_setfunc();
extern void		_mpi_req_rem();
extern int		lam_errfunc();
extern int		lam_mkerr();
extern int		_mpi_req_destroy();
extern int		_mpi_req_end();

int
MPI_Request_free(preq)

MPI_Request		*preq;

{
	MPI_Request	req;			/* request */
	int		err;			/* error code */

	lam_initerr();
	lam_setfunc(BLKMPIREQFREE);
/*
 * Check arguments.
 */
	if (preq == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIREQFREE, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if ((req = *preq) == MPI_REQUEST_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIREQFREE, lam_mkerr(MPI_ERR_REQUEST, 0)));
	}
/*
 * If active, flag it for destruction.
 * Otherwise destroy it.
 */
	if (req->rq_state == LAM_RQSACTIVE || req->rq_state == LAM_RQSSTART) {

		req->rq_flags |= LAM_RQFORPHAN;
	}
	else {
		_mpi_req_rem(req);

		if (req->rq_state == LAM_RQSDONE) {
			err = _mpi_req_end(req);
			if (err != MPI_SUCCESS) {
				return(lam_errfunc(MPI_COMM_WORLD,
						BLKMPIREQFREE, err));
			}
		}

		err = _mpi_req_destroy(preq);
		if (err != MPI_SUCCESS) {
			return(lam_errfunc(MPI_COMM_WORLD,
					BLKMPIREQFREE, err));
		}
	}

	*preq = MPI_REQUEST_NULL;
	
	lam_resetfunc(BLKMPIREQFREE);
	return(MPI_SUCCESS);
}
