/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: mpietc.c,v 6.1 96/11/23 22:53:25 nevin Rel $
 *
 *	Function:	- misc. shared MPI-related functions
 *			- used by libmpi and MPI tools
 */

#include <mpi.h>
#include <mpisys.h>

/*
 * macros
 */
#define FLIPCID(x)	(-((x) + 1))

/*
 *	lam_pt2coll
 *
 *	Function:	- change context ID from pt2pt to collective
 *	Accepts:	- pt2pt context ID
 *	Returns:	- collective context ID
 */
int
lam_pt2coll(cid)

int			cid;

{
	if (cid >= 0) cid = FLIPCID(cid);
	return(cid);
}

/*
 *	lam_coll2pt
 *
 *	Function:	- change context ID from collective to pt2pt
 *	Accepts:	- collective context ID
 *	Returns:	- pt2pt context ID
 */
int
lam_coll2pt(cid)

int			cid;

{
	if (cid < 0) cid = FLIPCID(cid);
	return(cid);
}

/*
 *	lam_mkcoll
 *
 *	Function:	- switch communicator to collective context ID
 *	Accepts:	- communicator
 */
void
lam_mkcoll(comm)

MPI_Comm		comm;

{
	if (comm) comm->c_contextid = lam_pt2coll(comm->c_contextid);
}

/*
 *	lam_mkpt
 *
 *	Function:	- switch communicator to pt2pt context ID
 *	Accepts:	- communicator
 */
void
lam_mkpt(comm)

MPI_Comm		comm;

{
	if (comm) comm->c_contextid = lam_coll2pt(comm->c_contextid);
}

/*
 *	lam_unsyncsql
 *
 *	Function:	- extract SQL sync. information
 *	Accepts:	- event
 *			- type
 *			- ptr tag (returned value)
 *			- ptr context ID (returned value)
 *			- ptr ACK flag (returned value)
 *			- ptr destination index (returned value)
 *			- ptr source node (returned value)
 *			- ptr source index (returned value)
 */
void
lam_unsyncsql(event, type, ptag, pcid, pack, pdidx, psnode, psidx)

int			event;
int			type;
int			*ptag;
int			*pcid;
int			*pack;
int			*pdidx;
int			*psnode;
int			*psidx;

{
	*pdidx = event & 0x7FFF;
	*pack = event & 0x10000;
	*pcid = (event >> 18) & 0xFFF;
	if (*pcid & 0x800) *pcid |= 0xFFFFF000;

	*ptag = type & 0xFFFF;
	if (*ptag & 0x8000) *ptag |= 0xFFFF0000;

	type >>= 16;
	*psnode = type & 0x3FF;
	*psidx = (type >> 10) & 0x3F;

	if (*psnode == 0x3FF) *psnode = MPI_ANY_SOURCE;
	if (*psidx == 0x3F) *psidx = MPI_ANY_SOURCE;
}
