/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN/RBD
 *
 *	$Id: lamcomm.c,v 6.1 96/11/22 13:35:01 nevin Rel $
 *
 *	Function:	- miscellaneous communicator functions
 */

#include <stdlib.h>

#include <mpi.h>
#include <mpisys.h>
#include <typical.h>

/*
 * public functions
 */
int			lam_comm_free();
int			lam_comm_new();


/*
 *	lam_comm_free
 *
 *	Function:	- really free a communicator
 *	Accepts:	- communicator
 *	Returns:	- 0 or LAMERROR
 */
int
lam_comm_free(comm)

MPI_Comm		comm;

{
	int		err;
	int		key;
	struct _attr	*p;
/*
 * Free the groups.
 */
	err = MPI_Group_free(&(comm->c_group));
	if (err != MPI_SUCCESS) return(err);

	if (LAM_IS_INTER(comm)) {
		err = MPI_Group_free(&(comm->c_rgroup));
		if (err != MPI_SUCCESS) return(err);
	}
/*
 * Free the attribute keys.
 */
	if (comm->c_keys) {
		p = (struct _attr *) ah_top(comm->c_keys);
		while (p) {
			key = p->a_key;
			err = MPI_Attr_delete(comm, key);
			if (err != MPI_SUCCESS) return(err);

			err = MPI_Keyval_free(&key);
			if (err != MPI_SUCCESS) return(err);

			p = (struct _attr *) ah_next(comm->c_keys, (void *) p);
		}
		ah_free(comm->c_keys);
	}
/*
 * Free the error handler.
 */
	err = MPI_Errhandler_free(&(comm->c_errhdl));
	if (err != MPI_SUCCESS) return(err);
/*
 * Free topology information.
 */
	if (LAM_IS_CART(comm)) {
		free((char *) comm->c_topo_dims);
	} else if (LAM_IS_GRAPH(comm)) {
		free((char *) comm->c_topo_index);
	}
/*
 * Free the context ID.
 */
	lam_rmcid(comm->c_contextid);
/*
 * Remove the communicator from the communicator list and free it.
 */
	al_delete(lam_comms, al_find(lam_comms, &comm));
	free((char *) comm);

	return(MPI_SUCCESS);
}


/*
 *	lam_comm_new
 *
 *	Function:	- initalize a new communicator
 *			- allocates storage for new communicator if necessary
 *	Accepts:	- context ID
 *			- local group
 *			- remote group
 *			- communicator flags
 *			- communicator (inout)
 *	Returns:	- 0 or LAMERROR
 */
int
lam_comm_new(cid, l_group, r_group, flags, comm)

int			cid;
MPI_Group		l_group;
MPI_Group		r_group;
int			flags;
MPI_Comm		*comm;

{
	if (*comm == 0) {
		if ((*comm = (MPI_Comm) malloc(sizeof(struct _comm))) == 0) {
			return(LAMERROR);
		}
	}
	(*comm)->c_flags = flags;
	(*comm)->c_refcount = 1;
	(*comm)->c_cube_dim = lam_cubedim(l_group->g_nprocs);
	(*comm)->c_group = l_group;
	(*comm)->c_rgroup = (flags & LAM_CINTER) ? r_group : MPI_GROUP_NULL;
	(*comm)->c_contextid = cid;
	(*comm)->c_errhdl = MPI_ERRORS_ARE_FATAL;
	(*comm)->c_keys = 0;
	(*comm)->c_topo_type = MPI_UNDEFINED;
	(*comm)->c_topo_nprocs = 0;
	(*comm)->c_topo_ndims = 0;
	(*comm)->c_topo_dims = 0;
	(*comm)->c_topo_index = 0;
	(*comm)->c_topo_nedges = 0;
	(*comm)->c_topo_edges = 0;

	return(0);
}
