/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: infogetvlen.c,v 6.1 96/11/22 13:34:58 nevin Rel $
 *
 *	Function:	- get length of info value associated with key
 *	Accepts:	- info
 *			- key
 *			- value length (out)
 *			- key found flag (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <string.h>

#include <all_list.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>


int
MPI_Info_get_valuelen(info, key, valuelen, flag)

MPI_Info		info;
char			*key;
int			*valuelen;
int			*flag;

{
	struct _info	search;			/* search element */
	struct _info	*found;			/* found key/value pair */
	int		key_len;		/* length of key */
	
        lam_initerr();
	lam_setfunc(BLKMPIINFOVALLEN);
	
	if (info == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOVALLEN,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}

	key_len = strlen(key);
	if (key_len == 0 || key_len > MPI_INFO_MAX_KEYLEN) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOVALLEN,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}

	strcpy(search.info_key, key);

	if ((found = al_find((LIST *) info, &search))) {
		*flag = 1;
		*valuelen = strlen(found->info_value);
	} else {
		*flag = 0;
	}

        lam_resetfunc(BLKMPIINFOVALLEN);
	return(MPI_SUCCESS);
}
