/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: infoget.c,v 6.1 96/11/22 13:34:56 nevin Rel $
 *
 *	Function:	- get info value associated with key 
 *	Accepts:	- info
 *			- key
 *			- maximum length of value
 *			- value (returned)
 *			- key found flag (returned)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <string.h>

#include <all_list.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>


int
MPI_Info_get(info, key, valuelen, value, flag)

MPI_Info		info;
char			*key;
int			valuelen;
char			*value;
int			*flag;

{
	struct _info	search;			/* search element */
	struct _info	*found;			/* found key/value pair */
	int		key_len;		/* key length */
	int		val_len;		/* stored value length */
	
        lam_initerr();
	lam_setfunc(BLKMPIINFOGET);
	
	if (info == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOGET,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}

	key_len = strlen(key);
	if (key_len == 0 || key_len > MPI_INFO_MAX_KEYLEN) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOGET,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}

	strcpy(search.info_key, key);

	if ((found = al_find((LIST *) info, &search))) {
		*flag = 1;
		val_len = strlen(found->info_value);
		if (val_len > valuelen) {
			strncpy(value, found->info_value, valuelen); 
			return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOGET,
					lam_mkerr(MPI_ERR_VALUE, 0)));
		} else {
			strcpy(value, found->info_value);
		}
	} else {
		*flag = 0;
	}

        lam_resetfunc(BLKMPIINFOGET);
	return(MPI_SUCCESS);
}
