/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio	State University
 *	RBD/NJN
 *
 *	$Id: testany_f.c,v 6.1.1.1 97/03/24 14:58:25 nevin Exp Locker: nevin $
 *
 *	Function:	- MPI_Testany F77 wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <MPISYS.h>
#include <mpisys.h>

void
mpi_testany_(c,	rqs, idx, f, st, ierr)

int			*c, *rqs, *idx,	*f, *st, *ierr;

{
	MPI_Request	*reqs;
	MPI_Status	stat;
	int		i;

	if (*c > 0) {
		reqs = (MPI_Request *) malloc((*c) * sizeof(MPI_Request));
		if (reqs == 0) {
			lam_setfunc_m(BLKMPITESTANY);
			*ierr = lam_errfunc(MPI_COMM_WORLD, BLKMPITESTANY,
					lam_mkerr(MPI_ERR_OTHER, errno));
			return;
		}
	} else {
		reqs = 0;
	}

	for (i = 0; i <	*c; ++i) reqs[i] = GETHDL(rqs[i]);

	*ierr =	MPI_Testany(*c,	reqs, idx, f, &stat);

	if (*ierr == MPI_SUCCESS && *f) {
		lam_C2F_stat(&stat, st);
		st[6] =	-1;

		if (*idx >= 0) {
			if (reqs[*idx] == MPI_REQUEST_NULL) {
				lam_F_typefree(rqs[*idx]);
				rqs[*idx] = -1;
			}

			++(*idx);
		}
	}

	free((char *) reqs);
}
