/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio	State University
 *	NJN
 *
 *	$Id: infoset_f.c,v 6.1 96/11/22 13:44:37 nevin Rel $
 *
 *	Function:	- MPI_Info_set F77 wrapper
 */

#include <lam_config.h>

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <MPISYS.h>
#include <mpisys.h>

void
mpi_info_set_(i, k, v, ierr, nk, nv)

int			*i, *ierr;
char			*k, *v;
int			nk, nv;

{
	char		*key;
	char		*value;

	key = lam_F2C_string(k,	nk);
	value =	lam_F2C_string(v, nv);
	if (key	== 0 ||	value == 0) {
		if (key) free(key);
		if (value) free(value);
		lam_setfunc(BLKMPIINFOSET);
		*ierr =	lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOSET,
					lam_mkerr(MPI_ERR_OTHER, errno));
		return;
	}
	
	*ierr =	MPI_Info_set(GETHDL(*i), key, value);

	free(key);
	free(value);
}
