/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/GDB
 *
 *	$Id: ccreate.c,v 6.1 96/11/23 22:51:21 nevin Rel $
 *
 *	Function:	- create a new communicator
 *	Accepts:	- old communicator
 *			- new group
 *			- ptr new communicator
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

/*
 * external functions
 */
extern int		lam_cubedim();
extern int		lam_tr_comm();

int
MPI_Comm_create(comm, group, newcomm)

MPI_Comm		comm;
MPI_Group		group;
MPI_Comm		*newcomm;

{
	int		mycid;			/* local max context ID */
	int		cid;			/* global max context ID */
	int		rank;			/* process rank */
	int		err;			/* error code */

	lam_initerr();
	lam_setfunc(BLKMPICOMMCREATE);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPICOMMCREATE,
				lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (LAM_IS_INTER(comm)) {
		return(lam_errfunc(comm, BLKMPICOMMCREATE,
				lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (group == MPI_GROUP_NULL) {
		return(lam_errfunc(comm, BLKMPICOMMCREATE,
				lam_mkerr(MPI_ERR_GROUP, 0)));
	}

	if (newcomm == 0) {
		return(lam_errfunc(comm, BLKMPICOMMCREATE,
				lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Create the new context ID using MPI_Allreduce().
 * Processes not in group participate but do not affect the context ID.
 */
	rank = group->g_myrank;

	mycid = (rank == MPI_UNDEFINED) ? 0 : lam_getcid();
	if (mycid < 0) {
		return(lam_errfunc(comm, BLKMPICOMMCREATE,
				lam_mkerr(MPI_ERR_INTERN, EFULL)));
	}
/*
 * Set up tracing.
 */
	LAM_TRACE(lam_tr_cffstart(BLKMPICOMMCREATE));

	err = MPI_Allreduce(&mycid, &cid, 1, MPI_INT, MPI_MAX, comm);
	if (err != MPI_SUCCESS) {
		LAM_TRACE(lam_tr_cffend(BLKMPICOMMCREATE, -1, comm, 0, 0));
		lam_resetfunc(BLKMPICOMMCREATE);
		return(lam_errfunc(comm, BLKMPICOMMCREATE, err));
	}

	if (rank == MPI_UNDEFINED) {
		*newcomm = MPI_COMM_NULL;
		LAM_TRACE(lam_tr_cffend(BLKMPICOMMCREATE, -1, comm, 0, 0));
		lam_resetfunc(BLKMPICOMMCREATE);
		return(MPI_SUCCESS);
	}
/*
 * Create the new communicator.
 */
	*newcomm = 0;
	if (lam_comm_new(cid, group, MPI_GROUP_NULL, 0, newcomm)) {
		return(lam_errfunc(comm, BLKMPICOMMCREATE,
				lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	group->g_refcount++;
	(*newcomm)->c_errhdl = comm->c_errhdl;
	comm->c_errhdl->eh_refcount++;

	if (!al_insert(lam_comms, newcomm)) {
		return(lam_errfunc(comm, BLKMPICOMMCREATE,
				lam_mkerr(MPI_ERR_INTERN, errno)));
	}
	
	if (lam_tr_comm(*newcomm)) {
		return(lam_errfunc(comm, BLKMPICOMMCREATE,
				lam_mkerr(MPI_ERR_INTERN, errno)));
	}

 	lam_setcid(cid);

	LAM_TRACE(lam_tr_cffend(BLKMPICOMMCREATE, -1, comm, 0, 0));

	lam_resetfunc(BLKMPICOMMCREATE);
	return(MPI_SUCCESS);
}
