/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log:	ktrace.c,v $
 * Revision 6.1  96/11/23  22:49:25  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/03/13  18:29:23  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.2  96/03/13  18:28:42  gdburns
 * Increment loop by TRHQUAN.
 * 
 * Revision 5.2.1.1  96/01/13  11:18:37  gdburns
 * major overhaul
 * 
 * Revision 5.2  94/08/22  14:01:43  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:45:31  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:39:33  gdburns
 * Ohio Release
 * 
 *	Function:	- runtime trace package
 *			- an internal package, hence does not check or
 *			  return many error conditions
 */

#include <stdlib.h>

#include <kio.h>
#include <ktrace.h>
#include <net.h>
#include <mpitrace.h>
#include <portable.h>
#include <trreq.h>

/*
 * external variables
 */
extern struct kio_t	_kio;			/* Kernel Input/Output block */
extern int		errno;			/* global error variable */

/*
 * local functions
 */
static void		tralloc();		/* allocate trace buffers */

/*
 * global functions
 */
void			lam_trexit();		/* trace cleanup */
void			lam_trinit();		/* initialize traces */
void			lam_trunload();		/* unload traces to traced */

/*
 *	lam_trinit
 *
 *	Function:	- initializes trace system
 */
void
lam_trinit()

{
	int		i;			/* favourite index */
/*
 * Initialize trace buffer header array.
 * Its size limits the total size of trace data per process
 * since each individual trace buffer is MAXNMSGLEN long.
 */
	_kio.ki_tid = getpid();
	_kio.ki_trcurr = 0;
	_kio.ki_trhead = (struct trhead *) malloc((unsigned)
		(TRHMAX * sizeof(struct trhead)));

	if (! _kio.ki_trhead) {
		kexit(errno);
	}

	for (i = 0; i < TRHMAX; ++i) {
		_kio.ki_trhead[i].trh_length = 0;
		_kio.ki_trhead[i].trh_buf = 0;
	}
/*
 * Vector SIGTRACE to unload trace data to the local daemon.
 * Register a cleanup function.
 */
	ksignal(SIGTRACE, lam_trunload);
	atkexit(lam_trexit, (char *) 0);
/*
 * Allocate the first few trace buffers.
 */
	tralloc(0);
}

/*
 *	tralloc
 *
 *	Functions:	- allocates memory for the next few trace buffers
 *			- next TRHQUAN buffers are allocated
 *			- assumes TRHQUAN evenly divides TRHMAX
 *	Accepts:	- index of first trace buffer ptr
 */
static void
tralloc(idx)

int			idx;

{
	int		i;
	int		imax;
	char		*p;

	p = malloc((unsigned) (MAXNMSGLEN * TRHQUAN));
	if (! p) kexit(errno);

	imax = idx + TRHQUAN;

	for (i = idx; i < imax; ++i) {
		_kio.ki_trhead[i].trh_buf = p;
		p += MAXNMSGLEN;
	}
}

/*
 *	lam_trunload
 *
 *	Function:	- unloads used trace buffers to local trace daemon
 */
void
lam_trunload()

{
	int		i;

	for (i = 0; i < TRHMAX; ++i) {

		if (_kio.ki_trhead[i].trh_length > 0) {

			if (lam_rtrstore(LOCAL, TRRUNTIME, _kio.ki_tid,
					_kio.ki_trhead[i].trh_buf,
					_kio.ki_trhead[i].trh_length) < 0) {
				kexit(errno);
			}

			_kio.ki_trhead[i].trh_length = 0;
		}
	}

	_kio.ki_trcurr = 0;
}

/*
 *	lam_trpoint
 *
 *	Function:	- determines where the next trace can be stored
 *			- calls tralloc, if necessary
 *			- may permanently turn off tracing if all buffers fill
 *	Accepts:	- size of next trace
 *	Returns:	- ptr to next trace location
 */
char *
lam_trpoint(size)

int			size;

{
	struct trhead	*p;

	p = _kio.ki_trhead + _kio.ki_trcurr;
/*
 * If the current trace buffer is filled, move to the next one.
 */
	if ((p->trh_length + size) > MAXNMSGLEN) {
/*
 * Flush the trace buffers if we've used up the last one.
 */
		if (_kio.ki_trcurr == (TRHMAX - 1)) {
			lam_trunload();
			p = _kio.ki_trhead + _kio.ki_trcurr;
		} else {
			_kio.ki_trcurr += 1;
			p++;
/*
 * If the next trace buffer is unallocated, allocate it plus a few more.
 */
			if (p->trh_buf == 0) {
				tralloc(_kio.ki_trcurr);
			}
		}
	}
/*
 * Increment the trace buffer length before passing the address to be stored.
 */
	p->trh_length += size;
	return(p->trh_buf + (p->trh_length - size));
}

/*
 *	lam_trexit
 *
 *	Function:	- cleanup trace system prior to process exit
 */
void
lam_trexit()

{
	int		i;
/*
 * Unload all traces to the local daemon.
 */
	lam_trunload();
/*
 * Free all trace buffers.
 */
	for (i = 0; i < TRHMAX; i += TRHQUAN) {

		if (_kio.ki_trhead[i].trh_buf != 0) {
			free(_kio.ki_trhead[i].trh_buf);
		}
	}
/*
 * Free the trace header array.
 */
	free((char *) _kio.ki_trhead);
}
