/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: kinit.c,v 6.1 96/11/23 22:49:14 nevin Rel $
 *
 *	Function:	- initializes data structures for kernel interface
 *			- calls kattach()
 *			- based on Trollius 2.0 Copyright 1990
 *			  The Ohio State University and Cornell Research
 *			  Foundation
 *	Accepts:	- scheduling priority
 */

#include <fcntl.h>
#include <stdio.h>

#include <freq.h>
#include <kio.h>
#include <kreq.h>
#include <ktrace.h>
#include <net.h>
#include <typical.h>

/*
 * external data structures
 */
extern struct kio_t	_kio;		/* Kernel I/O block */
extern struct fclient	_ufd[FUMAX];	/* user file desc. */

/*
 * external functions
 */
extern int		_cipc_init();	/* initialize kernel I/O */
extern void		_ksig_init();	/* initialize signals */
extern void		_vcfree();	/* free v.c. table */

int
kinit(priority)

int			priority;	/* new process priority */

{
	int		i;		/* favourite index */

	if (_kio.ki_pid != getpid()) {
/*
 * Initialize signal handling module.
 */
		_ksig_init();
/*
 * Initialize the exit table.
 */
		for (i = 0; i < TNEXIT; ++i) {
			_kio.ki_exit[i] = (void (*)()) 0;
		}
/*
 * Initialize route cache.
 */
		for (i = 0; i < MAXRCACHE; ++i) {
			_kio.ki_route[i].r_nodeid = NOTNODEID;
		}

		_kio.ki_nodeid = NOTNODEID;
		_kio.ki_origin = NOTNODEID;
		_kio.ki_index = -1;
		_kio.ki_jobid = ((getpid() << 16) | getnodeid());
/*
 * Free the virtual circuit table.
 */
		if (_kio.ki_pid < 0) {
			_vcfree();
		}
/*
 * Initialize kernel request interface.
 */
		if (_cipc_init()) {
			return(LAMERROR);
		}
/*
 * Initialize user file descriptor table
 */
		for (i = 0; i < FUMAX; ++i) {
			_ufd[i].fu_tflags = 0;
		}

		_ufd[0].fu_tflags = LAM_O_RDONLY | LAM_O_1WAY;
		_ufd[0].fu_node = _kio.ki_ionode;
		_ufd[0].fu_tfd = _kio.ki_stdin;
		_ufd[1].fu_tflags = LAM_O_WRONLY | LAM_O_1WAY;
		_ufd[1].fu_node = _kio.ki_ionode;
		_ufd[1].fu_tfd = _kio.ki_stdout;
		_ufd[2].fu_tflags = LAM_O_WRONLY | LAM_O_1WAY;
		_ufd[2].fu_node = _kio.ki_ionode;
		_ufd[2].fu_tfd = _kio.ki_stderr;

		atkexit(rfatexit, (char *) 0);
/*
 * Attach process to the kernel.
 */
		if (kattach(priority)) {
			return(LAMERROR);
		}
/*
 * Connect UNIX stdio to IO daemon.
 */
	if ((_kio.ki_rtf & RTF_IO) && !(_kio.ki_rtf & RTF_PFDIO)) {
		if (lioattach(stdout, _kio.ki_ionode, _kio.ki_stdout,
				(_kio.ki_rtf & RTF_TTYOUT) ? _IOLBF : _IOFBF)) {
			return(LAMERROR);
		}
		if (lioattach(stderr, _kio.ki_ionode, _kio.ki_stderr, _IONBF)) {
			return(LAMERROR);
		}
	}
/*
 * Initialize the trace subsystem.
 */
		if (_kio.ki_rtf & RTF_TRACE) {
			lam_trinit();
		}

		return(0);
	}

	else {
/*
 * Attach process to the kernel.
 */
		return(kattach(priority));
	}
}
