/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: shm.hpux.h,v 6.1.1.2 97/03/24 12:04:10 nevin Exp $
 *
 *	Function:	- shared memory / TCP client-to-client interface header
 *			- HP user level spinlocks
 */

#ifndef _SHM_HPUX_H
#define _SHM_HPUX_H

#include <errno.h>
#include <sys/ipc.h>
#include <sys/shm.h>

#include <all_hash.h>
#include <all_list.h>
#include <mpisys.h>
#include <portable.h>
#include <t_types.h>

/*
 * constants
 */
#define CACHELINESIZE   64			/* max. size of a cache line */
#define C2CINITSIZE	0			/* initialization data size */
#define INITHASH	((int4) 32)		/* initial hash table size */
#define LAMSHMDELAY	10			/* poll loop delay (usecs) */
#define TCPSHORTMSGLEN 	16384			/* max. length short tcp msg */
#define SHMBLKSIZE 	16384			/* size of shm block */
#define SHMBUFSIZE 	(SHMBLKSIZE / 2)	/* size of shm buffer */
#define SHMSHORTMSGLEN \
		(SHMBUFSIZE - (sizeof(struct c2c_envl) + (2 * CACHELINESIZE)))
						/* max. length short shm msg */
/*
 * data structures
 */
typedef int 		hplock_t[4];

/*
 * client-to-client specific process data
 */
struct c2c_proc {
	struct c2c_envl	cp_env;			/* incoming envelope */
	int		cp_write;		/* ok to try to write flag */
	int		cp_read;		/* ok to try to read flag */
	int		cp_sock;		/* socket descriptor */
	char		*cp_envbuf;		/* envelope buffer pointer */
	int		cp_nenvin;		/* # env. bytes left to read */
	char		*cp_msgbuf;		/* message buffer pointer */
	int		cp_nmsgin;		/* # msg. bytes left to read */
	int		cp_extra;		/* # bytes to go into sink */
	int		cp_shm;			/* id of shm block */
	int		cp_locked;		/* reader has a lock? */
	volatile int	*cp_irdlock;		/* input read lock */
	volatile int	*cp_iwtlock;		/* input write lock */
	volatile int	*cp_ordlock;		/* output read lock */
	volatile int	*cp_owtlock;		/* output write lock */
	char		*cp_shmbuf;		/* shared memory buffer */
	char		*cp_shmout;		/* outgoing shm buffer */
	char		*cp_shmin;		/* incoming shm buffer */
	MPI_Request	cp_wreq;		/* req. writing to process */
	MPI_Request	cp_rreq;		/* reading req. */
	MPI_Request	cp_mreq;		/* req. to test matching from */
	int		(*cp_readfn)();		/* read function */
	struct cbuf_msg *cp_bmsg;		/* buffering? */
	int		cp_nbfde;		/* # buffered envelopes */
};

/*
 * locking macros
 */
#define _shm_readlock(p)	(_hp_lock((p)->cp_irdlock), 0)
#define _shm_readtrylock(p)	_hp_trylock((p)->cp_irdlock)
#define _shm_readunlock(p)	((*(p)->cp_iwtlock = 1), 0)

#define _shm_writelock(p)	(_hp_lock((p)->cp_owtlock), 0)
#define _shm_writetrylock(p)	_hp_trylock((p)->cp_owtlock)
#define _shm_writeunlock(p)	(_hp_unlock((p)->cp_ordlock), 0)

/*
 * prototypes of client-to-client internal functions
 */
#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern void	_hp_lockinit __ARGS((volatile int *));
extern void	_hp_lock __ARGS((volatile int *));
extern void	_hp_unlock __ARGS((volatile int *));
extern int	_hp_trylock __ARGS((volatile int *));

#ifdef __cplusplus
}
#endif

#endif	/* _SHM_HPUX_H */
