/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log:	rfstat.c,v $
 * Revision 6.1  96/11/23  19:58:58  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:50:11  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.2  95/11/20  13:10:39  gdburns
 * Remove Cubix.
 * Qualify names for LAM.
 * 
 * Revision 5.2.1.1  95/06/25  14:44:43  raja
 * Include <sys/types.h>.
 * 
 * Revision 5.2  94/08/22  13:59:17  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  10:58:15  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:38:29  gdburns
 * Ohio Release
 * 
 *	Function:	- rffstat() and rfstat()
 *			- get file status
 */

#include <sys/types.h>
#include <sys/stat.h>

#include <freq.h>
#include <net.h>
#include <portable.h>
#include <typical.h>

/*
 * external variables
 */
extern int		errno;		/* error number */
extern struct fclient	_ufd[FUMAX];	/* client file descriptor table */

/*
 * external functions
 */
extern int		_fdvalid();	/* check validity of file desc */
extern int4		_makefreq();	/* make simple file request */
extern char		*_fnparse();	/* parse nodeid from file name */

/*
 * local functions
 */
static void		conv_stat();	/* convert to status structure */

/*
 *	lam_rfstat
 *
 *	Function:	- get status on a named file
 *	Accepts:	- file name
 *			- ptr to status buffer
 *	Returns:	- 0 or ERROR
 */
int
lam_rfstat(fname, status)

CONST char		*fname;
char			*status;

{
	int4		node;			/* server node ID */
	int4		len;
	uint4		buf[17];
	int		ret;

	fname = _fnparse(fname, &node);
	len = (int4) (strlen(fname) + 1);
	if (len > MAXNMSGLEN) len = MAXNMSGLEN;

	ret = _makefreq(node, FQSTAT, INT4_NIL, fname, len, (char *) buf,
		(int4) sizeof(buf));

	if (ret == 0) {
		conv_stat((struct stat *) status, buf);
	}

	return(ret);
}

/*
 *	lam_rffstat
 *
 *	Function:	- get status on a file descriptor
 *	Accepts:	- file descriptor handle
 *			- ptr to status buffer
 *	Returns:	- 0 or ERROR
 */
int
lam_rffstat(fd, status)

int			fd;
char			*status;

{
	uint4		buf[17];
	int		ret;

	if (_fdvalid(fd)) return(LAMERROR);

	if ((fd <= 2) && (_ufd[fd].fu_node == NOTNODEID)) {
		_ufd[fd].fu_node = getorigin();
	}

	ret = _makefreq(_ufd[fd].fu_node, FQFSTAT, _ufd[fd].fu_tfd,
		(char *) 0, INT4_NIL, (char *) buf, (int4) sizeof(buf));

	if (ret == 0) {
		conv_stat((struct stat *) status, buf);
	}

	return(ret);
}

/*
 *	conv_stat
 *
 *	Function:	- stores an int4 array into a status structure
 *	Accepts:	- ptr to stat structure
 *			- ptr to int4 array
 */
static void
conv_stat(status, buf)

struct stat		*status;
uint4			*buf;

{
	status->st_dev = buf[0];
	status->st_ino = buf[1];
	status->st_mode = buf[2];
	status->st_nlink = buf[3];
	status->st_uid = buf[4];
	status->st_gid = buf[5];
	status->st_size = buf[6];
	status->st_atime = buf[7];
	status->st_mtime = buf[8];
	status->st_ctime = buf[9];
}

/*
 * backwards compatibility
 */
int rfstat(fname, status) CONST char *fname; char *status;
	{ return(lam_rfstat(fname, status)); }
int rffstat(fd, status) int fd; char *status;
	{ return(lam_rffstat(fd, status)); }
