/*
 *	Ohio Trollius
 *
 *	Copyright 1995 The Ohio State University
 *	$Log:	nodespin.c,v $
 * Revision 6.1  96/11/23  19:58:12  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:48:22  gdburns
 * Ohio Release
 * 
 *
 *	Function:	- pretty prints successive node ID messages
 */

#include <stdio.h>

#include <args.h>
#include <portable.h>

/*
 *	nodespin_init
 *
 *	Function:	- prints initial message
 *	Accepts:	- message
 */
void
nodespin_init(msg)

char			*msg;

{
	printf("%s           ", msg);
}

/*
 *	nodespin_next
 *
 *	Function:	- prints next node ID
 *	Accepts:	- node ID
 */
void
nodespin_next(node)

int4			node;

{
	char		buf[16];

	sprintf(buf, "%s...", mnemonic(node));
	printf("%-10.10s", buf);
	fflush(stdout);
}

/*
 *	nodespin_end
 *
 *	Function:	- completes node message
 */
void
nodespin_end()

{
	printf("%-10.10s\n", "done");
}
