/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: lamunix.c,v 6.1 96/11/23 19:58:01 nevin Rel $
 * 
 *	Function:	- We make UNIX portable in here!
 *			- #ifdef'ing the universe is cool!
 */

#include <lam_config.h>
#include <signal.h>

/*
 * global functions
 */
void			(*(_lam_signal()))();
void			_lam_atexit();

/*
 *	_lam_signal
 *
 *	Function:	- signal() wrapper
 */
void (*(
_lam_signal(signum, handler)))()

int			signum;
void			(*handler)();

{
	struct sigaction
			new, old;

	new.sa_handler = handler;
	sigemptyset(&new.sa_mask);
	new.sa_flags = 0;

#if HAVE_SA_RESTART
	new.sa_flags |= SA_RESTART;
#endif

	if (sigaction(signum, &new, &old)) {
		return(SIG_ERR);
	}

	return(old.sa_handler);
}

/*
 *	_lam_atexit
 *
 *	Function:	- wrapper for atexit()
 */
void
_lam_atexit(func)

void			(*func)();

{
#if HAVE_ATEXIT
	atexit(func);
#else
	on_exit((int ((*)())) func, (char *) 0);
#endif
}
