/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB/NJN
 *
 *	$Id: kill.c,v 6.1 96/11/23 19:58:00 nevin Rel $
 *
 *	Function:	- kill file useful routines
 */

#include <pwd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>			/* MAXHOSTNAMELEN in Solaris */
#include <unistd.h>
   
#include <terror.h>
#include <typical.h>

#define KILLDIR		"/tmp/lam-"


/*
 *	killname
 *
 *	Function:	- forms kill filename
 *			- allocates space
 *	Returns:	- kill filename
 */
char *
killname()

{
	char		*f_kill;		/* kill file */
	char		*user;			/* user name */
	struct passwd	*pwdent;		/* user's passwd file entry */
	char		host[MAXHOSTNAMELEN + 1];

	if ((pwdent = getpwuid(getuid())) == 0) {
		return(0);
	}

	user = pwdent->pw_name;

	if (gethostname(host, sizeof(host))) {
		return(0);
	}
/*
 * 2 spaces for '@' and '\0', 16 expansion spaces
 */
	f_kill = malloc((unsigned) (strlen(KILLDIR) + strlen(host) +
			strlen(user) + 2 + 16));

	if (!f_kill) {
		return(0);
	}

	strcpy(f_kill, KILLDIR);
	strcat(f_kill, user);
	strcat(f_kill, "@");
	strcat(f_kill, host);

	return(f_kill);
}

/*
 *	sockname
 *
 *	Function:	- forms process socket filename 
 *	Returns:	- socket filename
 */
char *
sockname()

{
	char		*f_sock;		/* socket filename */

	f_sock = killname();
	if (f_sock == 0) return(0);
		
	strcat(f_sock, "-s");
	return(f_sock);
}

/*
 *	iosockname
 *
 *	Function:	- forms IO daemon server socket filename 
 *	Returns:	- socket filename
 */
char *
iosockname()

{
	char		*f_sock;		/* socket filename */

	f_sock = killname();
	if (f_sock == 0) return(0);
		
	strcat(f_sock, "-sio");
	return(f_sock);
}

/*
 *	lam_mktmpid
 *
 *	Function:	- create temporary file name based on an id
 *			- returns error if insufficient space
 *	Accepts:	- id number to make name unique
 *			- temporary file name (out)
 *			- size of storage for temporary name
 *	Returns:	- 0 or LAMERROR
 */
int
lam_mktmpid(id, name, n)

int			id;
char			*name;
unint			n;

{
	char		*user;			/* user name */
	struct passwd	*pwdent;		/* user's passwd file entry */
	char		idbuf[8];
	char		host[MAXHOSTNAMELEN + 1];

	if ((pwdent = getpwuid(getuid())) == 0) {
		return(LAMERROR);
	}

	user = pwdent->pw_name;

	if (gethostname(host, sizeof(host))) {
		return(LAMERROR);
	}
/*
 * 3 spaces for '@', '-' and '\0', 8 for id.
 */
	if ((strlen(KILLDIR) + strlen(user) + strlen(host) + 3 + 8) > n) {
		LAMSetLastError(LAM_ERR_INVAL);
		return(LAMERROR);
	}

	strcpy(name, KILLDIR);
	strcat(name, user);
	strcat(name, "@");
	strcat(name, host);
	strcat(name, "-");
/*
 * append id
 */
	sprintf(idbuf, "%d", id);
	strncat(name, idbuf, 8);
	
	return(0);
}
