/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/GDB
 *
 *	$Id: app_mgmt.c,v 6.1 96/11/22 13:56:18 nevin Rel $
 *
 *	Function:	- application execution and management
 */

#include <app_mgmt.h>
#include <lam_ksignal.h>
#include <net.h>
#include <preq.h>
#include <typical.h>

/*
 * public functions
 */
int			app_doom();
int			app_sendprocs();

/*
 *	app_sendprocs
 *
 *	Function:	- send GPS array to all processes in the array
 *	Accepts:	- number of processes in GPS array
 *			- GPS array
 *	Returns:	- 0 or LAMERROR
 */
int
app_sendprocs(nprocs, pgps)

int			nprocs;
struct _gps		*pgps;

{
	struct nmsg	nhead;			/* network msg header */
	struct _gps	*p;			/* ptr GPS entry */
	int		i;			/* favourite index */
/*
 * Set up the message.
 */
	nhead.nh_type = 0;
	nhead.nh_flags = DINT4MSG;
	nhead.nh_msg = (char *) pgps;
	nhead.nh_length = nprocs * sizeof(struct _gps);
/*
 * Loop sending to each process.
 */
	for (i = 0, p = pgps; i < nprocs; i++, p++) {
		nhead.nh_node = p->gps_node;
		nhead.nh_event = - p->gps_pid;

		if (nsend(&nhead)) return(LAMERROR);
	}
	
	return(0);
}

/*
 *	app_doom
 *
 *	Function:	- kill running application processes
 *	Accepts:	- GPS array length
 *			- application GPS array
 *	Returns:	- 0 or ERROR
 */
int
app_doom(app_n, app)

int			app_n;
struct _gps *		app;

{
	int		i;

	for (i = 0; i < app_n; i++) {

		if (rpdoom(app[i].gps_node, SELECT_PID, app[i].gps_pid,
				SIGUDIE)) return(LAMERROR);
	}

	return(0);
}
