/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log:	bforward.c,v $
 * Revision 6.1  96/11/23  19:56:13  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:37:11  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.2  96/02/28  18:09:05  gdburns
 * Do not forward certain message flags.
 * 
 * Revision 5.2.1.1  95/11/18  09:44:41  gdburns
 * Use existing bfrecv() in libt.
 * 
 * Revision 5.2  94/08/22  13:55:02  gdburns
 * Ohio Release
 * 
 * Revision 5.1.1.1  94/08/18  11:18:26  gdburns
 * overhaul for new kernel
 * 
 * Revision 5.1  94/05/18  10:44:34  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:32:12  gdburns
 * Ohio Release
 * 
 *	Function:	- bforward, henchman of bufferd
 *			- forwards remote messages for bufferd
 */

#include <events.h>
#include <net.h>

/*
 * local variables
 */
static char		buf[MAXNMSGLEN];
static struct nmsg	nhead;			/* network message */

/*
 * local functions
 */
static void		bwrecv();

/*
 * global functions
 */
void			(*(bw_init()))();
void			(*(bforward()))();

/*
 *	bw_init
 *
 *	Function:	- bforward initialization
 */
void (*(
bw_init()))()

{
/*
 * Receive first request.
 */
	bwrecv();
	return((void (*)()) bforward);
}

/*
 *	bforward
 *
 *	Function:	- server loop
 *			- forwards message & receives next message
 */
void
(*(bforward()))()

{
/*
 * Don't forward the KTRY, DDLI or KTRACE flags.
 */
	nhead.nh_flags &= ~(KTRY | DDLI | KTRACE);

	if (getroute(&nhead)) lampanic("bforward (getroute)");

	if (dsend(&nhead)) lampanic("bforward (dsend)");
/*
 * Receive next message.
 */
	bwrecv();
	return((void (*)()) bforward);
}

/*
 *	bwrecv
 *
 *	Function:	- receives a message from bufferd
 */
static void
bwrecv()

{
	nhead.nh_event = EVBFORWARD;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = MAXNMSGLEN;
	nhead.nh_msg = buf;

	if (bfrecv(&nhead)) lampanic("bforward (bfrecv)");
}
