/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log:	lpattach.c,v $
 * Revision 6.1  96/11/23  19:40:16  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:13:13  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/02/28  17:43:50  gdburns
 * Pass all flags to daemon.
 * 
 * Revision 5.2  94/08/22  13:37:10  gdburns
 * Ohio Release
 * 
 * Revision 5.1.1.1  94/08/18  09:29:08  gdburns
 * Use buffers so as to not confuse ksr() in kenyad.
 * 
 * Revision 5.1  94/05/18  10:37:00  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:02:50  gdburns
 * Ohio Release
 *
 *	Function:	- registers with kenyad
 *	Accepts:	- name of program
 *	Returns:	- 0 or ERROR
 */

#include <string.h>

#include <events.h>
#include <ksignal.h>
#include <kio.h>
#include <net.h>
#include <portable.h>
#include <preq.h>
#include <t_types.h>
#include <typical.h>
#include <terror.h>

/*
 * external variables
 */
extern struct kio_t	_kio;		/* Kernel Input/Output */

/*
 * external functions
 */
extern int4		kpgetpid();

int
lpattach(name)

CONST char		*name;

{
	struct nmsg	nhead;		/* network message */
	struct preq	request;	/* kenya request */
	struct preply	reply;		/* kenya reply */
	int		mask;

	request.pq_src_node = ltot(LOCAL);
	request.pq_src_event = ltot((int4) -kbgetpid());
	request.pq_req = ltot(PQATTACH);
	request.pq_pid = ltot((int4) kbgetpid());
	request.pq_rtf = ltot(_kio.ki_rtf);

	if (name == 0) {
		request.pq_name[0] = '\0';
	} else {
		strncpy(request.pq_name, name, PSMAXNAME);
		request.pq_name[PSMAXNAME - 1] = '\0';
	}

	nhead.nh_node = LOCAL;
	nhead.nh_event = EVKENYAD;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = sizeof(request);
	nhead.nh_msg = (char *) &request;
	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));

	if (nsend(&nhead)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	nhead.nh_event = -kbgetpid();
	nhead.nh_flags = 0;
	nhead.nh_length = sizeof(reply);
	nhead.nh_msg = (char *) &reply;

/*
 *	if (nrecv(&nhead)) {
 *		ksigsetmask(mask);
 *		return(ERROR);
 *	}
 */

	ksigsetmask(mask);

/*
 *	if (reply.pr_reply) {
 *		errno = ttol(reply.pr_reply);
 *		return(ERROR);
 *	} else {
 */
		_kio.ki_rtf |= RTF_KENYA;
		return(0);
/*
 *	}
 */
}
