// $Id: writers.hh,v 1.56 1998/10/09 14:28:32 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../Writer.hh"

// declaration of the various Widgets, each in it's own namespace
// since gcc doesn't understand namespaces, we use structs

// declaration of standard member functions
// static is needed since we don't want a real member function
#define IS_BASIC static bool IsBasic(const Widget &w)
#define INCLUDE static void Include(File &f,const Widget &w)
#define DECLARE static void Declare(File &f,const Widget &w)
#define CONSTRUCT static void Construct(File &f,const Widget &w,bool is_member)
#define CUSTOMIZE static void Customize(File &f,const Widget &w,const string instance)
#define CUSTOMIZE_WIDGET static void Customize(File &f,const Widget &w,const string instance,bool dontshow=false)
#define NEED_CTOR static bool NeedConstruct(const Widget &w,bool is_member)
#define DECLARE_NEED static void DeclareNeeded(File &f,const Widget &w)
#define CONSTRUCT_POINTER static void ConstructPointer(File &f,const Widget &w)
#define DESTRUCT_POINTER static void DestructPointer(File &f,const Widget &w)
#define DERIVE static void Derive(File &f,const Widget &w)
#define IS_SUBWIDGET static WriterType::Subwidget IsSubwidget(const Widget &w,const Widget &ch)
#define SAMPLE_CODE static bool SampleCode(File &f,const Widget &w,enum WriterType::CodePosition pos,const string misc)
#define CALLBACK_ARGS static const string CallbackArgs(const Widget &w,const string signal,string &rettype)

// declare common function sets
#define AmbigClass(Name) \
struct Name \
{  IS_BASIC; \
   INCLUDE; DECLARE; CONSTRUCT; CUSTOMIZE; NEED_CTOR; \
   DERIVE; \
}
#define ParentClass(Name) \
struct Name \
{  CUSTOMIZE; \
}
#define ParentClass_Widget(Name) \
struct Name \
{  CUSTOMIZE_WIDGET; \
   CALLBACK_ARGS; \
}
#define ParentClass_Container(Name) \
struct Name \
{  CUSTOMIZE_WIDGET; \
   INCLUDE; DECLARE_NEED; /* for tooltips */\
}
#define BasicClass(Name) \
struct Name \
{  INCLUDE; DECLARE; CONSTRUCT; CUSTOMIZE; NEED_CTOR; \
}
#define BasicClassSamp(Name) \
struct Name \
{  INCLUDE; DECLARE; CONSTRUCT; CUSTOMIZE; NEED_CTOR; \
   SAMPLE_CODE; \
}
#define BasicClassNeed(Name) \
struct Name \
{  INCLUDE; DECLARE; CONSTRUCT; CUSTOMIZE; NEED_CTOR; \
   DECLARE_NEED; CONSTRUCT_POINTER; DESTRUCT_POINTER; \
}
#define BasicClassNeedSamp(Name) \
struct Name \
{  INCLUDE; DECLARE; CONSTRUCT; CUSTOMIZE; NEED_CTOR; \
   DECLARE_NEED; CONSTRUCT_POINTER; DESTRUCT_POINTER; \
   SAMPLE_CODE; \
}
#define BasicClassSubw(Name) \
struct Name \
{  INCLUDE; DECLARE; CONSTRUCT; CUSTOMIZE; NEED_CTOR; \
   IS_SUBWIDGET; \
}
#define ContainerClass(Name) \
struct Name \
{  INCLUDE; DECLARE; CONSTRUCT; CUSTOMIZE; NEED_CTOR; \
   DERIVE; \
}
#define ContainerClassSamp(Name) \
struct Name \
{  INCLUDE; DECLARE; CONSTRUCT; CUSTOMIZE; NEED_CTOR; \
   DERIVE; \
   SAMPLE_CODE; \
}
#define ContainerClassNeed(Name) \
struct Name \
{  INCLUDE; DECLARE; CONSTRUCT; CUSTOMIZE; NEED_CTOR; \
   DECLARE_NEED; CONSTRUCT_POINTER; DESTRUCT_POINTER; \
   DERIVE; \
}
#define ContainerClassNeedSamp(Name) \
struct Name \
{  INCLUDE; DECLARE; CONSTRUCT; CUSTOMIZE; NEED_CTOR; \
   DECLARE_NEED; CONSTRUCT_POINTER; DESTRUCT_POINTER; \
   DERIVE; \
   SAMPLE_CODE; \
}
#define ContainerClassNeed_Adjustment(Name) \
struct Name \
{  INCLUDE; DECLARE; CONSTRUCT; CUSTOMIZE; NEED_CTOR; \
   DECLARE_NEED; CONSTRUCT_POINTER; DESTRUCT_POINTER; \
   DERIVE; \
   static void Construct_hv(File &f,const Widget &w,bool is_member,char h_or_v='h'); \
   static void ConstructPointer_hv(File &f,const Widget &w,char h_or_v='h'); \
}
#define ContainerClassPack(Name) \
struct Name \
{  INCLUDE; DECLARE; CONSTRUCT; CUSTOMIZE; NEED_CTOR; \
   DERIVE; \
   static void PackChild(File &f,const Widget &w,const string instance); \
}
#define ContainerClassSubw(Name) \
struct Name \
{  INCLUDE; DECLARE; CONSTRUCT; CUSTOMIZE; NEED_CTOR; \
   DERIVE; \
   IS_SUBWIDGET; \
}
#define ContainerClassSubwSamp(Name) \
struct Name \
{  INCLUDE; DECLARE; CONSTRUCT; CUSTOMIZE; NEED_CTOR; \
   DERIVE; \
   IS_SUBWIDGET; \
   SAMPLE_CODE; \
}

//
//
// insert types here !!!
//
//
// sort by: 'sort -t \( -k 2'

BasicClass	(Default);
ContainerClassNeed_Adjustment	(Gtk_Adjustment);
BasicClass	(Gtk_Arrow);
ContainerClassPack	(Gtk_Box);
BasicClass	(Gtk_Button);
ContainerClassSubwSamp	(Gtk_CList);
BasicClass	(Gtk_CheckButton);
BasicClassSamp	(Gtk_Combo);
ParentClass_Container	(Gtk_Container);
ContainerClassSubw	(Gtk_Dialog);
BasicClass	(Gtk_Entry);
ContainerClass	(Gtk_Fixed);
ContainerClass	(Gtk_Frame);
BasicClass	(Gtk_Label);
AmbigClass	(Gtk_Menu);
ContainerClassNeedSamp	(Gtk_MenuBar);
AmbigClass	(Gtk_MenuItem);
ParentClass	(Gtk_Misc);
ContainerClassNeed	(Gtk_Notebook);
BasicClassNeedSamp	(Gtk_OptionMenu);
ContainerClass	(Gtk_Paned);
BasicClassSamp	(Gtk_ProgressBar);
BasicClassNeed	(Gtk_RadioButton);
BasicClassNeed	(Gtk_Range);
BasicClass	(Gtk_Ruler);
BasicClassNeed	(Gtk_Scale);
BasicClassNeed	(Gtk_Scrollbar);
ContainerClass	(Gtk_ScrolledWindow);
BasicClass	(Gtk_Separator);
BasicClassNeed	(Gtk_SpinButton);
BasicClassSamp	(Gtk_Statusbar);
ContainerClass	(Gtk_Table);
BasicClass	(Gtk_Text);
BasicClass	(Gtk_ToggleButton);
ContainerClassSamp	(Gtk_Toolbar);
BasicClassSamp	(Gtk_Tree);
ParentClass_Widget	(Gtk_Widget);
ContainerClassSamp	(Gtk_Window);
BasicClass	(Placeholder);

#include "standard.hh"
