// $Id: radiobutton.cc,v 1.8 1998/09/24 13:19:47 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_RadioButton::Include(File &f,const Widget &w)
{  f.include("gtk--/radiobutton.h");
   f.include(f.FileName(File_SUPPORT_HH),true);
   ((Widget)w).markPointer(); // this is an _ugly_ hack ... but it's the only way ?
}

void Gtk_RadioButton::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_RadioButton");
}

void Gtk_RadioButton::Construct(File &f,const Widget &w,bool is_member)
{  cout << "Error: Gtk_RadioButton::Construct should not be called\n";
}

bool Gtk_RadioButton::NeedConstruct(const Widget &w,bool is_member)
{  return false;
}

void Gtk_RadioButton::DeclareNeeded(File &f,const Widget &w)
{  
}

void Gtk_RadioButton::ConstructPointer(File &f,const Widget &w)
{  const string group(w.getString("group",""));
   f << "\t" << f.InstanceName(w.Name())
     << " = new Gtk_RadioButton(glademm_get_RadioGroup(\"" << group 
     << "\"), \"" << f.CString(w.getString("label")) << "\");\n";
   f << "\tglademm_set_RadioGroup(\"" << group << "\", "
     << f.InstanceName(w.Name()) << "->group());\n";
}

void Gtk_RadioButton::DestructPointer(File &f,const Widget &w)
{  f << "\tdelete " << f.InstanceName(w.Name()) << ";\n";
}

void Gtk_RadioButton::Customize(File &f,const Widget &w,const string instance)
{  Gtk_CheckButton::Customize(f,w,instance);
}
