{
Copyright (C) 1998-99 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

Pascal interface to the getopt functions.

This Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation, version 2.

This Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.
}

unit GetOpt;

interface

const
  EndOfOptions  = #255;
  NoOption      = #1;
  UnknownOption = '?';
  LongOption    = #0;
  OptOptLong    = Ord ('?');

var
  { Index of the first non-option argument after getting all options }
  OptInd : asmname 'optind' Integer;

  { Argument of options with arguments }
  OptArg : asmname 'optarg' CString;

  { Ordinal value of unrecognized option characters. When they are
    found, GetOpt returns UnknownOption. }
  OptOpt : asmname 'optopt' Integer;

  { If this variable is set to a non-zero value, unrecognized options
    cause an error message to stderr. }
  OptErr : asmname 'opterr' Integer;

{
  Parses options and returns the next one. When no more option is found,
  EndOfOptions is returned.

  OptString must be of the form `[+|-]abcd:e:f:g::h::i::'.

  +: stop at first non-option argument
  -: treat non-option arguments as options and return NoOption for them
  Otherwise, permute arguments and handle and options, leaving all
  non-options at the end.

  abc are options without arguments
  def are options with required arguments
  ghi are options with optional arguments

  For more information, see getopt (3).
}
function GetOpt (OptString : CString) : Char; asmname '_p_getopt';

type
  PInteger = ^Integer;

  OptArgType = (NoArgument, RequiredArgument, OptionalArgument);

  OptionType = record
    Name     : CString;
    Argument : OptArgType;
    Flag     : PInteger;   { If nil, V is returned. Otherwise, Flag^ is }
    V        : Integer;    { set to V, and Ord (LongOption) is returned. }
  end;

function GetOptLong (OptString : CString; LongOptions : array of OptionType;
                     PLongIndex : PInteger; LongOnly : Boolean) : Char;

implementation

{$L getoptc.c}

type
  POptionType = ^OptionType;

function P_GetOptLong (OptString : CString; LongOptions : POptionType;
                       LongOptionCount : Integer; PLongIndex : PInteger;
                       LongOnly : Boolean) : Char; asmname '_p_getopt_long';

function GetOptLong (OptString : CString; LongOptions : array of OptionType;
                     PLongIndex : PInteger; LongOnly : Boolean) : Char;
begin
  GetOptLong := P_GetOptLong (OptString, @LongOptions [0],
                              High (LongOptions) - Low (LongOptions) + 1,
                              PLongIndex, LongOnly)
end;

to begin do
  OptErr := 0;

end.
