{
Copyright (C) 1999 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

Demo program for the PExecute unit

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA.
}

program PExecuteDemo;

uses GPC, PExecute;

var
  PID, Status : Integer;
  ProgramName, ErrMsg : TString;
  ArgV : array [0 .. 1] of CString = (nil, nil);

begin
  Writeln ('Enter the name of the program to execute: ');
  Readln (ProgramName);
  ArgV [0] := ProgramName;
  PID := PExecute (ProgramName, PCStrings (@ArgV), ErrMsg, PExecute_One or PExecute_Search or PExecute_Verbose);
  if PID < 0 then
    begin
      Writeln ('Error in PExecute: ', ErrMsg);
      Halt
    end;
  Writeln ('Spawned process #', PID);
  PID := PWait (PID, Status, 0);
  if PID < 0
    then Writeln ('Error in PWait')
    else
      begin
        if WIfSignaled (Status) then
          Writeln ('Process #', PID, ' was terminated by signal ', WTermSig (Status));
        if WIfExited (Status) then
          Writeln ('Process #', PID, ' terminated with status ', WExitStatus (Status))
      end
end.
