'\" t
.\"	aegis - project change supervisor
.\"	Copyright (C) 1992, 1993, 1994, 1995, 1997, 1998 Peter Miller;
.\"	All rights reserved.
.\"
.\"	This program is free software; you can redistribute it and/or modify
.\"	it under the terms of the GNU General Public License as published by
.\"	the Free Software Foundation; either version 2 of the License, or
.\"	(at your option) any later version.
.\"
.\"	This program is distributed in the hope that it will be useful,
.\"	but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"	GNU General Public License for more details.
.\"
.\"	You should have received a copy of the GNU General Public License
.\"	along with this program; if not, write to the Free Software
.\"	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
.\"
.\" MANIFEST: source for BUILDING file
.\"
.if n .ftr CB B
.if n .ftr CI I
.if n .ftr CW R
.if n .ftr C  R
.TH Build Aegis Aegis "Reference Manual"
.if n .hy 0
.if n .ad l
.if n .nr IN 8n
.so version.so
.SH NAME
aegis \- project change supervisor
.XX "" "How to Build the Sources"
.br
.if t .ds C) \(co
.if n .ds C) (C)
Copyright \*(C) \*(Y) Peter Miller;
All rights reserved.
.PP
The
.I aegis
program is distributed under the terms of the
GNU General Public License.
See the LICENSE section, below, for more details.
.PP
.B aegis
(ee.j.iz)
.I n.,
a protection,
a defence.
.SH SPACE REQUIREMENTS
You will need up to 15MB to unpack and build the
.I aegis
program.
(This is the worst case seen so far,
most systems have binaries about 60% as big as this,
10MB is more typical.)
Your mileage may vary.
.SH SITE CONFIGURATION
The
.B aegis
package is configured using the
.I configure
shell script included in this distribution.
.PP
The
.I configure
shell script attempts to guess correct values for
various system-dependent variables used during compilation,
and creates the
.I Makefile
and
.I common/config.h
files.
It also creates a shell script
.I config.status
that you can run in the future to recreate the current configuration.
.SS Before You Start
Before you start configuring,
it is worth reading the \fIOTHER USEFUL SOFTWARE\fP section,
below.
The \fIconfigure\fP script checks for the internationalization library
and functions.
If your system does not have them,
it is worth fetching and installing \fBGNU Gettext\fP before you run the
\fIconfigure\fP script.
Make sure that the \fImsgfmt\fP command from GNU Gettext appears earlier
in your command search PATH than the existing system ones,
if any (this is very important for SunOS and Solaris).
You must do the GNU gettext install \fIbefore\fP running the
\fIconfigure\fP script, or the error messages,
even for English speakers, will be terse and uninformative.
Remember to use the GNU gettext configure \fI--with-gnu-gettext\fP option
if your system has native gettext tools.
.SS Running Configure
Normally,
you just
.I cd
to the directory containing 
.IR aegis "'"
source code and type
.RS
.ft CW
.nf
% \f(CB./configure\fP
\fI\&...lots of output...\fP
%
.fi
.ft R
.RE
If you're using
.I csh
on an old version of System V,
you might need to type
.RS
.ft CW
.nf
% \f(CBsh configure\fP
\fI\&...lots of output...\fP
%
.fi
.ft R
.RE
instead to prevent
.I csh
from trying to execute
.I configure
itself.
.PP
Running
.I configure
takes a minute or two.
While it is running,
it prints some messages that tell what it is doing.
If you don't want to see the messages,
run
.I configure
with its standard output redirected to
.IR /dev/null ;
for example,
.RS
.FT CW
.nf
% \f(CW./configure --quiet\fP
%
.fi
.ft R
.RE
.PP
There is a known problem with GCC 2.8.3 and HP/UX.
You will need to set \f(CWCFLAGS = -O\fP in the generated Makefile.
(The configure script sets it to \f(CWCFLAGS = -O2\fP.)
This is because the code optimization breaks the fingerprints.
If test 32 fails (see below) this is probably the reason.
.PP
By default,
.I configure
will arrange for the
.I "make install"
command to install the
.B aegis
package's files in
.IR /usr/local/bin ,
.IR /usr/local/com/aegis ,
.IR /usr/local/lib/aegis ,
.IR /usr/local/man
and
.IR /usr/local/share/aegis .
There are a number of options which allow you to control the placement
of these files.
.TP 8n
\f[CW]--prefix=\fP\fIPATH\fP
This specifies the path prefix to be used in the installation.
Defaults to \fI/usr/local\fP unless otherwise specified.
.TP 8n
\f[CW]--exec-prefix=\fP\fIPATH\fP
You can specify separate installation prefixes for
architecture-specific files and architecture-independent files.
Defaults to \fI${prefix}\fP unless otherwise specified.
.TP 8n
\f[CW]--bindir=\fP\fIPATH\fP
This directory contains executable programs.  On a network, this
directory may be shared between machines with identical hardware and
operating systems; it may be mounted read-only.  Defaults to
\fI${exec_prefix}/bin\fP unless otherwise specified.
.TP 8n
\f[CW]--datadir=\fP\fIPATH\fP
This directory contains installed data, such as the documentation,
reports and shell scripts distributed with Aegis.  On a network, this
directory may be shared between all machines; it may be mounted
read-only.  Defaults to \fI${prefix}/share/aegis\fP unless otherwise
specified.  An ``aegis'' directory will be appended if there is none in
the specified path.
.TP 8n
\f[CW]--libdir=\fP\fIPATH\fP
This directory contains installed data, such as the error message
catalogues.  On a network, this directory may be shared between machines
with identical hardware and operating systems; it may be mounted
read-only.  Defaults to \fI${exec_prefix}/lib/aegis\fP unless otherwise
specified.  An ``aegis'' directory will be appended if there is none in
the specified path.
.TP 8n
\f[CW]--mandir=\fP\fIPATH\fP
This directory contains the on-line manual entries.
On a network, this directory may be shared between all machines;
it may be mounted read-only.
Defaults to \fI${prefix}/man\fP unless otherwise specified.
.TP 8n
\f[CW]--sharedstatedir=\fP\fIPATH\fP
This directory contains share state information, such as the Aegis lock
file, and information on the location of the various Aegis projects.  On
a network, this directory may be shared between all machines;
.if t it \fBmust\fP be mounted \fBread-write\fP.
.if n it MUST be mounted READ-WRITE.
Defaults to \fI${prefix}/com/aegis\fP unless otherwise specified.
An ``aegis'' directory will be appended if there is none in the specified path.
.PP
.I configure
ignores any other arguments that you give it.
.PP
On systems that require unusual options for compilation or linking
that the
.I aegis
package's
.I configure
script does not know about,
you can give
.I configure
initial values for variables by setting them in the environment.
In Bourne-compatible shells,
you can do that on the command line like this:
.RS
.ft CW
.nf
$ \f(CBCC='gcc -traditional' LIBS=-lposix ./configure\fP
\fI\&...lots of output...\fP
$
.fi
.ft R
.RE
Here are the
.I make
variables that you might want to override with
environment variables when running
.IR configure .
.TP 8n
Variable: CC
C compiler program.
The default is
.IR cc .
.TP 8n
Variable: INSTALL
Program to use to install files.
The default is
.I install
if you have it,
.I cp
otherwise.
.TP 8n
Variable: LIBS
Libraries to link with,
in the form \f(CW-l\fP\fIfoo\fP \f(CW-l\fP\fIbar\fP.
The
.I configure
script will append to this,
rather than replace it.
.PP
If you need to do unusual things to compile the package,
the author encourages you to figure out how
.I configure
could check whether to do them,
and mail diffs or instructions to the author
so that they can be included in the next release.
.SS PRIVILEGES
There are a number of items in the generated
.I Makefile
and
.I common/config.h
file which affect the way
.I aegis
works.
If they are altered too far,
.I aegis
will not be able to function correctly.
.TP 8n
AEGIS_MIN_UID
.br
This specifies the minimum unprivileged uid on your system.
UIDs less than this may not own projects,
or play any other role in an aegis project.
The default value is 100.
.TP 8n
AEGIS_MIN_GID
.br
This specifies the minimum unprivileged GID on your system.
GIDs less than this may not own projects,
or play any other role in an aegis project.
The default value is 10.
.TP 8n
AEGIS_USER_UID
.br
This is the owner of files used by
.I aegis
to record pointers to your projects.
It is 
.I not
used to own projects (i.e. it must be less than AEGIS_MIN_UID).
If possible, the
.I configure
script tries to work out what value was used previously,
but you must specify the --prefix option correctly for this to work.
Because of operating system inconsistencies,
this is specified numerically so that
.I aegis
will work across NFS.
The default value is 3.
.TP 8n
AEGIS_USER_GID
.br
This is the group of files used by
.I aegis
to record pointers to your projects.
It is 
.I not
used as the group for projects (i.e. it must be less than AEGIS_MIN_GID).
If possible, the
.I configure
script tries to work out what value was used previously,
but you must specify the --prefix option correctly for this to work.
Because of operating system inconsistencies,
this is specified numerically so that
.I aegis
will work across NFS.
The default value is 3.
.TP 8n
DEFAULT_UMASK
.br
When
.I aegis
runs commands for you,
or creates files or directories for you,
it will use the defined project umask.
This is a project attribute,
and may be altered using the
.IR aepa (1)
command.
The DEFAULT_UMASK is the umask initially given to all new projects
created by the
.IR aenpr (1)
command.
The default value of DEFAULT_UMASK is 026.
See the comments in the
.I common/config.h
file for an explanation of the alternatives.
.PP
It is required that
.I aegis
run set-uid-root for all of its functionality to be available.
It is
.if n NOT
.if t .B not
possible to create an "aegis" account and make
.I aegis
run set-uid-aegis.
This is because
.I aegis
does things as various different user IDs,
sometimes as many as 3 in the one command.
This allows
.I aegis
to use UNIX security
rather than inventing its own,
and also allows
.I aegis
to work across NFS.
To be able to do these things,
.I aegis
must be set-uid-root.
Appendix D of the
.I "Aegis User Guide"
explains why
.I aegis
must run set-uid-root;
please read it if you have concerns.
.br
.ne 1i
.SH BUILDING AEGIS
All you should need to do is use the
.RS
.ft CW
.nf
% \f(CBmake\fP
\fI\&...lots of output...\fP
%
.fi
.ft R
.RE
command and wait.
When this finishes you should see a directory called
.I bin
containing three files:
.IR aegis ,
.IR aereport ,
.IR aefind ,
.IR aefp ,
.IR find_sizes
and
.IR fmtgen .
.TP 8n
.B aegis
The
.I aegis
program is a project change supervisor.
.TP 8n
.B aefp
The
.I aefp
program may be used to ``fingerprint'' files.
.TP 8n
aereport
The
.I aereport
program is used to query Aegis' database.
.TP 8n
aefind
The
.I aefind
program is used to find files.
.TP 8n
.B find_sizes
The
.I find_sizes
program is a utility used to build the
.I aegis
package;
it is not intended for general use and should not be installed.
.TP 8n
.B fmtgen
The
.I fmtgen
program is a utility used to build the
.I aegis
package;
it is not intended for general use and should not be installed.
.PP
You can remove the program binaries and object files from the
source directory by using the
.RS
.ft CW
.nf
% \f(CBmake clean\fP
\fI\&...lots of output...\fP
%
.fi
.ft R
.RE
command.
To remove all of the above files, and also remove the
.I Makefile
and
.I common/config.h
and
.I config.status
files, use the
.RS
.ft CW
.nf
% \f(CBmake distclean\fP
\fI\&...lots of output...\fP
%
.fi
.ft R
.RE
command.
.PP
The file
.I aux/configure.in
is used to create
.I configure
by a GNU program called
.IR autoconf .
You only need to know this if you want to regenerate
.I configure
using a newer version of
.IR autoconf .
.br
.ne 1i
.SH OTHER USEFUL SOFTWARE
Before describing how to test
.IR aegis ,
you may need to grab some other free software,
because the tests require it in some cases,
and because it is generally useful in others.
.TP 8n
.B cook
This is a dependency maintenance tool (DMT).
An example of a well-known DMT is
.IR make (1),
however this old faithful is
mostly
not sufficiently capable
to meet the demands placed on it by the
.IR aegis
program, but
.IR cook
certainly is.
The
.I cook
package is written by the same author as
.IR aegis .
The
.I cook
package is necessary if test 11 is to be meaningful.
It is also used in the documentation.
The
.I cook
program may be found at the same archive site as the
.I aegis
program.
The
.I cook
program is available under the terms of the GNU General Public License.
.TP 8n
GNU diff
If the
.IR diff (1)
utility supplied by your flavor of unix does not have the
.B -c
option,
you will need GNU diff to make patch files,
if you want to publish software for FTP or on USENET.
Context differences are also helpful for reviewing changes.
.TP 8n
RCS
This is a source control package,
and is available from any of the GNU archives.
The tests use RCS as the history mechanism,
so it is necessary to have RCS
for most of the tests to pass.
(It is best to compile and install RCS \fIafter\fP GNU diff.  This is
because the RCS configuration hard-codes the pathnames of the GNU diff
utilities it needs into the RCS executables.)
.TP 8n
GNU Gettext
Many systems do not yet supply the \fIgettext\fP(3) function.
Aegis uses this function to internationalize its error messages.
If your system does not have this function,
you should fetch and install GNU Gettext \fIbefore\fP running
the \fIconfigure\fP script.
If you do not, Aegis will still work, but the error messages will
be rather terse, even for English speakers.
(You will be able to tell if your system has the internationalization
library and functions, because the \fIconfigure\fP script will report
finding \f(CW-lintl\fP and \f(CWgettext\fP in its running commentary.)
Please note that the GNU Gettext implementation is likely to be superior
to the one supplied with your system, if any.
Remember to use the GNU gettext configure \fI--with-gnu-gettext\fP option
if your system has native gettext tools.
.TP 8n
GNU Groff
This GNU software replaces the
documentation tools which (sometimes)
come with UNIX.
They produce superior error messages,
and support a wider range of functionality and fonts.
The
.I aegis
User Guide was prepared with groff.
.TP 8n
GNU Groff patch
There is a patch for GNU Groff available,
which gives
.IR groff (1)
and
.IR gsoelim (1)
a \fB\-I\fP\fIpath\fP option.
This adds an include file search path, similar to
.IR cpp (1).
The Makefile assumes this is available.
The patch is at
\f(CWhttp://www.canb.auug.org.au/~millerp/groff-1.10.patch.gz\fP
or its mirrors.
.TP 8n
bison
This GNU software is a replacement for
.IR yacc (1).
Some systems have very sick yaccs,
and 
.I bison
may be necessary if your system include files
disagree strongly with your system's yacc.
The generated
.I Makefile
will use bison if you have it.
.TP 8n
fhist
This software,
available under the terms of the GNU General Public License,
is a set of file history and comparison utilities.
It was originally written by David I. Bell,
and is based on the minimal difference algorithm by Eugene W. Myers.
This copy is enhanced and maintained by the same author as
.IR aegis ,
and may be found at the same archive site,
in the same directory.
.PP
The tests also depend on the presence of a number of common UNIX programs,
including but not limited to:
.IR cc ,
.IR cmp ,
.IR diff ,
.BR ed ,
.IR find ,
.IR make ,
the \fIRCS\fP package,
etc.
Depending on your version of UNIX,
some or all of these programs may be in optional packages.
(This is especially true of Linux.)
You need to ensure that these programs are correctly installed
before you run the tests.
.br
.ne 1i
.SH TESTING AEGIS
The
.I Aegis
program comes with a test suite.
To run this test suite, use the command
.RS
.ft CW
.nf
% \f(CBmake sure\fP
\fI\&...lots of output...\fP
Passed All Tests
%
.fi
.ft R
.RE
.PP
The tests take a minute or two each,
with a few very fast,
and a couple very slow,
but it varies greatly depending on your CPU.
.SS Known Problems
The tests assume that the RCS commands "ci", "co", "rlog" and "rcs" are
somewhere in the command search PATH.
.PP
The
.I test/00/t0011a.sh
file assumes the
.IR cook (1)
command by the author is somewhere in the command search path.
This test reproduces the example used in Chapter 3 of the User Guide.
If the
.IR cook (1)
command is not available,
this test gives a pass result without testing anything.
.PP
If you are using HPUX and GCC, test 32 fails if you use -O2.
You need to edit the Makefile to only optimize at -O,
delete the objects and rebuild.
.PP
If you are using Sun's
.I tmpfs
file system as your
.I /tmp
directory,
the tests will fail.
This is because the
.I tmpfs
file system does not support file locking.
Set the
.I AEGIS_TMP
environment variable to somewhere else
before running the tests.
Something like
.RS
.ft CW
.nf
% \f(CBsetenv AEGIS_TMP /usr/tmp\fP
%
.fi
.ft R
.RE
is usually sufficient if you are using C shell, or
.RS
.ft CW
.nf
$ \f(CBAEGIS_TMP=/usr/tmp\fP
$ \f(CBexport AEGIS_TMP\fP
$
.fi
.ft R
.RE
if you are using Bourne shell.
Remember,
this must be done before running the tests.
.PP
If the tests fail due to errors complaining of "user too privileged"
you will need to adjust the
.I AEGIS_MIN_UID
defined in the
.I common/config.h
file.
Similarly for "group too privileged",
although this is rarer.
This error message will also occur if you run the tests as root:
the tests must be run as a mortal each time.
.br
.ne 1i
.SH TESTING SET-UID-ROOT
If the
.I Aegis
program is not set-uid-root then it runs in "test" mode
which gives you some confidence that
.I Aegis
is working before
being tested again when it is set-uid-root.
Two pass testing like this means that you need not trust your system
to a set-uid-root program which is not known to work.
.PP
You will need to do a little of the install,
to create the directory which will contain
.IR Aegis "'"
lock file.
.RS
.ft CW
.nf
# \f(CBmake install-libdir\fP
mkdir /usr/local/lib/aegis
chown 3 /usr/local/lib/aegis
chgrp 3 /usr/local/lib/aegis
chmod 0755 /usr/local/lib/aegis
mkdir /usr/local/com/aegis
chown 3 /usr/local/com/aegis
chgrp 3 /usr/local/com/aegis
chmod 0755 /usr/local/com/aegis
chown root bin/aegis
chmod 4755 bin/aegis
#
.fi
.ft R
.RE
As you can see,
the previous command also changed
.I Aegis
to be set-uid-root.
Once this has been done,
.I Aegis
should be tested again,
in the same manner as before.
.RS
.nf
.ft CW
% \f(CBmake sure\fP
\fI\&...lots of output...\fP
Passed All Tests
%
.fi
.ft R
.RE
.PP
You should test
.I Aegis
as a mortal in both passes,
rather than as root,
to be sure the set-uid-root functionality is working correctly.
.PP
It is required that
.I Aegis
run set-uid-root for all of its functionality to be available.
It is
.if n NOT
.if t .B not
possible to create an "aegis" account and make
.I Aegis
run set-uid-aegis.
This is because
.I Aegis
does things as various different user IDs,
sometimes as many as 3 in the one command.
This allows
.I Aegis
to use UNIX security
rather than inventing its own,
and also allows
.I Aegis
to work across NFS.
To be able to do these things,
.I Aegis
must be set-uid-root.
Appendix D of the
.I "Aegis User Guide"
explains why
.I Aegis
must run set-uid-root;
please read it if you have concerns.
.br
.ne 1i
.SH INSTALLING AEGIS
As explained in the
.I "SITE CONFIGURATION"
section, above,
the
.I Aegis
package is installed under the
.I /usr/local
tree by default.
Use the \f(CW--prefix=\fP\fIPATH\fP option to
.I configure
if you want some other path.
.PP
All that is required to install the
.I Aegis
package is to use the
.RS
.ft CW
.nf
% \f(CBmake install\fP
\fI\&...lots of output...\fP
%
.fi
.ft R
.RE
command.
Control of the directories used may be found in the first
few lines of the
.I Makefile
file if you want to bypass the
.I configure
script.
.PP
The above procedure assumes that the
.IR soelim (1)
command is somewhere in the command search
.IR PATH .
The
.IR soelim (1)
command is available as part of the
.I "GNU Groff"
package,
mentioned below in the
.I "PRINTED MANUALS"
section.
If you don't have it,
but you do have the
.I cook
package,
then a link from
.I roffpp
to
.I soelim
will also work.
.PP
The above procedure also assumes that the
.I $(prefix)/man/man1
and
.I $(prefix)/man/man5
directories already exist.
If they do not,
you will need to
.I mkdir
them manually.
.br
.ne 1i
.SH USER CONFIGURATION
The
.I aegis
command is assumed to be in a generally accessible place,
otherwise users will need to add the relevant directory to their PATH.
Users should add
.RS
.ft CW
source /usr/local/lib/aegis/cshrc
.ft R
.RE
to the end of their
.I .cshrc
file for the recommended aliases.
.PP
There is also a
.I profile
for users of the Bourne shell
(it assumes you have a version of the Bourne shell which has functions).
Users should add
.RS
.ft CW
\&. /usr/local/lib/aegis/profile
.ft R
.RE
to the end of their
.I .profile
file for the recommended aliases.
(This
.I profile
assumes that users are using a Bourne shell which understands functions.)
.PP
The
.I /usr/local/lib/aegis/state
file contains pointers to "system" projects.
Users may add their own project pointers (to their own projects)
by putting a search path into the
.I AEGIS
environment variable.
The system part is always automatically appended by
.IR Aegis .
The default,
already set by the
.I /usr/local/lib/\%aegis/cshrc
file,
is
.IR $HOME/lib/aegis .
Do not create this directory,
.I Aegis
is finicky and wants to do this itself.
.PP
Where projects reside is completely flexible,
be they system projects or user projects.
They are not kept under the
.I /usr/local/lib/aegis
directory,
this directory only contains pointers.
.br
.ne 1i
.SH PRINTED MANUALS
This distribution contains the sources to
all of the documentation for
.IR Aegis ,
however the simplest way to get the documentation is by anonymous FTP;
PostScript files of the User Guide and Reference Manual are available
from the FTP sites listed in the README file.
.PP
The Reference Manual contains the README and BUILDING files,
as well as all of the section 1 and section 5 manual pages.
The Reference Manual is about 200 pages long.
.PP
The User Guide contains information about how to use Aegis,
including a fully worked example.
The User Guide is about 100 pages long.
.br
.ne 1i
.SH TIME SYNCHRONIZATION
The
.I aegis
program uses time stamps to remember whether various events
have happened and when.
If you are using
.I Aegis
in a networked environment,
typically a server and data-less workstations,
you need to make absolutely sure that all of the machines agree about the time.
.PP
If possible,
use the time daemon.
Otherwise,
use
.IR rdate (8)
via
.IR cron (8)
every hour or less.
.SH GETTING HELP
If you need assistance with
.IR Aegis ,
please do not hesitate to contact the author at
.RS
Peter Miller <millerp@canb.auug.org.au>
.RE
Any and all feedback is welcome.
.PP
When reporting problems,
please include the version number
given by the
.RS
.ft CW
.nf
% \f(CBaegis -version\fP
aegis version \fI\*(V)\fP
\fI\&...\fP
%
.fi
.ft R
.RE
command.
Please run this command to get the exact number,
do not send the text of this example.
.SS Runtime Checking
In the
.I common/main.h
file, there is a define of
.I DEBUG
in comments.
If the comments are removed,
extensive debugging is turned on.
This causes some performance loss,
but performs much run-time checking
and adds the
.B -TRAce
command line option.
.PP
When the
.B -TRAce
command line option is followed by one or more file names,
it turns on execution traces in those source files.
It is usually best to place this on the end of the command line
so that names of the files to be traced are not confused
with other file names or strings on the command line.
.SS Problem Reports
If you send email to the author,
please include the following information:
.TP
1. The type of UNIX
.br
The author will need to know the brand and version of UNIX you are using,
or if it is not UNIX but something else.
The output of "uname -sr" is usually sufficient (but not all systems have it).
.TP
2. The Version Number
.br
In any information you send,
please include the version number
reported in the
.I common/patchlevel.h
file,
or \f(CW`aegis -vers`\fP if you can get it to compile.
.TP
3. The Archive Site
.br
When and where you obtained this version of
.IR Aegis .
If you tell me nothing else,
tell me this (and, hopefully, why you did nothing else).
.TP
4. Unpacking
.br
Did you have problems unpacking
.IR Aegis ?
This probably isn't a problem with the .tar.Z distribution,
but you could have obtained a shar format copy.
.TP
5. Building
.br
Did you have problems building
.IR Aegis ?
This could have been the instructions included,
it could have been the configure script,
it could have been the Makefile,
or anything else.
.TP
6. Testing, Non-Set-Uid
.br
Did you have problems with the tests?
You could have had problems running them,
or some of them could have failed.
If some tests fail but not others,
please let me know
.I which
ones failed,
and include the fact that
.I Aegis
was \fBnot\fP set-uid-root at the time.
The -k option to \fImake\fP can be useful if some tests fail but not others.
.TP
7. Testing, Set-Uid-Root
.br
Did you have problems with the tests when
.I Aegis
was set-uid-root?
You could have had problems running them,
or some of them could have failed.
If some tests fail but not others,
please let me know
.I which
ones failed,
and include the fact that
.I Aegis
was set-uid-root at the time.
.TP
8. Installation
.br
Did you have problems installing
.IR Aegis ?
This could have been the instructions,
or anything else.
.PP
At this point it would probably be a very good idea to print out the
manual entries and read them carefully.
You will also want to print a copy of the User Guide;
if you don't gave groff,
there should be a PostScript copy at the archive site.
It is a known flaw that the User Guide is incomplete,
it is something the author is working on "at this moment".
.TP
9. The Example Project
.br
After reading the User Guide,
it is often useful to manually run through the example in chapter 3.
You will need to do more than one change, hopefully several;
the first change is not representative of the system.
Did you manually do the example?
Did you find flaws in the User Guide or manual entries?
.TP
10. Using Aegis
.br
Did you have problems using
.IR Aegis ?
This is a whole can of worms.
If possible,
include a shell script similar to the tests which accompany
.IR Aegis ,
which reproduces the bug.
Exit code 1 on failure (bug),
exit code 0 on success (for when bug is fixed).
.TP
11. The Source Code
.br
Did you read the code?
Did you write some code?
If you read the code and found problems,
fixed them,
or extended
.IR Aegis ,
these contributions are most welcome.
I reserve the right to modify or reject such contributions.
.PP
The above list is inclusive,
not exclusive.
Any and all feedback is greatly appreciated,
as is the effort and interest required to produce it.
.br
.ne 1i
.SH LICENSE
The
.I aegis
program is free software;
you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation;
either version 2 of the License,
or (at your option) any later version.
.PP
The
.I aegis
program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.
.PP
It should be in the
.I LICENSE
file included in this distribution.
.br
.ne 1i
.SH AUTHOR
.TS
tab(;);
l r l.
Peter Miller;E-Mail:;millerp@canb.auug.org.au
\f(CW/\e/\e*\fR;WWW:;http://www.canb.auug.org.au/~millerp/
.TE
