/* $XFree86: xc/programs/Xserver/hw/xfree86/accel/mach64/mach64init.c,v 3.22 1996/10/18 15:00:24 dawes Exp $ */
/*
 * Written by Jake Richter
 * Copyright (c) 1989, 1990 Panacea Inc., Londonderry, NH - All Rights Reserved
 * Copyright 1993,1994,1995,1996 by Kevin E. Martin, Chapel Hill, North Carolina.
 *
 * This code may be freely incorporated in any program without royalty, as
 * long as the copyright notice stays intact.
 *
 * Additions by Kevin E. Martin (martin@cs.unc.edu)
 *
 * KEVIN E. MARTIN AND RICKARD E. FAITH DISCLAIM ALL WARRANTIES WITH REGARD
 * TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL KEVIN E. MARTIN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Modified for the Mach-8 by Rickard E. Faith (faith@cs.unc.edu)
 * Rewritten for the Mach32 by Kevin E. Martin (martin@cs.unc.edu)
 * Rewritten for the Mach64 by Kevin E. Martin (martin@cs.unc.edu)
 *
 */
/* $XConsortium: mach64init.c /main/9 1996/01/28 07:59:08 kaleb $ */

/*
 * Stripped all non-clock related code for SVGATextMode [kmg]
 */

#include "mach64_stm.h"

#include "regmach64.h"

void mach64DACRead4()
{
    (void)inb(ioDAC_REGS);

    (void)inb(ioDAC_REGS+2);
    (void)inb(ioDAC_REGS+2);
    (void)inb(ioDAC_REGS+2);
    (void)inb(ioDAC_REGS+2);
}

/*
 * mach64StrobeClock --
 *
 */
void mach64StrobeClock()
{
    char tmp;

#ifdef __alpha__
    usleep(26);
#else
    /* Delay for 26 us */
    for (tmp = 0; tmp < 26; tmp++)
	GlennsIODelay();
#endif

    tmp = inb(ioCLOCK_CNTL);
    outb(ioCLOCK_CNTL, tmp | CLOCK_STROBE);
}

/*
 * mach64ICS2595_1bit --
 *
 */
void mach64ICS2595_1bit(data)
    char data;
{
    char tmp;

    tmp = inb(ioCLOCK_CNTL);
    outb(ioCLOCK_CNTL, (tmp & ~0x04) | (data << 2));

    tmp = inb(ioCLOCK_CNTL);
    outb(ioCLOCK_CNTL, (tmp & ~0x08) | (0 << 3));

    mach64StrobeClock();

    tmp = inb(ioCLOCK_CNTL);
    outb(ioCLOCK_CNTL, (tmp & ~0x08) | (1 << 3));

    mach64StrobeClock();
}

/*
 * mach64ProgramICS2595 --
 *
 */
void mach64ProgramICS2595(clkCntl, MHz100)
    int clkCntl;
    int MHz100;
{
    char old_clock_cntl;
    char old_crtc_ext_disp;
    unsigned int program_word;
    unsigned int divider;
    int i;

#define MAX_FREQ_2595 15938
#define ABS_MIN_FREQ_2595 1000
#define MIN_FREQ_2595 8000
#define N_ADJ_2595 257
#define REF_DIV_2595 46
#define REF_FREQ_2595 1432
#define STOP_BITS_2595 0x1800

    old_clock_cntl = inb(ioCLOCK_CNTL);
    outb(ioCLOCK_CNTL, 0);

    old_crtc_ext_disp = inb(ioCRTC_GEN_CNTL+3);
    outb(ioCRTC_GEN_CNTL+3, old_crtc_ext_disp | (CRTC_EXT_DISP_EN >> 24));

    usleep(15000); /* delay for 15 ms */

    /* Calculate the programming word */
    program_word = -1;
    divider = 1;

    if (MHz100 > MAX_FREQ_2595)
	MHz100 = MAX_FREQ_2595;
    else if (MHz100 < ABS_MIN_FREQ_2595)
	program_word = 0;
    else
	while (MHz100 < MIN_FREQ_2595) {
	    MHz100 *= 2;
	    divider *= 2;
	}

    MHz100 *= 1000;
    MHz100 = (REF_DIV_2595*MHz100)/REF_FREQ_2595;

    MHz100 += 500;
    MHz100 /= 1000;

    if (program_word == -1) {
	program_word = MHz100 - N_ADJ_2595;
	switch (divider) {
	case 1:
	    program_word |= 0x0600;
	    break;
	case 2:
	    program_word |= 0x0400;
	    break;
	case 4:
	    program_word |= 0x0200;
	    break;
	case 8:
	default:
	    break;
	}
    }

    program_word |= STOP_BITS_2595;

    /* Turn off interrupts */
    (void)xf86DisableInterrupts(); 

    /* Program the clock chip */
    outb(ioCLOCK_CNTL, 0);
    mach64StrobeClock();
    outb(ioCLOCK_CNTL, 1);
    mach64StrobeClock();

    mach64ICS2595_1bit(1); /* Send start bits */
    mach64ICS2595_1bit(0);
    mach64ICS2595_1bit(0);

    for (i = 0; i < 5; i++) {
	mach64ICS2595_1bit(clkCntl & 1);
	clkCntl >>= 1;
    }

    for (i = 0; i < 8 + 1 + 2 + 2; i++) {
	mach64ICS2595_1bit(program_word & 1);
	program_word >>= 1;
    }

    /* Enable interrupts */
    (void)xf86EnableInterrupts();

    usleep(1000); /* delay for 1 ms */

    (void)inb(ioDAC_REGS); /* Clear DAC Counter */
    outb(ioCRTC_GEN_CNTL+3, old_crtc_ext_disp);
    outb(ioCLOCK_CNTL, old_clock_cntl | CLOCK_STROBE);
}

/*
 * mach64ProgramClk1703 --
 *
 */
void mach64ProgramClk1703(clkCntl, MHz100)
    int clkCntl;
    int MHz100;
{
    char old_crtc_ext_disp;
    unsigned int program_word;
    unsigned int temp, tempB;
    unsigned short mhz100 = MHz100;
    unsigned short tempA, remainder, preRemainder, divider;

    old_crtc_ext_disp = inb(ioCRTC_GEN_CNTL+3);
    outb(ioCRTC_GEN_CNTL+3, old_crtc_ext_disp | (CRTC_EXT_DISP_EN >> 24));

#define MIN_N_1703		6

    /* Calculate program word */
    if (MHz100 == 0) {
	program_word = 0xe0;
    } else {
	if (mhz100 < mach64MinFreq) mhz100 = mach64MinFreq;
	if (mhz100 > mach64MaxFreq) mhz100 = mach64MaxFreq;

	divider = 0;
	while (mhz100 < (mach64MinFreq << 3)) {
	    mhz100 <<= 1;
	    divider += 0x20;
	}

	temp = (unsigned int)(mhz100);
	temp = (unsigned int)(temp * (MIN_N_1703 + 2));
	temp -= (short)(mach64RefFreq << 1);

	tempA = MIN_N_1703;
	preRemainder = 0xffff;

	do {
	    tempB = temp;
	    remainder = tempB % mach64RefFreq;
	    tempB = tempB / mach64RefFreq;

	    if ((tempB & 0xffff) <= 127 && (remainder <= preRemainder)) {
		preRemainder = remainder;
		divider &= ~0x1f;
		divider |= tempA;
		divider = (divider & 0x00ff) + ((tempB & 0xff) << 8);
	    }

	    temp += mhz100;
	    tempA++;
	} while (tempA <= (MIN_N_1703 << 1));

	program_word = divider;
    }

    /* Program clock */
    mach64DACRead4();

    (void)inb(ioDAC_REGS+2);
    outb(ioDAC_REGS+2, (clkCntl << 1) + 0x20);
    outb(ioDAC_REGS+2, 0);
    outb(ioDAC_REGS+2, (program_word & 0xff00) >> 8);
    outb(ioDAC_REGS+2, (program_word & 0xff));

    (void)inb(ioDAC_REGS); /* Clear DAC Counter */
    outb(ioCRTC_GEN_CNTL+3, old_crtc_ext_disp);
}

/*
 * mach64ProgramClk8398 --
 *
 */
void mach64ProgramClk8398(clkCntl, MHz100)
    int clkCntl;
    int MHz100;
{
    char old_crtc_ext_disp;
    float tempA, tempB, fOut, longMHz100, diff, preDiff;
    unsigned int temp;
    unsigned short program_word;
    unsigned short m, n, k=0, save_m, save_n, twoToKth;
    unsigned short mhz100 = MHz100;

    old_crtc_ext_disp = inb(ioCRTC_GEN_CNTL+3);
    outb(ioCRTC_GEN_CNTL+3, old_crtc_ext_disp | (CRTC_EXT_DISP_EN >> 24));

#define MIN_M		2
#define MAX_M		30
#define MIN_N		35
#define MAX_N		255-8

    /* Calculate program word */
    if (mhz100 == 0) {
	program_word = 0xe0;
    } else {
	if (mhz100 < mach64MinFreq) mhz100 = mach64MinFreq;
	if (mhz100 > mach64MaxFreq) mhz100 = mach64MaxFreq;

	longMHz100 = (float) mhz100/100;

	while (mhz100 < (mach64MinFreq << 3)) {
	    mhz100 <<= 1;
	    k++;
	}

	twoToKth = 1 << k;
	diff = 0.0;
	preDiff = 0xffffffff;

	for (m = MIN_M; m <= MAX_M; m++) {
	    for (n = MIN_N; n <= MAX_N; n++) {
		tempA = 14.31818;
		tempA *= (float)(n+8);
		tempB = (float)twoToKth;
		tempB *= (m+2);
		fOut = tempA/tempB;

		if (longMHz100 > fOut)
		    diff = longMHz100 - fOut;
		else
		    diff = fOut - longMHz100;

		if (diff < preDiff) {
		    save_m = m;
		    save_n = n;
		    preDiff = diff;
		}
	    }
	}

	program_word = (k << 6) + (save_m) + (save_n << 8);
    }

    /* Program clock */
    temp = inb(ioDAC_CNTL);
    outb(ioDAC_CNTL, temp | DAC_EXT_SEL_RS2 | DAC_EXT_SEL_RS3);

    outb(ioDAC_REGS, clkCntl);
    outb(ioDAC_REGS+1, (program_word & 0xff00) >> 8);
    outb(ioDAC_REGS+1, (program_word & 0xff));

    temp = inb(ioDAC_CNTL);
    outb(ioDAC_CNTL, (temp & ~DAC_EXT_SEL_RS2) | DAC_EXT_SEL_RS3);

    (void)inb(ioDAC_REGS); /* Clear DAC Counter */
    outb(ioCRTC_GEN_CNTL+3, old_crtc_ext_disp);
}

/*
 * mach64ProgramClk408 --
 *
 */
void mach64ProgramClk408(clkCntl, MHz100)
    int clkCntl;
    int MHz100;
{
    char old_crtc_ext_disp;
    unsigned char tmpA, tmpB, tmpC;
    unsigned int temp, tempB;
    unsigned short program_word;
    unsigned short remainder, preRemainder;
    unsigned short mhz100 = MHz100;
    short divider = 0, tempA;

    old_crtc_ext_disp = inb(ioCRTC_GEN_CNTL+3);
    outb(ioCRTC_GEN_CNTL+3, old_crtc_ext_disp | (CRTC_EXT_DISP_EN >> 24));

#define MIN_N_408		2

    /* Calculate program word */
    if (mhz100 == 0) {
	program_word = 0xff;
    } else {
	if (mhz100 < mach64MinFreq) mhz100 = mach64MinFreq;
	if (mhz100 > mach64MaxFreq) mhz100 = mach64MaxFreq;

	while (mhz100 < (mach64MinFreq << 3)) {
	    mhz100 <<= 1;
	    divider += 0x40;
	}

	temp = (unsigned int)mhz100;
	temp = (unsigned int)(temp * (MIN_N_408 + 2));
	temp -= ((short)(mach64RefFreq << 1));

	tempA = MIN_N_408;
	preRemainder = 0xffff;

	do {
	    tempB = temp;
	    remainder = tempB % mach64RefFreq;
	    tempB = tempB / mach64RefFreq;
	    if (((tempB & 0xffff) <= 255) && (remainder <= preRemainder)) {
		preRemainder = remainder;
		divider &= ~0x3f;
		divider |= tempA;
		divider = (divider & 0x00ff) + ((tempB & 0xff) << 8);
	    }
	    temp += mhz100;
	    tempA++;
	} while (tempA <= 32);

	program_word = divider;
    }

    /* Program clock */
    mach64DACRead4();
    tmpB = inb(ioDAC_REGS+2) | 1;
    mach64DACRead4();
    outb(ioDAC_REGS+2, tmpB);

    tmpA = tmpB;
    tmpC = tmpA;
    tmpA |= 8;
    tmpB = 1;

    outb(ioDAC_REGS, tmpB);
    outb(ioDAC_REGS+2, tmpA);

    usleep(400); /* delay for 400 us */
    clkCntl = (clkCntl << 2) + 0x40;
    tmpB = clkCntl;
    tmpA = program_word >> 8;

    outb(ioDAC_REGS, tmpB);
    outb(ioDAC_REGS+2, tmpA);

    tmpB = clkCntl+1;
    tmpA = (unsigned char)program_word;

    outb(ioDAC_REGS, tmpB);
    outb(ioDAC_REGS+2, tmpA);

    tmpB = clkCntl+2;
    tmpA = 0x77;

    outb(ioDAC_REGS, tmpB);
    outb(ioDAC_REGS+2, tmpA);

    usleep(400); /* delay for 400 us */
    tmpA = tmpC & (~(1 | 8));
    tmpB = 1;

    outb(ioDAC_REGS, tmpB);
    outb(ioDAC_REGS+2, tmpA);

    (void)inb(ioDAC_REGS); /* Clear DAC Counter */
    outb(ioCRTC_GEN_CNTL+3, old_crtc_ext_disp);
}

/*
 * mach64ProgramClkMach64CT --
 *
 */
void mach64ProgramClkMach64CT(clkCntl, MHz100)
    int clkCntl;
    int MHz100;
{
    char old_crtc_ext_disp;
#ifdef DEBUG
    extern void mach64PrintCTPLL();
#endif
    int M, N, P, R;
    float Q;
    int postDiv;
    int mhz100 = MHz100;
    unsigned char tmp1, tmp2;
    int ext_div = 0;

    old_crtc_ext_disp = inb(ioCRTC_GEN_CNTL+3);
    outb(ioCRTC_GEN_CNTL+3, old_crtc_ext_disp | (CRTC_EXT_DISP_EN >> 24));

    M = mach64RefDivider;
    R = mach64RefFreq;

    if (clkCntl > 3) clkCntl = 3;

    if (mhz100 < mach64MinFreq) mhz100 = mach64MinFreq;
    if (mhz100 > mach64MaxFreq) mhz100 = mach64MaxFreq;

    Q = (mhz100 * M)/(2.0 * R);

    if ((mach64ChipType == MACH64_VT || mach64ChipType == MACH64_GT) &&
	(mach64ChipRev & 0x01)) {
	if (Q > 255) {
	    ErrorF("mach64ProgramClkMach64CT: Warning: Q > 255\n");
	    Q = 255;
	    P = 0;
	    postDiv = 1;
	} else if (Q > 127.5) {
	    P = 0;
	    postDiv = 1;
	} else if (Q > 85) {
	    P = 1;
	    postDiv = 2;
	} else if (Q > 63.75) {
	    P = 0;
	    postDiv = 3;
	    ext_div = 1;
	} else if (Q > 42.5) {
	    P = 2;
	    postDiv = 4;
	} else if (Q > 31.875) {
	    P = 2;
	    postDiv = 6;
	    ext_div = 1;
	} else if (Q > 21.25) {
	    P = 3;
	    postDiv = 8;
	} else if (Q >= 10.6666666667) {
	    P = 3;
	    postDiv = 12;
	    ext_div = 1;
	} else {
	    ErrorF("mach64ProgramClkMach64CT: Warning: Q < 10.66666667\n");
	    P = 3;
	    postDiv = 12;
	    ext_div = 1;
	}
    } else {
	if (Q > 255) {
	    ErrorF("mach64ProgramClkMach64CT: Warning: Q > 255\n");
	    Q = 255;
	    P = 0;
	}
	else if (Q > 127.5)
	    P = 0;
	else if (Q > 63.75)
	    P = 1;
	else if (Q > 31.875)
	    P = 2;
	else if (Q >= 16)
	    P = 3;
	else {
	    ErrorF("mach64ProgramClkMach64CT: Warning: Q < 16\n");
	    P = 3;
	}
	postDiv = 1 << P;
    }
    N = (int)(Q * postDiv + 0.5);

#ifdef DEBUG
    ErrorF("Q = %f N = %d P = %d, postDiv = %d R = %d M = %d\n", Q, N, P, postDiv, R, M);
    ErrorF("New freq: %.2f\n", (double)((2 * R * N)/(M * postDiv)) / 100.0);
#endif

    outb(ioCLOCK_CNTL + 1, PLL_VCLK_CNTL << 2);
    tmp1 = inb(ioCLOCK_CNTL + 2);
    outb(ioCLOCK_CNTL + 1, (PLL_VCLK_CNTL  << 2) | PLL_WR_EN);
    outb(ioCLOCK_CNTL + 2, tmp1 | 0x04);
    outb(ioCLOCK_CNTL + 1, VCLK_POST_DIV << 2);
    tmp2 = inb(ioCLOCK_CNTL + 2);
    outb(ioCLOCK_CNTL + 1, ((VCLK0_FB_DIV + clkCntl) << 2) | PLL_WR_EN);
    outb(ioCLOCK_CNTL + 2, N);
    outb(ioCLOCK_CNTL + 1, (VCLK_POST_DIV << 2) | PLL_WR_EN);
    outb(ioCLOCK_CNTL + 2,
	 (tmp2 & ~(0x03 << (2 * clkCntl))) | (P << (2 * clkCntl)));
    outb(ioCLOCK_CNTL + 1, (PLL_VCLK_CNTL << 2) | PLL_WR_EN);
    outb(ioCLOCK_CNTL + 2, tmp1 & ~0x04);

    if ((mach64ChipType == MACH64_VT || mach64ChipType == MACH64_GT) &&
	(mach64ChipRev & 0x01)) {
	outb(ioCLOCK_CNTL + 1, PLL_XCLK_CNTL << 2);
	tmp1 = inb(ioCLOCK_CNTL + 2);
	outb(ioCLOCK_CNTL + 1, (PLL_XCLK_CNTL << 2) | PLL_WR_EN);
	if (ext_div)
	    outb(ioCLOCK_CNTL + 2, tmp1 | (1 << (clkCntl + 4)));
	else
	    outb(ioCLOCK_CNTL + 2, tmp1 & ~(1 << (clkCntl + 4)));
    }

    usleep(5000);

    (void)inb(ioDAC_REGS); /* Clear DAC Counter */
    outb(ioCRTC_GEN_CNTL+3, old_crtc_ext_disp);

    return;
}

/* 
 * mach64P_RGB514Index --
 * 
 */
void mach64P_RGB514Index(index, data)
    int index;
    int data;
{
    int temp;

    WaitQueue(7);
    temp = inb(ioDAC_CNTL);
    outb(ioDAC_CNTL, (temp & ~DAC_EXT_SEL_RS3) | DAC_EXT_SEL_RS2);

    outb(ioDAC_REGS, index & 0xff);
    outb(ioDAC_REGS+1, index >> 8);
    outb(ioDAC_REGS+2, data & 0xff);

    temp = inb(ioDAC_CNTL);
    outb(ioDAC_CNTL, (temp & ~(DAC_EXT_SEL_RS3 | DAC_EXT_SEL_RS2)));
}

/* 
 * mach64R_RGB514Index --
 * 
 */
unsigned char mach64R_RGB514Index(index)
    int index;
{
    int temp;
    unsigned char retval;

    WaitQueue(7);
    temp = inb(ioDAC_CNTL);
    outb(ioDAC_CNTL, (temp & ~DAC_EXT_SEL_RS3) | DAC_EXT_SEL_RS2);

    outb(ioDAC_REGS, index & 0xff);
    outb(ioDAC_REGS+1, index >> 8);
    retval = inb(ioDAC_REGS+2);

    temp = inb(ioDAC_CNTL);
    outb(ioDAC_CNTL, (temp & ~(DAC_EXT_SEL_RS3 | DAC_EXT_SEL_RS2)));

    return retval;
}

/*
 * mach64ProgramClkRGB514 --
 *
 */
void mach64ProgramClkRGB514(clkCntl, MHz100)
    int clkCntl;
    int MHz100;
{
    char old_crtc_ext_disp;
    unsigned int program_word;
    unsigned short mhz100 = MHz100;
    float target, ref_freq;
    unsigned char m, n, p;
    float actual, save_freq, error, temp = 0xffff;

    old_crtc_ext_disp = inb(ioCRTC_GEN_CNTL+3);
    outb(ioCRTC_GEN_CNTL+3, old_crtc_ext_disp | (CRTC_EXT_DISP_EN >> 24));

#define RGB514_MIN_FREQ 1600
#define RGB514_MAX_FREQ 22000
#define RGB514_MAX_N    0x1f
#define RGB514_MAX_M    0x3f

    /* Calculate program word */
    if (mhz100 < RGB514_MIN_FREQ) mhz100 = RGB514_MIN_FREQ;
    if (mhz100 > RGB514_MAX_FREQ) mhz100 = RGB514_MAX_FREQ;

    target = (float)mhz100 / 100;
    ref_freq = 14.318;

    if (target < 32) p = 0;
    else if (target < 64) p = 1;
    else if (target < 128) p = 2;
    else p = 3;

    for (m = 0; m <= RGB514_MAX_M; m++) {
	for (n = 2; n <= RGB514_MAX_N; n++) {
	    actual = (float)(ref_freq * (m+65)) / (n * (1 << (3-p)));
	    error = target - actual;

	    if (error < 0) error = -error;
	    if (error < temp) {
		save_freq = actual;
		temp = error;
		program_word = ((((m & 0x3f) | ((p & 3) << 6)) << 8) |
				(n & 0x1f));
	    }
	}
    }

    /* Program clock */
    clkCntl = (clkCntl << 1) + 0x20;
    mach64P_RGB514Index(clkCntl, program_word >> 8);

    clkCntl++;
    mach64P_RGB514Index(clkCntl, program_word & 0xff);

    (void)inb(ioDAC_REGS); /* Clear DAC Counter */
    outb(ioCRTC_GEN_CNTL+3, old_crtc_ext_disp);
}

/*
 * mach64ProgramClk --
 *	Program the clock chip for the use with RAMDAC.
 */
void mach64ProgramClk(clkCntl, MHz100)
    int clkCntl;
    int MHz100;
{
    switch (mach64ClockType) {
    case CLK_ATI18818_1:
	mach64ProgramICS2595(clkCntl, MHz100);
	break;
    case CLK_STG1703:
	mach64ProgramClk1703(clkCntl, MHz100);
	break;
    case CLK_CH8398:
	mach64ProgramClk8398(clkCntl, MHz100);
	break;
    case CLK_INTERNAL:
	mach64ProgramClkMach64CT(clkCntl, MHz100);
	break;
    case CLK_ATT20C408:
	mach64ProgramClk408(clkCntl, MHz100);
	break;
    case CLK_IBMRGB514:
	mach64ProgramClkRGB514(clkCntl, MHz100);
	break;
    default:
	ErrorF("mach64ProgramClk: ClockType %d not currently supported.\n",
	       mach64ClockType);
	break;
    }
}

int
mach64GetCTClock(i)
     int i;
{
    int M = mach64RefDivider;
    int R = mach64RefFreq;
    int N, P, postDiv;

    outb(ioCLOCK_CNTL + 1, (VCLK0_FB_DIV + i) << 2);
    N = inb(ioCLOCK_CNTL + 2);
    outb(ioCLOCK_CNTL + 1, VCLK_POST_DIV << 2);
    postDiv = (inb(ioCLOCK_CNTL + 2) >> (2 * i)) & 0x03;
    if ((mach64ChipType == MACH64_VT || mach64ChipType == MACH64_GT) &&
	(mach64ChipRev & 0x01)) {
	outb(ioCLOCK_CNTL + 1, PLL_XCLK_CNTL << 2);
	if ((inb(ioCLOCK_CNTL + 2) >> (4 + i)) & 0x01) {
	    switch (postDiv) {
	    case 0: P = 3;  break;
	    case 1: P = 2;  break; /* Unknown */
	    case 2: P = 6;  break;
	    case 3: P = 12; break;
	    }
	} else {
	    P = 1 << postDiv;
	}
    } else {
	P = 1 << postDiv;
    }
    return (2 * R * N)/(M * P);
}
    

