#!	/bin/sh
# This program builds the nfs-root archive from root.bin.
# (C) Eric Delaunay, 1998
# This is free software under the GNU General Public License.

# Abort on any non-zero return.
set -e
#set -v
set -x

umask 022

. common.sh

export LANG=C

if [ $# != 4 ]; then
	cat 1>&2 << EOF
	Usage: "$0" root.bin debian-version system language

	root.bin: the root.bin disk image.
	debian-version: version of the Debian release.
	system: name of the target system.
	language: language for the release notes
EOF
	exit -1
fi

# Set this to the location of the root.bin disk image.
rootimage=$1

#Set this to the Debian version
debianversion=$2

# Set this to the system
system=$3

# Set this to the language for the release notes.
language=$4

# Set this to the block device for the root image
mnt=/var/tmp/mnt.rootdisk

mkdir -p $mnt

# Set this to the temporary directory needed to create the archive file
rootarchive=/var/tmp/rootarchive.$$

rootsystem=$rootarchive/debian-$arch-root

rm -fr $rootarchive
mkdir $rootarchive

( $ROOTCMD umount $mnt || /bin/true )

# first, uncompress root.bin if needed
if file $rootimage | grep gzip > /dev/null; then
	zcat $rootimage > $rootarchive/root.bin
else
	cp $rootimage $rootarchive/root.bin
fi
$ROOTCMD mount -t ext2 -o loop $rootarchive/root.bin $mnt

# Extract the rootdisk contents
cp -a $mnt $rootarchive
mv $rootarchive/mnt.rootdisk $rootsystem

$ROOTCMD umount $mnt

# add the NFSROOT device for net booting
mknod $rootsystem/dev/root b 0 1

# SECURITY ALERT: when this archive is installed on a server, all devices are
# publicly avalaible to users who can login to it, like all of them under
# /dev.  They are under /tftpboot/debian-$sparc-root/dev or like.  However,
# their permissions are somewhat different.  For example, /dev/tty[pq...]* are
# writable for all :-(
# To avoid potential security hole, all devices are made accessible only by
# root: not a problem for bootstrapping installation, since it runs as root.
chmod -R og-rw $rootsystem/dev

# Archive the debian-$arch-root directory
tar -C $rootarchive -cf - `basename $rootsystem` | gzip -9c > root.tar.gz

# clean up
rm -fr $rootarchive &

ls -l root.tar.gz

exit 0
