#!	/bin/sh
# Boot Disk maker. Bruce Perens, July-September 1995
#                  Enrique Zanardi, January 1998
# This is free software under the GNU General Public License.

# Abort on any non-zero return.
set -e

# Verbose shell execution.
set -x
set -v

# Print a usage message and exit if the argument count is wrong.
if [ $# -ne 5 ]; then
echo "Usage: $0 revision-extension blocks modules-archive modcont-file modconf-debfile" 1>&2
	cat 1>&2 << EOF

	revision-extension: the revision extension of the kernel.
	blocks: the size of the floppy in 1K blocks, use 720, 1200, or 1440
	modules-archive: tgz containing the modules
	modcont-file: text file containing the list of modules in each subdir
		(generated by kernel.sh)
	archive: the directory containing the Debian binary packages.

EOF

	exit -1
fi

floppy=/var/tmp/floppy-image.$$

mnt=/var/tmp/mnt.$$

revext="$1"

blocks=$2

modules=$3

modcont=$4

archive=$5

# Make sure the required files are there.
if [ ! -f $modules ]; then
        echo "Can't find $modules" 1>&2
        exit -1
fi
if [ ! -f $modcont ]; then
        echo "Can't find $modcont" 1>&2
        exit -1
fi
if [ ! -d $archive ]; then
	echo "Can't find $archive" 1>&2
	exit -1
fi


. common.sh

# Try to unmount anything that should not be mounted. Aborted runs of this
# script may have left things mounted.
(umount $mnt; umount $floppy; true)2>/dev/null >/dev/null

mkdir -p $mnt

# Zero the entire disk, so that if I compress the raw disk image,
# unused blocks will compress well.
dd if=/dev/zero of=$floppy bs=1k count=$blocks

# Make the filesystem.
if [ "$arch" = sparc -o "$arch" = powerpc -o "$revext" = bvme -o "$revext" = mvme ]; then
	# sparc, m68k/VME and powerpc use ext2 formatted floppies
	mke2fs -F $floppy $blocks
	# mount the disk
	mount -t ext2 -o loop $floppy $mnt
else
	/sbin/mkdosfs -r 16 -F 12 -n drivers -m scripts/drivers/boot.txt $floppy $blocks
	# mount the disk
	mount -t msdos -o loop -o fat=12 $floppy $mnt
fi

# Temporary directories
E=/var/tmp/extract-tmp-$$

exit=false

# luisgh: Added pcmcia-cs to the packages.
PACKAGE_PATH=`make_paths modconf sed modutils whiptail`
if [ "$arch" = i386 ]; then
	PACKAGE_PATH="$PACKAGE_PATH `make_paths pcmcia-cs`"
fi

if $exit; then
	exit -1
fi

if [ -d $E ]; then
        mv -f $E $E.old
        rm -f -r $E.old &
fi
mkdir -p -m 755 $E

for i in $PACKAGE_PATH; do
        echo Extracting $i 1>&2
        dpkg-deb --extract $i $E
done

# luisgh: Added the pcmcia stuff
if [ "$arch" = "i386" ]; then
# For small floppies remove the pcmcia stuff.
	if [ $blocks -gt 1400 ]; then
		(cd $E && tar -cf pcmcia.tar \
			etc/modutils/pcmcia \
			etc/apm/resume.d/pcmcia \
			etc/apm/suspend.d/pcmcia \
			etc/init.d/pcmcia \
			etc/pcmcia \
			sbin/ifport \
			sbin/ifuser \
			sbin/cardmgr )
		gzip -9f $E/pcmcia.tar
		cp $E/pcmcia.tar.gz $mnt/pcmcia.tgz
	else
		if [ -d $E.pcmcia ]; then
		        mv -f $E.pcmcia $E.pcmcia.old
		        rm -f -r $E.pcmcia.old &
		fi
		mkdir -p -m 755 $E.pcmcia
		tar -C $E.pcmcia -xzf $modules
		rm -f -r $E.pcmcia/lib/modules/*/pcmcia
		tar -C $E.pcmcia -cf $E/modules.tar .
		gzip -9f $E/modules.tar
		modules=$E/modules.tar.gz
		rm -f -r $E.pcmcia &
	fi
fi

# Add a modified update-modules
sed s/__arch__/$arch/ <scripts/drivers/update-modules.in >$E/sbin/update-modules
chmod a+x $E/sbin/update-modules

# Kludge to include additional descriptions that are not in modconf*.deb
# yet.
cp scripts/drivers/descr.additional $E/usr/lib/module_help/descr
zcat $E/usr/lib/module_help/descr.gz >>$E/usr/lib/module_help/descr
gzip -9f $E/usr/lib/module_help/descr
(cd $E && tar -cf modconf.tar \
	bin/sed \
	usr/bin/whiptail \
	sbin/update-modules \
	etc/modutils \
	usr/sbin/modconf \
	usr/lib/module_help )
gzip -9f $E/modconf.tar
cp $E/modconf.tar.gz $mnt/modconf.tgz

cp $modules $mnt/modules.tgz
cp $modcont $mnt/modcont

rm -f -r $E &

cp scripts/drivers/install.sh $mnt/install.sh
chmod 777 $mnt/install.sh
#echo ${revext}"drivers">$mnt/type.txt
echo drivers>$mnt/type.txt

umount $mnt
rmdir $mnt

mv $floppy drv${blocks}${revext}.bin
ls -l drv${blocks}${revext}.bin
exit 0
