#include <deity/selectloop.h>
#include <deity/widgetinit.h>
#include <deity/utils.h>

#include <apt-pkg/init.h>
#include <apt-pkg/error.h>
#include <apt-pkg/sourcelist.h>
#include <apt-pkg/pkgcachegen.h>
#include "extracache.h"
#include "policy.h"

#include <pthread.h>

#include "aptwidgets.h"
#include "progressmeter.h"
#include "errorshow.h"

#include <iostream.h>

// OpenCache - Construct all caches from the source list		/*{{{*/
// ---------------------------------------------------------------------
/* This is ment to run asyncronously so that event processing can continue
   normally. Input is a pointer to a progress meter. */
void *OpenCache(void *Prog)
{
   ProgressMeter *Progress = (ProgressMeter *)Prog;
   
   // Read the source list
   pkgSourceList List;
   if (List.ReadMainList() == false)
      ShowErrors("The list of sources could not be read.",true);   
   
   // Build all of the caches
   pkgMakeStatusCache(List,*Progress);
   if (_error->PendingError() == true)
      ShowErrors("The package lists or status file could not be parsed or opened.",true);

   // Means some warnings were generated by MakeStatusCache.
   Progress->Done();
   ShowErrors("Some of the package information could not be loaded.\n"
	      "This means that you will have an incomplete list of selections.\n"
	      "Use the Update command to fix this.");
      

   // Open our cache and extra data.
   ExtraCacheF *Cache = new ExtraCacheF(*Policy::Cur,*Progress);
   if (_error->PendingError() == true)
      ShowErrors("The cache files could not be read.");
   Progress->Done();
   
   return Cache;
}
									/*}}}*/

int main(int,char **)
{
   SelectLoop Loop;
   Widget *Root = 0;
   
   // Initialize the widget library and bring up the best display
   Root = InitWidgets(Loop);

   if (Root == 0)
   {
      cerr << "Can't find a compatible display system. Supported are: "
           << InitWidgetsSupported() << endl;
      return 100;
   }

   // Initialize the package library
   if (pkgInitialize(*_config) == false)
   {
      _error->DumpErrors();
      return 100;
   }
      
   // Use 'apt 3> file' to see the debug information from clog.
   ReAttachStreams();
//   Base = new MainWindow(Root);

   ProgressMeter *Progress = new ProgressMeter("Generating Cache",Root);

   // Create a detached thread to create the caches.
   pthread_t T;
   pthread_create(&T,0,&OpenCache,Progress);
   pthread_detach(T);
   
   Loop.Loop();
   return 0;
}
