/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: expl_vfsl.cpp,v $
 *
 * $Revision: 1.2 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 *
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif	 // HAVE_CONFIG_H

#include <errno.h>
#include <sys/errno.h>

#include "expl_vfsl.h"
/*---------------------------------------------------------------------------*/
int VFSL_Class::file_type (const char *filename)
{
  int temp_type = NODE_GENERAL;

  if (filename[0] == '.')
    temp_type = NODE_BOGUS;

  if (
      (strstr(filename, ".txt") != NULL) ||
      (strstr(filename, ".TXT") != NULL) ||
      (strstr(filename, "README") != NULL)
     )
    temp_type = NODE_TEXT;

  if (
      (strstr(filename, ".htm") != NULL) ||
      (strstr(filename, ".html") != NULL) ||
      (strstr(filename, ".HTM") != NULL) ||
      (strstr(filename, ".HTML") != NULL)
     )
    temp_type = NODE_HTML;

  // now check for plugin types

  struct plugin_entry *temp_list=pl_ltop;
  while (temp_list!=NULL)
  {
   if (strstr (filename,temp_list->plugin_info->pl_ext)!=NULL)
    temp_type = NODE_PLUGIN;

   temp_list=temp_list->next;
  }

  if (strstr(filename, "tty") != NULL)
    temp_type = NODE_CONSOLE;

  if ((filename[0] == 'f') && (filename[1] == 'd'))	// /dev/fd....
    temp_type = NODE_FLOPPY;

  if ((filename[0] == 'h') && (filename[1] == 'd'))	// /dev/hda...
    temp_type = NODE_DISK;

  if ((filename[0] == 's') && (filename[1] == 'g'))	// /dev/scsi
    temp_type = NODE_DISK;

  if ((filename[0] == 'c') && (filename[1] == 'u') && (filename[2] == 'a'))	// /dev/scsi
    temp_type = NODE_SOCKET;

  if (strstr(filename, ".txt") != NULL)
    temp_type = NODE_TEXT;

  if (strstr(filename, "pty") != NULL)
    temp_type = NODE_SOCKET;

  return (temp_type);
}
/*---------------------------------------------------------------------------*/
void VFSL_Class::assign_plugin_list (struct plugin_entry *new_list)
{
 pl_ltop=new_list;
}
/*---------------------------------------------------------------------------*/
void VFSL_Class::do_connect (FileTreeNode *temp_node)
{
 connect (temp_node,
          SIGNAL (create_directory (char *,unsigned long)),
          this,
          SLOT (create_directory (char *,unsigned long)));

 connect (temp_node,
          SIGNAL (read_directory (FileTreeNode *,char *)),
          this,
          SLOT (read_directory (FileTreeNode *,char *)));

 connect (temp_node,
          SIGNAL (copy_a_file (char *,char *)),
          this,
          SLOT (copy_a_file (char *,char *)));

 connect (temp_node,
          SIGNAL (remove_a_file (char *)),
          this,
          SLOT (remove_a_file (char *)));

 connect (temp_node,
          SIGNAL (remove_a_dir (char *)),
          this,
          SLOT (remove_a_dir (char *)));
}
/*---------------------------------------------------------------------------*/
int VFSL_Class::vfsl_read_fs_dir (FileTreeNode *dir_pointer,
                                  char *current_path)
{
	FileList dirs;

	/* struct stat dir_stat; UNUSED */
	FileTreeNode *temp_node;
	int     nr_dirs = 0;
	int     nr_chars = 0;
	FileEntry *entry;

	// >-------- first search for directories

	if (dirs.Scandir(current_path) != -1)
	{
		// first directories in the left pane
		for (entry = dirs.first(); entry; entry = dirs.next())
		{
			temp_strng[0] = 0;

			if (S_ISDIR(entry->fe_stat.st_mode))
			{
				if (
					   (strcmp(entry->fe_fname, ".") != 0) &&
					   (strcmp(entry->fe_fname, "..") != 0)
						)
				{
					temp_node = new FileTreeNode(dir_pointer,
												 NODE_FILECLOSED,
												 NODE_CHILD,
												 NODE_ISDIR,
												 NULL);
                    do_connect (temp_node);

					temp_strng[0] = 0;
					sprintf(temp_strng, "%s%s/", current_path, (const char *) entry->fe_fname);

					nr_dirs = check_directory(temp_strng);
					if (nr_dirs >= 0)
					{
						if (nr_dirs > 0)
						{
							temp_node->set_file_info(entry->fe_fname,
													 entry->fe_stat.st_mode,
													 entry->fe_stat.st_size,
													 TRUE,
													 TRUE);
						}
						else
						{
							temp_node->set_file_info(entry->fe_fname,
													 entry->fe_stat.st_mode,
													 entry->fe_stat.st_size,
													 FALSE,
													 TRUE);
						}

					}
					else
					{
						temp_node->set_file_info(entry->fe_fname,
												 entry->fe_stat.st_mode,
												 entry->fe_stat.st_size,
												 FALSE,
												 FALSE);
					}
				}
			}
		}

		// >------ and now for the files

		for (entry = dirs.first(); entry; entry = dirs.next())
		{
			temp_strng[0] = 0;
			sprintf(temp_strng, "%s%s", current_path, (const char *) entry->fe_fname);

			if ((!S_ISDIR(entry->fe_stat.st_mode)) && ((entry->fe_stat.st_mode & S_IFMT) & (S_IFREG | S_IFBLK | S_IFCHR | S_IFSOCK | S_IFIFO)))
			{
				// >--------- do some general file type hacking ( more later :) )
				// bugss ?? RvS (off to bed after this session!)
				// MvV Yep 1 bug, links are size 0 now, but were the size of
                // the file/dir they pointed to

				if ((entry->fe_stat.st_mode & S_IFLNK) == S_IFLNK)
				{

					nr_chars = readlink(temp_strng, link_dir, PATH_MAX);
					if (nr_chars != -1)
					{

						temp_strng[0] = 0;
						link_dir[nr_chars] = 0;

						if (link_dir[0] == '/')
						{
							sprintf(temp_strng,
									"%s",
									link_dir);
						}
						else
							sprintf(temp_strng,
									"%s%s",
									current_path,
									link_dir);

						if (lstat(temp_strng, &entry->fe_stat) != -1)
							if (S_ISDIR(entry->fe_stat.st_mode))
							{
								temp_node = new FileTreeNode(dir_pointer,
															 NODE_DIRLINK,
															 NODE_CHILD,
															 NODE_ISDIR,
															 NULL);

                                do_connect (temp_node); 

								temp_node->set_file_info(entry->fe_fname,
                                                         entry->fe_stat.st_mode,
													     0,
														 FALSE,
														 TRUE);
							}
							else
							{
								temp_node = new FileTreeNode(dir_pointer,
															 NODE_LINK,
															 NODE_CHILD,
															 NODE_ISFILE,
															 NULL);

                                do_connect (temp_node);     

								temp_node->set_file_info(entry->fe_fname,
                                                         entry->fe_stat.st_mode,
													     0,
														 FALSE,
														 TRUE);
							}
						else
							perror("lstat:");

					}
					else
					{
						perror("Error reading link:");

						temp_node = new FileTreeNode(dir_pointer,
													 NODE_LINK,
													 NODE_CHILD,
													 NODE_ISFILE,
													 NULL);

                        do_connect (temp_node);

						temp_node->set_file_info(entry->fe_fname,
												 entry->fe_stat.st_mode,
												 0,
												 FALSE,
												 TRUE);
					}
				}
				else
				{

					if ((entry->fe_stat.st_mode & S_IFSOCK) == S_IFSOCK)
					{
						temp_node = new FileTreeNode(dir_pointer,
													 NODE_SOCKET,
													 NODE_CHILD,
													 NODE_ISFILE,
													 NULL);

                        do_connect (temp_node);

						temp_node->set_file_info(entry->fe_fname,
												 entry->fe_stat.st_mode,
												 entry->fe_stat.st_size,
												 FALSE,
												 TRUE);
					}
					else
					{
						temp_node = new FileTreeNode(dir_pointer,
												 file_type(entry->fe_fname),
													 NODE_CHILD,
													 NODE_ISFILE,
													 NULL);

                        do_connect (temp_node);  

						temp_node->set_file_info(entry->fe_fname,
												 entry->fe_stat.st_mode,
												 entry->fe_stat.st_size,
												 FALSE,
												 TRUE);
					}
				}
			}
		}
	}
	else
	{
		printf("Error opening directory file descriptor for dir %s: %s\n",
			   current_path, strerror(errno));
		return (1);
	}
	return (0);
}
/*---------------------------------------------------------------------------*/
int VFSL_Class::vfsl_read_directory (FileTreeNode *dir_pointer,
                                     char *current_path)
{
  if (dir_pointer->get_node_type ()==NODE_PLUGIN)
  {
   // we can now safely throw away the "current_path" because a plugin
   // always works relative.
  }
  else
   vfsl_read_fs_dir (dir_pointer,current_path);
return 0;
}
/*---------------------------------------------------------------------------*/
void VFSL_Class::create_directory (char *temp_dir,unsigned long file_prot)
{
  emit sig_create_directory (temp_dir,file_prot);
}
/*---------------------------------------------------------------------------*/
void VFSL_Class::read_directory (FileTreeNode *temp_node,char *temp_dir)
{
  emit sig_read_directory (temp_node,temp_dir);
}
/*---------------------------------------------------------------------------*/
void VFSL_Class::copy_a_file (char *s1,char *t1)
{
  emit sig_copy_a_file (s1,t1);
}
/*---------------------------------------------------------------------------*/
void VFSL_Class::remove_a_file (char *s1)
{
  emit sig_remove_a_file (s1);
}
/*---------------------------------------------------------------------------*/
void VFSL_Class::remove_a_dir (char *s1)
{
  emit sig_remove_a_dir (s1);
}
/*---------------------------------------------------------------------------*/
int     VFSL_Class::vfsl_stat(const char *a_path, struct stat *st_buf)
{
	return (stat(a_path, st_buf));
}
/*---------------------------------------------------------------------------*/
int     VFSL_Class::vfsl_lstat(const char *a_path, struct stat *st_buf)
{
	return (lstat(a_path, st_buf));
}
/*---------------------------------------------------------------------------*/
/*
 * int VFSL_Class::vfsl_readdir (unsigned int fd,struct dirent *dirp,unsigned int count)
 * {
 * return (readdir (fd,dirp,count));
 * }
 */
/*---------------------------------------------------------------------------*/
DIR    *VFSL_Class::vfsl_opendir(char *a_path)
{
	printf ("opening directory '%s'\n",a_path);
	return (opendir(a_path));
}
/*---------------------------------------------------------------------------*/
int     VFSL_Class::vfsl_closedir(DIR * dir_p)
{
	return (closedir(dir_p));
}
/*---------------------------------------------------------------------------*/
int     VFSL_Class::vfsl_read(int fd, char *buf, size_t size)
{
	return (read(fd, buf, size));
}
/*---------------------------------------------------------------------------*/
int     VFSL_Class::vfsl_write(int fd, char *buf, size_t size)
{
	return (write(fd, buf, size));
}
/*---------------------------------------------------------------------------*/
/*
 * int VFSL_Class::vfsl_chmod ()
 * {
 * return (chmod ());
 * }
 */
/*---------------------------------------------------------------------------*/
/*
 * int VFSL_Class::vfsl_chown ()
 * {
 * return (chown ());
 * }
 */
/*---------------------------------------------------------------------------*/
int     VFSL_Class::vfsl_open(char *a_path, int flags)
{
	return (open(a_path, flags));
}
/*---------------------------------------------------------------------------*/
int     VFSL_Class::vfsl_open(char *a_path, int flags, int, mode_t mode)
{
	return (open(a_path, flags, mode));
}
/*---------------------------------------------------------------------------*/
int     VFSL_Class::vfsl_close(int fd)
{
	return (close(fd));
}
/*---------------------------------------------------------------------------*/
int     VFSL_Class::vfsl_link(char *src, char *dest)
{
	return (link(src, dest));
}
/*---------------------------------------------------------------------------*/
int     VFSL_Class::vfsl_unlink(char *a_path)
{
	return (unlink(a_path));
}
/*---------------------------------------------------------------------------*/
int     VFSL_Class::vfsl_rename(char *old_path, char *new_path)
{
	return (rename(old_path, new_path));
}
/*---------------------------------------------------------------------------*/




