#ifndef __DATA_TREE_H__
#define __DATA_TREE_H__

/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: data_tree.h,v $
 *
 * $Revision: 1.3 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 * $Log: data_tree.h,v $
 * Revision 1.3  1997/06/09 12:59:23  ruben
 * switched rcs commands again I think...
 * compiled with -Wall -Werror, fixed bugs and potential bugs
 * fixed Mister Data bugs
 *
 * Revision 1.2  1997/05/27  09:02:10  ruben
 * reworked include strategy for developers ease
 * also some indent done
 *
 * Revision 1.2  1997/05/27  09:02:10  ruben
 * reworked include strategy for developers ease
 * also some indent done
 *
 * Revision 1.1  1997/03/28 17:48:16  ruben
 * Initial revision
 *
 */

#include <qobject.h>
#include <qwindow.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qframe.h>
#include <qscrbar.h>
#include <qpushbt.h>
#include <qtablevw.h>
#include <qapp.h>

#include <stdlib.h>
#include <stdio.h>
#include <sys/stat.h>

#include "vars.h"

//>------ define node types
#define NODE_CHILD        0
#define NODE_NEXT         1

//>------ size defines
#define NODE_WIDTH       18
#define NODE_OFFSET      22
#define NODE_HEIGHT      18		// total height of icon
#define BUTTON_HEIGHT    16
#define EXP_SIZE          9		// size of the +/- icon
#define CONN_SIZE         8		// length of the connection line

#define X_BORDER          5
#define Y_BORDER          5

#define Y_DISTANCE        5

//>------ defines if the node should display all that lies beneath
#define NODE_CONTRACTED   0
#define NODE_EXPANDED     1

#define ND_PLUS           0
#define ND_MIN            1
#define ND_NUL            2

#define ND_NL1            30
#define ND_NL2            31

//>------ node types

#define NODE_EXPLORER     3
#define NODE_DESKTOP      4

#define NODE_FLOPPY       5
#define NODE_DISK         6
#define NODE_CDROM        7

#define NODE_FILECLOSED   8
#define NODE_FILEOPEN     9

#define NODE_GENERAL     10
#define NODE_BOGUS       11
#define NODE_TEXT        12
#define NODE_HTML        13
#define NODE_LINK        14
#define NODE_LINK_DSBL   15

#define NODE_CONSOLE     16
#define NODE_SOCKET      17
#define NODE_DIRLINK     18

#define ICON_01          19
#define ICON_02          20
#define ICON_03          21
#define ICON_04          22
#define ICON_05          23
#define ICON_06          24
#define ICON_07          25
#define ICON_08          26
#define ICON_09          27
#define ICON_10          28
#define ICON_11          29
#define ICON_12          30

#define NODE_PLUGIN      32

//>------- file types

#define NODE_ISFILE       0
#define NODE_ISDIR        1

//>------- ERROR defines

#define NOERROR           0
#define OPERROR           1
 
extern int x_offset;			// offset caused by last icon placing

extern int y_offset;			// offset caused by last icon placing 

extern int y_off_left;			// offset caused by scrollbar movement

extern int y_off_right;			// offset caused by scrollbar movement

extern int nr_x_direction;
extern int nr_x_temp;

extern char compose_dir[];

extern char operation_busy;

class FileTreeNode : public QObject
{
   Q_OBJECT    

 public:

	FileTreeNode(FileTreeNode *, char, char, char, char *);
	~FileTreeNode (void);

        void    remove_tree (void);
	void    demode(register unsigned, register char *);

	void    show_node_tree         (QPaintEvent *, QWidget *, int, char);
	void    show_node_tree_target  (QPaintEvent *, QWidget *, int);	
	void    show_node_tree_selected(QPaintEvent *, QWidget *, int, char);
	void    show_node_list         (QPaintEvent *, QWidget *, int, char);
	void    show_node_list_target  (QPaintEvent *, QWidget *, int, char);	
	void    show_node_list_selected(QPaintEvent *, QWidget *, int, char);
	void    show_size_list         (QPaintEvent *, QWidget *, int);
	void    show_rights_list       (QPaintEvent *, QWidget *, int);

	void    select_node(char);
	char    node_selected(void);
	char    is_node_expandable(void);

	FileTreeNode *find_expanding_node(QWidget *, int, int);
	FileTreeNode *find_selected_node_tree(int, int);
	void    find_selected_node_tree_m(int, int, int, int);
	FileTreeNode *find_selected_node_list(int, int);
	void    find_selected_node_list_m(int, int, int, int);

	void    deselect_nodes();

	// >---------- atomic functions

	int     get_x();
	int     get_y();
	char   *get_node_name();
	char    get_node_type();
	char    get_file_type();
	char    get_expandable();
	char    has_access(void);
	char    is_expanded();
	char    get_op_target (void);
	void    set_op_target (char);
	void    remove_targets (void);  
	void    set_target(char);
	void    set_child(FileTreeNode *);
	void    set_next(FileTreeNode *);
	void    set_expandable(char);
	void    set_expanded(char);

	void    recalc_tree(void);
	void    recalc_list(void);
	
	unsigned long get_rights (void);

	FileTreeNode *get_target (void);
	FileTreeNode *get_current(void);
	FileTreeNode *get_next(void);
	FileTreeNode *get_tree_top(void);
	FileTreeNode *get_parent(void);

	// >---------- elaborate functions

	void    set_file_info(const char *, unsigned long, off_t, char, char);
	void    set_file_rights (unsigned long); 
	char    compose_directory();
	char    copy_tree_op ();
	char    move_tree_op ();
	char    remove_tree_op ();

	/* 
	 * FileTreeNode *path2node (char *); 
	 * void          node2path (void); 
	 */

  private:

        char    op_target;     // target when used to determen copy/move 
	
	unsigned int node_id;

	char    node_type;			// icon type 

	char    selected;			// true / false

	char    node_status;		// expanded / contracted

	char    is_expandable;		// can the current directory be traversed

	char    target;				// used when trying to expand directories

	int     x_place,
	        y_place;

	FileTreeNode *parent;

	FileTreeNode *last;
	FileTreeNode *next;

	FileTreeNode *tree_top;
	FileTreeNode *tree_node;

	char   *node_name;

	// >----------- Additional vars for file info

        char    file_type;       // see defines

        unsigned long file_prot; // rwx bits

        off_t   file_size;       // in bytes       
        
  signals:
  
        void create_directory (char *,unsigned long);
        void read_directory (FileTreeNode *,char *);        
        void copy_a_file (char *,char *);
        void remove_a_file (char *);        
        void remove_a_dir (char *);
};

extern FileTreeNode *root_node;  // absolute root node of the tree

#endif	 // __DATA_TREE_H__
