/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: data_tree.cpp,v $
 *
 * $Revision: 1.3 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 * $Log: data_tree.cpp,v $
 * Revision 1.3  1997/06/09 12:59:23  ruben
 * switched rcs commands again I think...
 * compiled with -Wall -Werror, fixed bugs and potential bugs
 * fixed Mister Data bugs
 *
// Revision 1.2  1997/05/27  09:10:46  ruben
// some indentstuff and reworked include strategy
//
// Revision 1.2  1997/05/27  09:10:46  ruben
// some indentstuff and reworked include strategy
//
 * Revision 1.1  1997/03/28 17:04:14  ruben
 * Initial revision
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif	 // HAVE_CONFIG_H

#ifdef USE_RCS_ID
static const char rcs_id[] = "$Id: data_tree.cpp,v 1.3 1997/06/09 12:59:23 ruben Exp $";
#endif	 /* USE_RCS_ID */

#include "data_tree.h"

//>--------- let's try to eliminate these :)

int     x_offset = 0;
int     y_offset = 0;
int     y_off_left = 0;
int     y_off_right = 0;

int     dir_offset = 0;

int     nr_x_direction = 0;
int     nr_x_temp = 0;

FileTreeNode *root_node = NULL;
FileTreeNode *dir_cache = NULL;

char    temp_str[PATH_MAX];
char    compose_dir[PATH_MAX];
char    temp_c_dir[PATH_MAX];

unsigned int global_id=0; // this node is a counter which creates a unique
                          // id for a node, this id will be used in later
                          // versions to create a true virtual file system
                          // in which these id's function as inodes.

char operation_busy=FALSE;

/*---------------------------------------------------------------------------*/
FileTreeNode::FileTreeNode(FileTreeNode * new_parent,
			 char new_type,
			 char new_node_type,
			 char new_file_type,
			 char *new_path)
{

    // create the node id
    node_id=global_id;
    global_id++;

    op_target=FALSE;

	node_type = new_type;
	selected = FALSE;			// when creating, no node is selected

	node_status = NODE_CONTRACTED;
	file_type = new_file_type;	// added to the general class for file support 

	node_name = new_path;
	is_expandable = FALSE;
	target = FALSE;
	x_place = 0;
	y_place = 0;

	parent = NULL;
	last = NULL;
	next = NULL;

	if (new_node_type == NODE_NEXT)
	{
		parent = new_parent;
		next = NULL;

		if (parent != NULL)
		{
			last = parent->get_current();
			parent->set_next(this);
		}
	}
	else
	{
		parent = new_parent;
		next = NULL;

		if (parent != NULL)
		{
			last = parent->get_current();
			parent->set_child(this);
		}
	}

	tree_top = NULL;
	tree_node = NULL;

}
/*---------------------------------------------------------------------------*/
FileTreeNode::~FileTreeNode (void)
{
 if (tree_top!=NULL)
  delete tree_top;

 tree_top =NULL;
 tree_node=NULL;

 if (next!=NULL)
  delete next;

 parent=NULL;
 next  =NULL;

}
/*---------------------------------------------------------------------------*/
void FileTreeNode::remove_tree (void)
{
 if (tree_top!=NULL)
  delete tree_top;

 tree_top =NULL;
 tree_node=NULL;
}
/*---------------------------------------------------------------------------*\
|      Decode the mode string from a stat entry into a 9-char string and a    |
|      null. ( this piece of source was taken from the tar sources )          |
\*---------------------------------------------------------------------------*/
void    FileTreeNode::demode(register unsigned mode, register char *string)
{
	register unsigned mask;
	register const char *rwx = "rwxrwxrwx";

	for (mask = 0400; mask != 0; mask >>= 1)
	{
		if (mode & mask)
			*string++ = *rwx++;
		else
		{
			*string++ = '-';
			rwx++;
		}
	}

	if (mode & S_ISUID)
		if (string[-7] == 'x')
			string[-7] = 's';
		else
			string[-7] = 'S';
	if (mode & S_ISGID)
		if (string[-4] == 'x')
			string[-4] = 's';
		else
			string[-4] = 'S';
	if (mode & S_ISVTX)
		if (string[-1] == 'x')
			string[-1] = 't';
		else
			string[-1] = 'T';
	*string = '\0';
}
/*---------------------------------------------------------------------------*/
void    FileTreeNode::set_child(FileTreeNode * new_node)
{
	if (tree_top == NULL)
	{
		tree_top = new_node;
		tree_node = new_node;
	}
	else
	{
		tree_node->next = new_node;
		tree_node = tree_node->next;
	}
}
/*---------------------------------------------------------------------------*/
void FileTreeNode::set_next(FileTreeNode * next_node)
{
	next = next_node;
}
/*---------------------------------------------------------------------------*/
char FileTreeNode::compose_directory()
{
  int     current_len;
  char    found = FALSE;

  current_len = strlen(compose_dir);	// assumes [compose_dir] is valid

  temp_c_dir[0] = 0;

  // >----- add filename to directory
  if (parent == NULL)
  {
   compose_dir[0] = '/';
   compose_dir[1] = 0;
  }
  else
  {
   sprintf (temp_c_dir,
            "%s%s/",
            compose_dir,
            node_name);

   strcpy (compose_dir,
           temp_c_dir);
  }

  if (tree_top != NULL)
   found = tree_top->compose_directory();

  if ((target == FALSE) && (found == FALSE))
   compose_dir[current_len] = 0;

  if (target == TRUE)
   found = TRUE;

  if ((next != NULL) && (found == FALSE))
   found = next->compose_directory();

  return (found);
}
/*---------------------------------------------------------------------------*/
char FileTreeNode::copy_tree_op ()
{
  char return_val;

  int current_t_len;
  int current_s_len;

  current_t_len = strlen (target_directory);
  current_s_len = strlen (source_directory);

  temp_c_dir[0] = 0;


  // create proper directory source names

  if (file_type==NODE_ISDIR)
     sprintf (temp_c_dir,
              "%s%s/",
              source_directory,
              node_name);
  else
     sprintf (temp_c_dir,
              "%s%s",
              source_directory,
              node_name);

  strcpy (source_directory,
          temp_c_dir);

  // create proper directory target names

  if (file_type==NODE_ISDIR)
      sprintf (temp_c_dir,
               "%s%s/",
               target_directory,
               node_name);
  else
      sprintf (temp_c_dir,
               "%s%s",
               target_directory,
               node_name);

  strcpy (target_directory,
          temp_c_dir);

  if (file_type==NODE_ISDIR)
  {
     emit create_directory (target_directory,file_prot);

     if (tree_top==NULL)
      emit read_directory (this,source_directory);   
  }
  else
  {
     //operation_busy=TRUE;
     emit copy_a_file (source_directory,target_directory);
  }
 
  if ((tree_top != NULL) && (has_access ()==TRUE))
   return_val = tree_top->copy_tree_op ();

  // remove the entry we just created from the directory
  target_directory [current_t_len]=0;
  source_directory [current_s_len]=0;

  if (next != NULL)
   return_val = next->copy_tree_op ();

  return (NOERROR);
}
/*---------------------------------------------------------------------------*/
char FileTreeNode::move_tree_op ()
{
  char return_val;

  int current_t_len;
  int current_s_len;

  current_t_len = strlen (target_directory);
  current_s_len = strlen (source_directory);

  temp_c_dir[0] = 0;


  // create proper directory source names

  if (file_type==NODE_ISDIR)
     sprintf (temp_c_dir,
              "%s%s/",
              source_directory,
              node_name);
  else
     sprintf (temp_c_dir,
              "%s%s",
              source_directory,
              node_name);

  strcpy (source_directory,
          temp_c_dir);

  // create proper directory target names

  if (file_type==NODE_ISDIR)
      sprintf (temp_c_dir,
               "%s%s/",
               target_directory,
               node_name);
  else
      sprintf (temp_c_dir,
               "%s%s",
               target_directory,
               node_name);

  strcpy (target_directory,
          temp_c_dir);

  if (file_type==NODE_ISDIR)
  {
     emit create_directory (target_directory,file_prot);
     emit read_directory (this,source_directory);   
  }
  else
  {
     //operation_busy=TRUE;
     emit copy_a_file (source_directory,target_directory);
     emit remove_a_file (source_directory);
  }
 
  if ((tree_top != NULL) && (has_access ()==TRUE))
   return_val = tree_top->move_tree_op ();

  if (file_type==NODE_ISDIR)
    emit remove_a_dir (source_directory);

  // remove the entry we just created from the directory
  target_directory [current_t_len]=0;
  source_directory [current_s_len]=0;

  if (next != NULL)
   return_val = next->move_tree_op ();

  return (NOERROR);
}
/*---------------------------------------------------------------------------*/
char FileTreeNode::remove_tree_op ()
{
  char return_val;

  int current_t_len;
  int current_s_len;

  current_t_len = strlen (target_directory);
  current_s_len = strlen (source_directory);

  temp_c_dir[0] = 0;


  // create proper directory source names

  if (file_type==NODE_ISDIR)
     sprintf (temp_c_dir,
              "%s%s/",
              source_directory,
              node_name);
  else
     sprintf (temp_c_dir,
              "%s%s",
              source_directory,
              node_name);

  strcpy (source_directory,
          temp_c_dir);

  if (file_type==NODE_ISDIR)
     emit read_directory (this,source_directory);   
  else
     emit remove_a_file (source_directory);
 
  if ((tree_top != NULL) && (has_access ()==TRUE))
   return_val = tree_top->remove_tree_op ();

  if (file_type==NODE_ISDIR)
     emit remove_a_dir (source_directory);

  // remove the entry we just created from the directory
  target_directory [current_t_len]=0;
  source_directory [current_s_len]=0;

  if (next != NULL)
   return_val = next->remove_tree_op ();

  return (NOERROR);
}
/*---------------------------------------------------------------------------*/
void    FileTreeNode::set_op_target (char yup)
{
 op_target=yup;
}
/*---------------------------------------------------------------------------*/
FileTreeNode *FileTreeNode::get_target (void)
{
 FileTreeNode *temp_node=NULL;

 if (get_op_target ()==TRUE)
  return (this);
 
 if (tree_top!=NULL)
 {
  temp_node=tree_top->get_target ();
  if (temp_node!=NULL)
    return (temp_node);
 }

 if (next!=NULL)
 {
  temp_node=next->get_target ();
  if (temp_node!=NULL)
    return (temp_node);
 }

 return (NULL);
}
/*---------------------------------------------------------------------------*/
char    FileTreeNode::get_op_target (void)
{
 return (op_target);
}
/*---------------------------------------------------------------------------*/
void    FileTreeNode::remove_targets (void)
{
 op_target=FALSE;
 
 if (tree_top!=NULL)
  tree_top->remove_targets ();

 if (next!=NULL)
  next->remove_targets ();
}
/*---------------------------------------------------------------------------*/
void    FileTreeNode::set_expandable(char new_status)
{
	node_status = new_status;
}
/*---------------------------------------------------------------------------*/
void    FileTreeNode::set_target(char new_target_val)
{
	target = new_target_val;
}
/*---------------------------------------------------------------------------*/
char    FileTreeNode::has_access()
{
	if (node_type == NODE_LINK_DSBL)
		return (FALSE);
	else
		return (TRUE);
}
/*---------------------------------------------------------------------------*/
char    FileTreeNode::is_expanded()
{
	if (node_status == NODE_EXPANDED)
		return (TRUE);
	else
		return (FALSE);
}
/*---------------------------------------------------------------------------*/
void    FileTreeNode::set_expanded(char is_true)
{
	if (is_true == TRUE)
	{
		node_status = NODE_EXPANDED;

		if (node_type == NODE_FILECLOSED)
			node_type = NODE_FILEOPEN;
	}
	else
	{
		node_status = NODE_CONTRACTED;

		if (node_type == NODE_FILEOPEN)
			node_type = NODE_FILECLOSED;
	}
}
/*---------------------------------------------------------------------------*/
char    FileTreeNode::is_node_expandable()
{
	if (is_expandable == TRUE)
		return (TRUE);
	else
		return (FALSE);
}
/*---------------------------------------------------------------------------*/
int     FileTreeNode::get_x(void)
{
	return (x_place);
}
/*---------------------------------------------------------------------------*/
int     FileTreeNode::get_y(void)
{
	return (y_place);
}
/*---------------------------------------------------------------------------*/
char   *FileTreeNode::get_node_name(void)
{
	return (node_name);
}
/*---------------------------------------------------------------------------*/
char    FileTreeNode::get_node_type(void)
{
	return (node_type);
}
/*---------------------------------------------------------------------------*/
char    FileTreeNode::get_file_type(void)
{
	return (file_type);
}
/*---------------------------------------------------------------------------*/
char    FileTreeNode::get_expandable(void)
{
	return (is_expandable);
}
/*---------------------------------------------------------------------------*/
unsigned long FileTreeNode::get_rights (void)
{
 return (file_prot);
}
/*---------------------------------------------------------------------------*/
FileTreeNode *FileTreeNode::get_current(void)
{
	return (tree_node);
}
/*---------------------------------------------------------------------------*/
FileTreeNode *FileTreeNode::get_next(void)
{
	return (next);
}
/*---------------------------------------------------------------------------*/
FileTreeNode *FileTreeNode::get_tree_top(void)
{
	return (tree_top);
}

FileTreeNode *FileTreeNode::get_parent(void)
{
	return (parent);
}

/*---------------------------------------------------------------------------*/
void    FileTreeNode::select_node(char selection)
{
	selected = selection;
}
/*---------------------------------------------------------------------------*/
char    FileTreeNode::node_selected(void)
{
	return (selected);
}
/*---------------------------------------------------------------------------*/
FileTreeNode *FileTreeNode::find_selected_node_tree(int x, int y)
{
	FileTreeNode *temp_node = NULL;

	// >------------------ first check ourselves  
	if (
		   (x > (x_place + (NODE_OFFSET * nr_x_temp) + EXP_SIZE)) &&
		   (x < (x_place + (NODE_OFFSET * nr_x_temp) + EXP_SIZE + CONN_SIZE + NODE_WIDTH + 2 + ((signed int) strlen(node_name) * 8))) &&
		   (y > (y_place + y_off_left)) &&
		   (y < (y_place + y_off_left + NODE_HEIGHT)) &&
		   (file_type == NODE_ISDIR)
			)
		return (this);

	// >------------------ search the tree if we have one and if it is visible
	if ((tree_top != NULL) && (is_expanded() == TRUE))
	{
		nr_x_temp++;
		temp_node = tree_top->find_selected_node_tree(x, y);
		nr_x_temp--;

		if (temp_node != NULL)
			return (temp_node);
	}

	// >------------------ give the torch to the next one
	if (next != NULL)
	{
		temp_node = next->find_selected_node_tree(x, y);

		if (temp_node != NULL)
			return (temp_node);
	}

	// >------------------ nope nothing

	return (NULL);
}
/*---------------------------------------------------------------------------*/
void    FileTreeNode::find_selected_node_tree_m(int x1, int y1,
												int x2, int y2)
{
	/* 
	 * if ( (x1 > (x_place + (NODE_OFFSET * nr_x_temp) + EXP_SIZE)) && (x1 < (x_place + (NODE_OFFSET * nr_x_temp) + EXP_SIZE +
	 * CONN_SIZE + NODE_WIDTH + 2 + ((signed int) strlen(node_name) * 8))) && (y1 > (y_place + y_off_left)) && (y1 < (y_place +
	 * y_off_left + NODE_HEIGHT)) &&  (file_type == NODE_ISDIR) ) */

	// >------------------ first check ourselves    
	if (
		   (
			   (
				   (x_place >= x1) &&
				   (x_place <= x2) &&
				   ((y_place + y_off_right) >= y1) &&
				   ((y_place + y_off_right) <= y2)
			   )
			   ||
			   (
				   (x_place >= x1) &&
				   (x_place <= x2) &&
				   ((y_place + y_off_right + NODE_HEIGHT) >= y1) &&
				   ((y_place + y_off_right + NODE_HEIGHT) <= y2)
			   )
			   ||
			   (
				 ((x_place + (NODE_OFFSET * nr_x_temp) + EXP_SIZE) >= x1) &&
				   ((x_place + (NODE_OFFSET * nr_x_temp) + EXP_SIZE + CONN_SIZE + NODE_WIDTH + 2 + ((signed int) strlen(node_name) * 8)) <= x2) &&
				   ((y_place + y_off_right) >= y1) &&
				   ((y_place + y_off_right) <= y2)
			   )
			   ||
			   (
				 ((x_place + (NODE_OFFSET * nr_x_temp) + EXP_SIZE) >= x1) &&
				   ((x_place + (NODE_OFFSET * nr_x_temp) + EXP_SIZE + CONN_SIZE + NODE_WIDTH + 2 + ((signed int) strlen(node_name) * 8)) <= x2) &&
				   ((y_place + y_off_right + NODE_HEIGHT) >= y1) &&
				   ((y_place + y_off_right + NODE_HEIGHT) <= y2)
			   )
		   )
		   &&
		   (file_type == NODE_ISDIR)
			)
		select_node(TRUE);
	else
		select_node(FALSE);

	// >------------------ search the tree if we have one and if it is visible
	if ((tree_top != NULL) && (is_expanded() == TRUE))
	{
		nr_x_temp++;
		tree_top->find_selected_node_tree_m(x1, y1, x2, y2);
		nr_x_temp--;
	}

	// >------------------ give the torch to the next one
	if (next != NULL)
		next->find_selected_node_tree_m(x1, y1, x2, y2);

	// >------------------ nope nothing
}
/*---------------------------------------------------------------------------*/
FileTreeNode *FileTreeNode::find_selected_node_list(int x, int y)
{

	// >------------------ first check ourselves    
	if (
		   (x > (x_place)) &&
		   (x < (x_place + NODE_WIDTH + 6 + ((signed int) strlen(node_name) * 8))) &&
		   (y > (y_place + y_off_right)) &&
		   (y < (y_place + y_off_right + NODE_HEIGHT))
			)
		return (this);

	// >------------------ give the torch to the next one
	if (next != NULL)
		return (next->find_selected_node_list(x, y));

	// >------------------ nope nothing

	return (NULL);
}
/*---------------------------------------------------------------------------*/
void    FileTreeNode::find_selected_node_list_m(int x1, int y1,
												int x2, int y2)
{

	/* 
	 * (x1 > (x_place)) && (x1 < (x_place + NODE_WIDTH + 6 + ((signed int) strlen(node_name) * 8))) && (y1 > (y_place +
	 * y_off_right)) && (y1 < (y_place + y_off_right + NODE_HEIGHT)) */

	// >------------------ first check ourselves    
	if (
		   (
			   (x_place >= x1) &&
			   (x_place <= x2) &&
			   ((y_place + y_off_right) >= y1) &&
			   ((y_place + y_off_right) <= y2)
		   )
		   ||
		   (
			   (x_place >= x1) &&
			   (x_place <= x2) &&
			   ((y_place + y_off_right + NODE_HEIGHT) >= y1) &&
			   ((y_place + y_off_right + NODE_HEIGHT) <= y2)
		   )
		   ||
		   (
			   ((x_place + NODE_WIDTH + 6 + ((signed int) strlen(node_name) * 8)) >= x1) &&
			   ((x_place + NODE_WIDTH + 6 + ((signed int) strlen(node_name) * 8)) <= x2) &&
			   ((y_place + y_off_right) >= y1) &&
			   ((y_place + y_off_right) <= y2)
		   )
		   ||
		   (
			   ((x_place + NODE_WIDTH + 6 + ((signed int) strlen(node_name) * 8)) >= x1) &&
			   ((x_place + NODE_WIDTH + 6 + ((signed int) strlen(node_name) * 8)) <= x2) &&
			   ((y_place + y_off_right + NODE_HEIGHT) >= y1) &&
			   ((y_place + y_off_right + NODE_HEIGHT) <= y2)
		   )

			)
		select_node(TRUE);
	else
		select_node(FALSE);

	// >------------------ give the torch to the next one
	if (next != NULL)
		next->find_selected_node_list_m(x1, y1, x2, y2);

}
/*---------------------------------------------------------------------------*/
void    FileTreeNode::deselect_nodes(void)
{

	select_node(FALSE);

	if (tree_top != NULL)
		tree_top->deselect_nodes();

	if (next != NULL)
		next->deselect_nodes();

}
/*---------------------------------------------------------------------------*/
void    FileTreeNode::recalc_tree(void)
{
	if (
		   (file_type == NODE_ISDIR) ||
		   (node_type == NODE_DIRLINK)
			)
	{

		y_wide += NODE_HEIGHT;
		x_place = x_offset;
		y_place = y_offset;
		y_offset += NODE_HEIGHT;

		// >---------- let's see if there is a tree
		if ((tree_top != NULL) && (node_status == NODE_EXPANDED))
			tree_top->recalc_tree();

	}

	// finally let's see if there is someone next in line
	if (next != NULL)
		next->recalc_tree();
}
/*---------------------------------------------------------------------------*/
void    FileTreeNode::show_node_tree_selected(QPaintEvent * event,
											  QWidget * canvas,
											  int win_size,
											  char clear)
{
	QPainter paint;
	QPen    paint_pen(QColor  (  0,   0,   0), 0, SolidLine);
	QPen    light_pen(QColor  (255, 255, 255), 0, SolidLine);
	QPen    paint_black(QColor(  0,   0,   0), 0, SolidLine);
//	QBrush  paint_brush(QColor( 80, 110, 124), SolidPattern);
	QBrush  paint_brush (QColor ( 80, 110, 124), SolidPattern);
	QBrush  clear_brush(QColor(255, 255, 255), SolidPattern);

	if (
		   (file_type == NODE_ISDIR) ||
		   (node_type == NODE_DIRLINK) ||
           (node_type == NODE_PLUGIN)
			)
	{
		x_place = x_offset;
		y_place = y_offset;
		y_offset += NODE_HEIGHT;

		if (
			   ((y_place - NODE_HEIGHT + y_off_left) <= win_size) &&
			   ((y_place + NODE_HEIGHT + y_off_left) > 0) &&
			   (selected == TRUE)
				)
		{
			if (node_name != NULL)
			{
				paint.begin(canvas);

				if (clear == TRUE)
				{
					paint.setBrush(clear_brush);
					paint.setPen(light_pen);

					paint.drawRect(x_place + (NODE_OFFSET * nr_x_direction) + EXP_SIZE + CONN_SIZE + NODE_WIDTH + 2,
								   y_place + 1 + y_off_left,
					paint.fontMetrics().boundingRect(node_name).width() + 6,
								   NODE_HEIGHT);

					paint.setPen(paint_black);

					paint.drawText(x_place + (NODE_OFFSET * nr_x_direction) + EXP_SIZE + CONN_SIZE + NODE_WIDTH + 4,
								   y_place + y_off_left + NODE_HEIGHT - 4,
								   node_name, strlen(node_name));
				}
				else
				{
					paint.setBrush(paint_brush);
					paint.setPen(light_pen);

					paint.drawRect(x_place + (NODE_OFFSET * nr_x_direction) + EXP_SIZE + CONN_SIZE + NODE_WIDTH + 2,
								   y_place + 1 + y_off_left,
					paint.fontMetrics().boundingRect(node_name).width() + 6,
								   NODE_HEIGHT);

					paint.setPen(light_pen);
					paint.drawText(x_place + (NODE_OFFSET * nr_x_direction) + EXP_SIZE + CONN_SIZE + NODE_WIDTH + 4,
								   y_place + y_off_left + NODE_HEIGHT - 4,
								   node_name, strlen(node_name));
				}

				paint.end();
			}

		}

		// >---------- let's see if there is a tree
		if ((tree_top != NULL) && (node_status == NODE_EXPANDED))
		{
			nr_x_direction++;
			tree_top->show_node_tree_selected(event, canvas, win_size, clear);
			nr_x_direction--;
		}
	}

	// finally let's see if there is someone next in line
	if (next != NULL)
		next->show_node_tree_selected(event, canvas, win_size, clear);
}
/*---------------------------------------------------------------------------*/
void    FileTreeNode::show_node_tree_target(QPaintEvent * event,
                                            QWidget * canvas,
                                            int win_size)
{
	// UNUSED!!!
	// int     minus;

	QPainter paint;
	QPen    paint_pen   (QColor (  0,   0,   0), 0, SolidLine);
	QPen    light_pen   (QColor (255, 255, 255), 0, SolidLine);
	QPen    paint_dotted(QColor (255, 255, 255), 0, DotLine);
	QPen    paint_black (QColor (  0,   0,   0), 0, SolidLine);
	QBrush  paint_brush (QColor ( 80, 110, 124), SolidPattern);
	QBrush  clear_brush (QColor(255, 255, 255), SolidPattern);

	// UNUSED!
	// FileTreeNode *last_node;

	if (
		   (file_type == NODE_ISDIR) ||
		   (node_type == NODE_DIRLINK) ||
           (node_type == NODE_PLUGIN)
			)
	{

		y_wide += NODE_HEIGHT;
		x_place = x_offset;
		y_place = y_offset;
		y_offset += NODE_HEIGHT;

		if (
			   ((y_place - NODE_HEIGHT + y_off_left) <= win_size) &&
			   ((y_place + NODE_HEIGHT + y_off_left) > 0)
				)
		{

			if (node_name != NULL)
			{
				paint.begin(canvas);

				if (op_target==FALSE)
				{
					paint.setBrush(clear_brush);
					paint.setPen(light_pen);

					paint.drawRect(x_place + (NODE_OFFSET * nr_x_direction) + EXP_SIZE + CONN_SIZE + NODE_WIDTH + 2,
								   y_place + 1 + y_off_left,
					paint.fontMetrics().boundingRect(node_name).width() + 6,
								   NODE_HEIGHT);

					paint.setPen(paint_black);

					paint.drawText(x_place + (NODE_OFFSET * nr_x_direction) + EXP_SIZE + CONN_SIZE + NODE_WIDTH + 4,
								   y_place + y_off_left + NODE_HEIGHT - 4,
								   node_name, strlen(node_name));
				}
				else
				{
					paint.setBrush(paint_brush);
					paint.setPen(light_pen);

					paint.drawRect(x_place + (NODE_OFFSET * nr_x_direction) + EXP_SIZE + CONN_SIZE + NODE_WIDTH + 2,
								   y_place + 1 + y_off_left,
					paint.fontMetrics().boundingRect(node_name).width() + 6,
								   NODE_HEIGHT);

					paint.setPen(light_pen);
					paint.drawText(x_place + (NODE_OFFSET * nr_x_direction) + EXP_SIZE + CONN_SIZE + NODE_WIDTH + 4,
								   y_place + y_off_left + NODE_HEIGHT - 4,
								   node_name, strlen(node_name));
				}

				paint.end();
			}

		}

		// >---------- let's see if there is a tree
		if ((tree_top != NULL) && (node_status == NODE_EXPANDED))
		{
			nr_x_direction++;

			tree_top->show_node_tree_target (event, canvas, win_size);

			nr_x_direction--;
		}
	}

	// finally let's see if there is someone next in line
	if (next != NULL)
		next->show_node_tree_target (event, canvas, win_size);
}
/*---------------------------------------------------------------------------*/
void    FileTreeNode::show_node_tree(QPaintEvent * event,
									 QWidget * canvas,
									 int win_size,
                                     char has_focus)
{
	int     minus;

	QPainter paint;
	QPen    paint_pen   (QColor (  0,   0,   0), 0, SolidLine);
	QPen    light_pen   (QColor (255, 255, 255), 0, SolidLine);
	QPen    paint_dotted(QColor (255, 255, 255), 0, DotLine);
	QBrush  paint_brush (QColor ( 80, 110, 124), SolidPattern);

	// UNUSED!!!
	// FileTreeNode *last_node;

	if (
		   (file_type == NODE_ISDIR) ||
		   (node_type == NODE_DIRLINK) ||
           (node_type == NODE_PLUGIN)
			)
	{

		y_wide += NODE_HEIGHT;
		x_place = x_offset;
		y_place = y_offset;
		y_offset += NODE_HEIGHT;

		paint.begin(canvas);
		paint.setPen(paint_pen);

		if (parent != NULL)
		{

			if (last == NULL)
			{
				paint.drawLine(x_place + 5 + (NODE_OFFSET * nr_x_direction),
							 parent->get_y() + NODE_HEIGHT + 1 + y_off_left,
							   x_place + 5 + (NODE_OFFSET * nr_x_direction),
							   y_place + 3 + y_off_left);
			}
			else
			{
				if (last->get_file_type() != NODE_ISDIR)
				{
					if (dir_cache->get_expandable() == TRUE)
						minus = 5;
					else
						minus = 9;

					paint.drawLine(x_place + 5 + (NODE_OFFSET * nr_x_direction),
					  dir_cache->get_y() + NODE_HEIGHT - minus + y_off_left,
							   x_place + 5 + (NODE_OFFSET * nr_x_direction),
								   y_place + 3 + y_off_left);
				}
				else
				{
					if (last->get_expandable() == TRUE)
						minus = 5;
					else
						minus = 9;

					paint.drawLine(x_place + 5 + (NODE_OFFSET * nr_x_direction),
						   last->get_y() + NODE_HEIGHT - minus + y_off_left,
							   x_place + 5 + (NODE_OFFSET * nr_x_direction),
								   y_place + 3 + y_off_left);
				}
			}
		}

		paint.end();

		if (
			   ((y_place - NODE_HEIGHT + y_off_left) <= win_size) &&
			   ((y_place + NODE_HEIGHT + y_off_left) > 0)
				)
		{

			paint.begin(canvas);
			paint.setPen(paint_pen);

			// >-------- draw connection line
			paint.drawLine(x_place + 9 + (NODE_OFFSET * nr_x_direction),
						   y_place + 8 + y_off_left,
						   x_place + 9 + (NODE_OFFSET * nr_x_direction) + 8,
						   y_place + 8 + y_off_left);
			paint.end();

			// >---------- draw node plus/min bitmap

			if (is_expandable == TRUE)
			{
				if (node_status == NODE_EXPANDED)
				{
					bitBlt(canvas,
						   x_place + 1 + (NODE_OFFSET * nr_x_direction),
						   y_place + 4 + y_off_left,
						   pm[ND_MIN]);
				}
				else
				{
					bitBlt(canvas,
						   x_place + 1 + (NODE_OFFSET * nr_x_direction),
						   y_place + 4 + y_off_left,
						   pm[ND_PLUS]);
				}
			}
			else
			{
				bitBlt(canvas,
					   x_place + 1 + (NODE_OFFSET * nr_x_direction),
					   y_place + 4 + y_off_left,
					   pm[ND_NL2]);
			}

			// >---------- draw node type icon

			bitBlt(canvas,
				   x_place + (NODE_OFFSET * nr_x_direction) + 17,
				   y_place + y_off_left,
				   pm[node_type]);

			// >-----------

			if (node_name != NULL)
			{
				paint.begin(canvas);

				if ((selected==TRUE) && (has_focus==TRUE))
				{
					paint.setPen(paint_dotted);
					paint.setBrush(paint_brush);

					paint.drawRect(x_place + (NODE_OFFSET * nr_x_direction) + EXP_SIZE + CONN_SIZE + NODE_WIDTH + 2,
								   y_place + 1 + y_off_left,
					paint.fontMetrics().boundingRect(node_name).width() + 6,
								   NODE_HEIGHT);
				}

				if ((selected==TRUE)  && (has_focus==TRUE))
					paint.setPen(light_pen);
				else
					paint.setPen(paint_pen);

				paint.drawText(x_place + (NODE_OFFSET * nr_x_direction) + EXP_SIZE + CONN_SIZE + NODE_WIDTH + 4,
							   y_place + y_off_left + NODE_HEIGHT - 4,
							   node_name, strlen(node_name));
				paint.end();
			}

		}

		// >---------- let's see if there is a tree
		if ((tree_top != NULL) && (node_status == NODE_EXPANDED))
		{
			nr_x_direction++;

			tree_top->show_node_tree(event, canvas, win_size, has_focus);

			nr_x_direction--;
		}

		dir_cache = this;

	}

	// finally let's see if there is someone next in line
	if (next != NULL)
		next->show_node_tree(event, canvas, win_size, has_focus);
}
/*---------------------------------------------------------------------------*/
void    FileTreeNode::recalc_list()
{
	x_place = x_offset;
	y_place = y_offset;

	y_offset += NODE_HEIGHT;

	if (next != NULL)
		next->recalc_list();
}
/*---------------------------------------------------------------------------*/
void    FileTreeNode::show_node_list_target(QPaintEvent * event,
                                            QWidget * canvas,
                                            int win_size,
                                            char show_selected)
{
	QPainter paint;
	QPen    paint_pen    (QColor (  0,   0,   0), 0, SolidLine);
//	QPen    paint_pen    (QColor (100, 100, 100), 0, SolidLine);
	QPen    light_pen    (QColor (255, 255, 255), 0, SolidLine);
	QPen    paint_dotted (QColor (255, 255, 255), 0, DotLine);
	QBrush  paint_brush (QColor ( 80, 110, 124), SolidPattern);

	nr_objects++;
	y_wide += NODE_HEIGHT;
	x_place = x_offset;
	y_place = y_offset;

	if (
		   ((y_place - NODE_HEIGHT + y_off_right) <= win_size) &&
		   ((y_place + NODE_HEIGHT + y_off_right) > 0)
			)
	{

		// >------------------------ draw node type icon

		if (node_type == NODE_FILEOPEN)		// no open folders in list view

			bitBlt(canvas,
				   x_place,
				   y_place + y_off_right,
				   pm[NODE_FILECLOSED]);
		else
			bitBlt(canvas,
				   x_place,
				   y_place + y_off_right,
				   pm[node_type]);

		// >------------------------ if we've got a name then draw it 

		if (node_name != NULL)
		{
			paint.begin(canvas);

			paint.setClipRect(0, 0,
							  canvas->width() / 3,
							  canvas->height());

			if ((selected == TRUE) && (show_selected == TRUE))
			{
				paint.setPen(paint_dotted);
				paint.setBrush(paint_brush);

				paint.drawRect(x_place + NODE_WIDTH,
							   y_place + 1 + y_off_right,
			   paint.fontMetrics().boundingRect(node_name).width() + 10,
							   NODE_HEIGHT);
			}

			if ((selected == TRUE) && (show_selected == TRUE))
				paint.setPen(light_pen);
			else
				paint.setPen(paint_pen);

			paint.drawText(x_place + NODE_WIDTH + 4,
						   y_place + (NODE_HEIGHT - 4) + y_off_right,
						   node_name, strlen(node_name));

			paint.setClipRect(0, 0, canvas->width(), canvas->height());

			paint.end();
		}

	}

	y_offset += NODE_HEIGHT;

	// finally let's see if there is someone next in line
	if (next != NULL)
		next->show_node_list_target (event, canvas, win_size, show_selected);
}
/*---------------------------------------------------------------------------*/
void    FileTreeNode::show_node_list(QPaintEvent * event,
									 QWidget * canvas,
									 int win_size,
                                     char has_focus)
{
	QPainter paint;
	QPen    paint_pen    (QColor (  0,   0,   0), 0, SolidLine);
//	QPen    paint_pen    (QColor (100, 100, 100), 0, SolidLine);
	QPen    light_pen    (QColor (255, 255, 255), 0, SolidLine);
	QPen    paint_dotted (QColor (255, 255, 255), 0, DotLine);
	QBrush  paint_brush (QColor ( 80, 110, 124), SolidPattern);

	nr_objects++;
	y_wide += NODE_HEIGHT;
	x_place = x_offset;
	y_place = y_offset;

	if (
		   ((y_place - NODE_HEIGHT + y_off_right) <= win_size) &&
		   ((y_place + NODE_HEIGHT + y_off_right) > 0)
			)
	{

		// >------------------------ draw node type icon

		if (node_type == NODE_FILEOPEN)		// no open folders in list view

			bitBlt(canvas,
				   x_place,
				   y_place + y_off_right,
				   pm[NODE_FILECLOSED]);
		else
			bitBlt(canvas,
				   x_place,
				   y_place + y_off_right,
				   pm[node_type]);

		// >------------------------ if we've got a name then draw it 

		if (node_name != NULL)
		{
			paint.begin(canvas);

			paint.setClipRect(0, 0,
							  canvas->width() / 3,
							  canvas->height());

			if ((selected==TRUE)  && (has_focus==TRUE))
			{
				paint.setPen(paint_dotted);
				paint.setBrush(paint_brush);

				paint.drawRect(x_place + NODE_WIDTH,
							   y_place + 1 + y_off_right,
			   paint.fontMetrics().boundingRect(node_name).width() + 10,
							   NODE_HEIGHT);
			}

			if ((selected==TRUE)  && (has_focus==TRUE))
				paint.setPen(light_pen);
			else
				paint.setPen(paint_pen);

			paint.drawText(x_place + NODE_WIDTH + 4,
						   y_place + (NODE_HEIGHT - 4) + y_off_right,
						   node_name, strlen(node_name));

			paint.setClipRect(0, 0, canvas->width(), canvas->height());

			paint.end();
		}

	}

	y_offset += NODE_HEIGHT;

	// finally let's see if there is someone next in line
	if (next != NULL)
		next->show_node_list(event, canvas, win_size, has_focus);
}
/*---------------------------------------------------------------------------*/
void    FileTreeNode::show_node_list_selected(QPaintEvent * event,
											  QWidget * canvas,
											  int win_size,
											  char clear)
{
	QPainter paint;
//	QPen    paint_pen   (QColor (100, 100, 100), 0, SolidLine);
	QPen    paint_pen   (QColor (  0,   0,   0), 0, SolidLine);
	QPen    light_pen   (QColor (255, 255, 255), 0, SolidLine);
	QPen    paint_black (QColor (  0,   0,   0), 0, SolidLine);
	QBrush  paint_brush (QColor ( 80, 110, 124), SolidPattern);
	QBrush  clear_brush (QColor (255, 255, 255), SolidPattern);

	nr_objects++;
	y_wide += NODE_HEIGHT;
	x_place = x_offset;
	y_place = y_offset;

	if (
		   ((y_place - NODE_HEIGHT + y_off_right) <= win_size) &&
		   ((y_place + NODE_HEIGHT + y_off_right) > 0) &&
		   (selected == TRUE)
			)
	{

		if (node_name != NULL)
		{
			paint.begin(canvas);

			paint.setClipRect(0, 0,
							  canvas->width() / 3,
							  canvas->height());

			if (clear == TRUE)
			{
				paint.setBrush(clear_brush);
				paint.setPen(light_pen);

				paint.drawRect(x_place + NODE_WIDTH,
							   y_place + 1 + y_off_right,
				   paint.fontMetrics().boundingRect(node_name).width() + 10,
							   NODE_HEIGHT);

				paint.setPen(paint_black);

				paint.drawText(x_place + NODE_WIDTH + 4,
							   y_place + (NODE_HEIGHT - 4) + y_off_right,
							   node_name,
							   strlen(node_name));
			}
			else
			{
				paint.setBrush(paint_brush);
				paint.setPen(light_pen);

				paint.drawRect(x_place + NODE_WIDTH,
							   y_place + 1 + y_off_right,
				   paint.fontMetrics().boundingRect(node_name).width() + 10,
							   NODE_HEIGHT);

				paint.drawText(x_place + NODE_WIDTH + 4,
							   y_place + (NODE_HEIGHT - 4) + y_off_right,
							   node_name,
							   strlen(node_name));
			}

			paint.setClipRect(0, 0, canvas->width(), canvas->height());

			paint.end();
		}

	}

	y_offset += NODE_HEIGHT;

	// finally let's see if there is someone next in line
	if (next != NULL)
		next->show_node_list_selected(event, canvas, win_size, clear);
}
/*---------------------------------------------------------------------------*/
void    FileTreeNode::show_size_list(QPaintEvent * event,
									 QWidget * canvas,
									 int win_size)
{
	QPainter paint;
	QPen    paint_pen(QColor (0,0,0), 0, SolidLine);

	if ((file_type == NODE_ISFILE) && (node_type != NODE_LINK))
	{
		total_files++;
		total_size += file_size;
	}

	if (
		   ((y_place - NODE_HEIGHT + y_off_right) <= win_size) &&
		   ((y_place + NODE_HEIGHT + y_off_right) > 0)
			)
	{
		// >--------- 

		if (node_name != NULL)
		{
			y_place = y_offset;

			paint.begin(canvas);
			paint.setPen(paint_pen);

			paint.setClipRect(canvas->width() / 3,
							  0,
							  (canvas->width() / 3) * 2,
							  canvas->height());

			sprintf(temp_str, "%ld", (long) file_size);

			// RvS 97012.1 off_t is a quad_t under NetBSD
			// printing without casting would result only in the
			// MSB's of the 64 bit int to be sprintf-ed (m68k architecture)
			// 
			// This is also a bug in the NetBSD gcc distribution because
			// the next field, st_blksize gives st_size when not casted.

			paint.drawText(x_place + (canvas->width() / 3),
						   y_place + (NODE_HEIGHT - 4) + y_off_right,
						   temp_str, strlen(temp_str));

			paint.setClipRect(0, 0,
							  canvas->width(),
							  canvas->height());

			paint.end();
		}

	}

	y_offset += NODE_HEIGHT;

	// finally let's see if there is someone next in line
	if (next != NULL)
		next->show_size_list(event, canvas, win_size);
}
/*---------------------------------------------------------------------------*/
void    FileTreeNode::show_rights_list(QPaintEvent * event,
									   QWidget * canvas,
									   int win_size)
{
	QPainter paint;
	QPen    paint_pen(QColor(0,0,0), 0, SolidLine);

	if (
		   ((y_place - NODE_HEIGHT + y_off_right) <= win_size) &&
		   ((y_place + NODE_HEIGHT + y_off_right) > 0)
			)
	{

		// >--------- 

		if (node_name != NULL)
		{
			y_place = y_offset;

			paint.begin(canvas);
			paint.setPen(paint_pen);
			paint.setClipRect((canvas->width() / 3) * 2,
							  0,
							  (canvas->width() / 3) * 3,
							  canvas->height());

			demode(file_prot, temp_str);

			paint.drawText(x_place + ((canvas->width() / 3) * 2),
						   y_place + (NODE_HEIGHT) - 4 + y_off_right,
						   temp_str, strlen(temp_str));

			paint.setClipRect(0, 0, canvas->width(), canvas->height());

			paint.end();
		}

	}

	y_offset += NODE_HEIGHT;

	// finally let's see if there is someone next in line
	if (next != NULL)
		next->show_rights_list(event, canvas, win_size);
}
/*---------------------------------------------------------------------------*/
FileTreeNode *FileTreeNode::find_expanding_node(QWidget * widget,
												int x, int y)
{
	FileTreeNode *temp_node = NULL;

	if (
		   (x > (x_place + 1 + (NODE_OFFSET * nr_x_temp))) &&
		   (x < (x_place + 1 + (NODE_OFFSET * nr_x_temp) + 9)) &&
		   (y > (y_place + 3 + y_off_left)) &&
		   (y < (y_place + 3 + y_off_left + 9)) &&
		   (is_node_expandable() == TRUE)
			)
	{
		return (this);
	}

	if ((tree_top != NULL) && (node_status == NODE_EXPANDED))
	{
		nr_x_temp++;

		temp_node = tree_top->find_expanding_node(widget, x, y);
		if (temp_node != NULL)
			return (temp_node);

		nr_x_temp--;
	}

	if (next != NULL)
	{
		temp_node = next->find_expanding_node(widget, x, y);
		if (temp_node != NULL)
			return (temp_node);
	}

	return (temp_node);
}
/*---------------------------------------------------------------------------*/
void FileTreeNode::set_file_rights (unsigned long temp_prot)
{
	file_prot = temp_prot;
}
/*---------------------------------------------------------------------------*/
void    FileTreeNode::set_file_info(const char *temp_name,
									unsigned long temp_prot,
									off_t temp_size,
									char is_exp,
									char access)
{
	is_expandable = is_exp;

	node_name = (char *) new char[strlen(temp_name) + 1];
	strcpy(node_name, temp_name);

	file_prot = temp_prot;
	file_size = temp_size;

	if (access == FALSE)
		node_type = NODE_LINK_DSBL;
}
/*---------------------------------------------------------------------------*/
