/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: eplugin.cpp,v $
 *
 * $Revision: 1.0 $
 * 
 * $Author: martin $ 
 * 
 * $Locker: $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 *
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif	 // HAVE_CONFIG_H

#include "eplugin.h"

char plugin_id     []="example plugin";
char plugin_ver    []="v0.1.0";
char plugin_author []="Martin van Velsen <vvelsen@ronix.ptf.hro.nl>";
char plugin_ext    []=".xpl";

struct local_pl_info
{
 FileTreeNode *node_of_attach;
 
};

struct local_pl_info *plugin_node;

/*---------------------------------------------------------------------------*/
extern "C" void init_plugin (void)
{
 plugin_node=NULL;
}
/*---------------------------------------------------------------------------*/
extern "C" void query_plugin (struct pl_inf *query_info)
{
 // this function gives the plugin manager some info of what it is 
 // capable of

 strcpy (query_info->pl_name,  plugin_id);
 strcpy (query_info->pl_ver,   plugin_ver);
 strcpy (query_info->pl_author,plugin_author);
 strcpy (query_info->pl_ext,   plugin_ext);
}
/*---------------------------------------------------------------------------*/
extern "C" void close_plugin (void)
{

}
/*---------------------------------------------------------------------------*/
extern "C" void dist_plugin_inf (FileTreeNode *node_point)
{
 plugin_node=new local_pl_info;
 plugin_node->node_of_attach=node_point;
}
/*---------------------------------------------------------------------------*/
extern "C" void read_pl_dir (void)
{
 if (plugin_node!=NULL)
 {
    if (plugin_node->node_of_attach->get_tree_top ()!=NULL)
     plugin_node->node_of_attach->remove_tree ();

    FileTreeNode *new_node=new FileTreeNode (plugin_node->node_of_attach,
                                             NODE_DESKTOP,
                                             NODE_CHILD,
                                             NODE_ISFILE,
                                             "dummy01");
    new_node->set_file_info ("dummy01",
                             0,0, 
                             TRUE,
                             TRUE);
 }
}
/*---------------------------------------------------------------------------*/